/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xri3.impl.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Pattern;
import org.openxri.xri3.impl.parser.ParserException;
import org.openxri.xri3.impl.parser.Rule;
import org.openxri.xri3.impl.parser.Visitor;

public class Parser {
    private String text;
    private int index = 0;
    private boolean trace = false;
    private int level = 0;
    private int error = -1;
    private Stack<String> callStack = new Stack();
    private Stack<String> errorStack = new Stack();
    private static final String newline = System.getProperty("line.separator", "\n");

    public static void main(String[] args) {
        boolean ok;
        Properties arguments = new Properties();
        String error = "";
        boolean bl = ok = args.length > 0;
        if (ok) {
            arguments.setProperty("Trace", "Off");
            arguments.setProperty("Rule", "xri");
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-trace")) {
                    arguments.setProperty("Trace", "On");
                    continue;
                }
                if (args[i].equals("-visitor")) {
                    arguments.setProperty("Visitor", args[++i]);
                    continue;
                }
                if (args[i].equals("-file")) {
                    arguments.setProperty("File", args[++i]);
                    continue;
                }
                if (args[i].equals("-string")) {
                    arguments.setProperty("String", args[++i]);
                    continue;
                }
                if (args[i].equals("-rule")) {
                    arguments.setProperty("Rule", args[++i]);
                    continue;
                }
                error = "unknown argument: " + args[i];
                ok = false;
            }
        }
        if (ok && arguments.getProperty("File") == null && arguments.getProperty("String") == null) {
            error = "insufficient arguments: -file or -string required";
            ok = false;
        }
        if (!ok) {
            System.out.println("error: " + error);
            System.out.println("usage: Parser [-rule rulename] [-trace] <-file file | -string string> [-visitor visitor]");
        } else {
            try {
                Parser parser = new Parser();
                Rule rule = null;
                parser.traceOff();
                if (arguments.getProperty("Trace").equals("On")) {
                    parser.traceOn();
                }
                if (arguments.getProperty("File") != null) {
                    rule = parser.parse(arguments.getProperty("Rule"), new File(arguments.getProperty("File")));
                } else if (arguments.getProperty("String") != null) {
                    rule = parser.parse(arguments.getProperty("Rule"), arguments.getProperty("String"));
                }
                if (arguments.getProperty("Visitor") != null) {
                    Visitor visitor = (Visitor)Class.forName(arguments.getProperty("Visitor")).newInstance();
                    visitor.visit(rule);
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("argument error: " + e.getMessage());
            }
            catch (IOException e) {
                System.out.println("io error: " + e.getMessage());
            }
            catch (ParserException e) {
                System.out.println("parser error: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                System.out.println("visitor error: class not found - " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                System.out.println("visitor error: illegal access - " + e.getMessage());
            }
            catch (InstantiationException e) {
                System.out.println("visitor error: instantiation failure - " + e.getMessage());
            }
        }
    }

    public Rule parse(String rulename, String string) throws IllegalArgumentException, ParserException {
        if (rulename == null) {
            throw new IllegalArgumentException("null rulename");
        }
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        return this.decode(rulename, string);
    }

    public Rule parse(String rulename, InputStream in) throws IllegalArgumentException, IOException, ParserException {
        if (rulename == null) {
            throw new IllegalArgumentException("null rulename");
        }
        if (in == null) {
            throw new IllegalArgumentException("null input stream");
        }
        int ch = 0;
        StringBuffer out = new StringBuffer();
        while ((ch = in.read()) != -1) {
            out.append((char)ch);
        }
        return this.decode(rulename, out.toString());
    }

    public Rule parse(String rulename, File file) throws IllegalArgumentException, IOException, ParserException {
        if (rulename == null) {
            throw new IllegalArgumentException("null rulename");
        }
        if (file == null) {
            throw new IllegalArgumentException("null file");
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        int ch = 0;
        StringBuffer out = new StringBuffer();
        while ((ch = in.read()) != -1) {
            out.append((char)ch);
        }
        in.close();
        return this.decode(rulename, out.toString());
    }

    private void traceOn() {
        this.trace = true;
    }

    private void traceOff() {
        this.trace = false;
    }

    private void push(String function) {
        this.callStack.push(function);
        if (this.trace) {
            System.out.println("-> " + ++this.level + ": " + function + "()");
            System.out.println(this.index + ": " + this.text.substring(this.index, this.index + 10 > this.text.length() ? this.text.length() : this.index + 10).replaceAll("[^\\p{Print}]", " "));
        }
    }

    private void push(String function, String regex) {
        this.callStack.push(function);
        if (this.trace) {
            System.out.println("-> " + ++this.level + ": " + function + "(" + regex + ")");
            System.out.println(this.index + ": " + this.text.substring(this.index, this.index + 10 > this.text.length() ? this.text.length() : this.index + 10).replaceAll("[^\\p{Print}]", " "));
        }
    }

    private void push(String function, String spelling, String regex) {
        this.callStack.push(function);
        if (this.trace) {
            System.out.println("-> " + ++this.level + ": " + function + "(" + spelling + ", " + regex + ")");
            System.out.println(this.index + ": " + this.text.substring(this.index, this.index + 10 > this.text.length() ? this.text.length() : this.index + 10).replaceAll("[^\\p{Print}]", " "));
        }
    }

    private void pop(String function, boolean result, int length) {
        this.callStack.pop();
        if (this.trace) {
            System.out.println("<- " + this.level-- + ": " + function + "(" + (result ? "true," : "false,") + length + ")");
        }
        if (!result) {
            if (this.index > this.error) {
                this.error = this.index;
                this.errorStack = new Stack();
                this.errorStack.addAll(this.callStack);
            }
        } else if (this.index > this.error) {
            this.error = -1;
        }
    }

    private Rule decode(String rulename, String text) throws ParserException {
        this.text = text;
        Rule rule = null;
        if (rulename.equalsIgnoreCase("xri")) {
            rule = this.decode_xri();
        } else if (rulename.equalsIgnoreCase("xri-reference")) {
            rule = this.decode_xri_reference();
        } else if (rulename.equalsIgnoreCase("relative-xri-ref")) {
            rule = this.decode_relative_xri_ref();
        } else if (rulename.equalsIgnoreCase("relative-xri-part")) {
            rule = this.decode_relative_xri_part();
        } else if (rulename.equalsIgnoreCase("xri-hier-part")) {
            rule = this.decode_xri_hier_part();
        } else if (rulename.equalsIgnoreCase("xri-authority")) {
            rule = this.decode_xri_authority();
        } else if (rulename.equalsIgnoreCase("subseg")) {
            rule = this.decode_subseg();
        } else if (rulename.equalsIgnoreCase("global-subseg")) {
            rule = this.decode_global_subseg();
        } else if (rulename.equalsIgnoreCase("local-subseg")) {
            rule = this.decode_local_subseg();
        } else if (rulename.equalsIgnoreCase("gcs-char")) {
            rule = this.decode_gcs_char();
        } else if (rulename.equalsIgnoreCase("lcs-char")) {
            rule = this.decode_lcs_char();
        } else if (rulename.equalsIgnoreCase("literal")) {
            rule = this.decode_literal();
        } else if (rulename.equalsIgnoreCase("literal-nc")) {
            rule = this.decode_literal_nc();
        } else if (rulename.equalsIgnoreCase("xref")) {
            rule = this.decode_xref();
        } else if (rulename.equalsIgnoreCase("xref-empty")) {
            rule = this.decode_xref_empty();
        } else if (rulename.equalsIgnoreCase("xref-xri-reference")) {
            rule = this.decode_xref_xri_reference();
        } else if (rulename.equalsIgnoreCase("xref-IRI")) {
            rule = this.decode_xref_IRI();
        } else if (rulename.equalsIgnoreCase("xri-path")) {
            rule = this.decode_xri_path();
        } else if (rulename.equalsIgnoreCase("xri-path-abempty")) {
            rule = this.decode_xri_path_abempty();
        } else if (rulename.equalsIgnoreCase("xri-path-abs")) {
            rule = this.decode_xri_path_abs();
        } else if (rulename.equalsIgnoreCase("xri-path-noscheme")) {
            rule = this.decode_xri_path_noscheme();
        } else if (rulename.equalsIgnoreCase("xri-segment")) {
            rule = this.decode_xri_segment();
        } else if (rulename.equalsIgnoreCase("xri-segment-nz")) {
            rule = this.decode_xri_segment_nz();
        } else if (rulename.equalsIgnoreCase("xri-segment-nc")) {
            rule = this.decode_xri_segment_nc();
        } else if (rulename.equalsIgnoreCase("xri-pchar")) {
            rule = this.decode_xri_pchar();
        } else if (rulename.equalsIgnoreCase("xri-pchar-nc")) {
            rule = this.decode_xri_pchar_nc();
        } else if (rulename.equalsIgnoreCase("xri-reserved")) {
            rule = this.decode_xri_reserved();
        } else if (rulename.equalsIgnoreCase("xri-gen-delims")) {
            rule = this.decode_xri_gen_delims();
        } else if (rulename.equalsIgnoreCase("xri-sub-delims")) {
            rule = this.decode_xri_sub_delims();
        } else if (rulename.equalsIgnoreCase("IRI")) {
            rule = this.decode_IRI();
        } else if (rulename.equalsIgnoreCase("scheme")) {
            rule = this.decode_scheme();
        } else if (rulename.equalsIgnoreCase("ihier-part")) {
            rule = this.decode_ihier_part();
        } else if (rulename.equalsIgnoreCase("iauthority")) {
            rule = this.decode_iauthority();
        } else if (rulename.equalsIgnoreCase("iuserinfo")) {
            rule = this.decode_iuserinfo();
        } else if (rulename.equalsIgnoreCase("ihost")) {
            rule = this.decode_ihost();
        } else if (rulename.equalsIgnoreCase("IP-literal")) {
            rule = this.decode_IP_literal();
        } else if (rulename.equalsIgnoreCase("IPvFuture")) {
            rule = this.decode_IPvFuture();
        } else if (rulename.equalsIgnoreCase("IPv6address")) {
            rule = this.decode_IPv6address();
        } else if (rulename.equalsIgnoreCase("ls32")) {
            rule = this.decode_ls32();
        } else if (rulename.equalsIgnoreCase("h16")) {
            rule = this.decode_h16();
        } else if (rulename.equalsIgnoreCase("IPv4address")) {
            rule = this.decode_IPv4address();
        } else if (rulename.equalsIgnoreCase("dec-octet")) {
            rule = this.decode_dec_octet();
        } else if (rulename.equalsIgnoreCase("ireg-name")) {
            rule = this.decode_ireg_name();
        } else if (rulename.equalsIgnoreCase("port")) {
            rule = this.decode_port();
        } else if (rulename.equalsIgnoreCase("ipath-abempty")) {
            rule = this.decode_ipath_abempty();
        } else if (rulename.equalsIgnoreCase("ipath-abs")) {
            rule = this.decode_ipath_abs();
        } else if (rulename.equalsIgnoreCase("ipath-rootless")) {
            rule = this.decode_ipath_rootless();
        } else if (rulename.equalsIgnoreCase("ipath-empty")) {
            rule = this.decode_ipath_empty();
        } else if (rulename.equalsIgnoreCase("isegment")) {
            rule = this.decode_isegment();
        } else if (rulename.equalsIgnoreCase("isegment-nz")) {
            rule = this.decode_isegment_nz();
        } else if (rulename.equalsIgnoreCase("iquery")) {
            rule = this.decode_iquery();
        } else if (rulename.equalsIgnoreCase("iprivate")) {
            rule = this.decode_iprivate();
        } else if (rulename.equalsIgnoreCase("ifragment")) {
            rule = this.decode_ifragment();
        } else if (rulename.equalsIgnoreCase("ipchar")) {
            rule = this.decode_ipchar();
        } else if (rulename.equalsIgnoreCase("iunreserved")) {
            rule = this.decode_iunreserved();
        } else if (rulename.equalsIgnoreCase("pct-encoded")) {
            rule = this.decode_pct_encoded();
        } else if (rulename.equalsIgnoreCase("ucschar")) {
            rule = this.decode_ucschar();
        } else if (rulename.equalsIgnoreCase("reserved")) {
            rule = this.decode_reserved();
        } else if (rulename.equalsIgnoreCase("gen-delims")) {
            rule = this.decode_gen_delims();
        } else if (rulename.equalsIgnoreCase("sub-delims")) {
            rule = this.decode_sub_delims();
        } else if (rulename.equalsIgnoreCase("unreserved")) {
            rule = this.decode_unreserved();
        } else if (rulename.equalsIgnoreCase("ALPHA")) {
            rule = this.decode_ALPHA();
        } else if (rulename.equalsIgnoreCase("BIT")) {
            rule = this.decode_BIT();
        } else if (rulename.equalsIgnoreCase("CHAR")) {
            rule = this.decode_CHAR();
        } else if (rulename.equalsIgnoreCase("CR")) {
            rule = this.decode_CR();
        } else if (rulename.equalsIgnoreCase("CRLF")) {
            rule = this.decode_CRLF();
        } else if (rulename.equalsIgnoreCase("CTL")) {
            rule = this.decode_CTL();
        } else if (rulename.equalsIgnoreCase("DIGIT")) {
            rule = this.decode_DIGIT();
        } else if (rulename.equalsIgnoreCase("DQUOTE")) {
            rule = this.decode_DQUOTE();
        } else if (rulename.equalsIgnoreCase("HEXDIG")) {
            rule = this.decode_HEXDIG();
        } else if (rulename.equalsIgnoreCase("HTAB")) {
            rule = this.decode_HTAB();
        } else if (rulename.equalsIgnoreCase("LF")) {
            rule = this.decode_LF();
        } else if (rulename.equalsIgnoreCase("LWSP")) {
            rule = this.decode_LWSP();
        } else if (rulename.equalsIgnoreCase("OCTET")) {
            rule = this.decode_OCTET();
        } else if (rulename.equalsIgnoreCase("SP")) {
            rule = this.decode_SP();
        } else if (rulename.equalsIgnoreCase("VCHAR")) {
            rule = this.decode_VCHAR();
        } else if (rulename.equalsIgnoreCase("WSP")) {
            rule = this.decode_WSP();
        } else {
            throw new IllegalArgumentException("unknown rule");
        }
        if (rule == null) {
            String marker = "                              ";
            StringBuffer errorBuffer = new StringBuffer();
            int start = this.error < 30 ? 0 : this.error - 30;
            int end = text.length() < this.error + 30 ? text.length() : this.error + 30;
            errorBuffer.append("rule \"" + this.errorStack.peek() + "\" failed" + newline);
            errorBuffer.append(text.substring(start, end).replaceAll("[^\\p{Print}]", " ") + newline);
            errorBuffer.append(marker.substring(0, this.error < 30 ? this.error : 30) + "^" + newline);
            errorBuffer.append("rule stack:");
            for (String error : this.errorStack) {
                errorBuffer.append(newline + "  " + error);
            }
            throw new ParserException(errorBuffer.toString());
        }
        if (text.length() > this.index) {
            String marker = "                              ";
            StringBuffer errorBuffer = new StringBuffer();
            int start = this.index < 30 ? 0 : this.index - 30;
            int end = text.length() < this.index + 30 ? text.length() : this.index + 30;
            errorBuffer.append("extra data found" + newline);
            errorBuffer.append(text.substring(start, end).replaceAll("[^\\p{Print}]", " ") + newline);
            errorBuffer.append(marker.substring(0, this.index < 30 ? this.index : 30) + "^" + newline);
            throw new ParserException(errorBuffer.toString());
        }
        return rule;
    }

    private xri decode_xri() {
        Rule rule;
        this.push("xri");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i2;
            int c2;
            boolean f2;
            int s2;
            ArrayList<xri> e2;
            int i1;
            int c1;
            boolean f1;
            ArrayList<xri> e1 = new ArrayList<xri>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_hier_part();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<xri>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("?");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_iquery();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("#");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_ifragment();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri", decoded, this.index - s0);
        return rule;
    }

    private xri_reference decode_xri_reference() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<xri_reference> e1;
        this.push("xri-reference");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<xri_reference>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_reference)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_relative_xri_ref();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_reference)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_reference(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-reference", decoded, this.index - s0);
        return rule;
    }

    private relative_xri_ref decode_relative_xri_ref() {
        Rule rule;
        this.push("relative-xri-ref");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i2;
            int c2;
            boolean f2;
            int s2;
            ArrayList<relative_xri_ref> e2;
            int i1;
            int c1;
            boolean f1;
            ArrayList<relative_xri_ref> e1 = new ArrayList<relative_xri_ref>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_relative_xri_part();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((relative_xri_ref)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<relative_xri_ref>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("?");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((relative_xri_ref)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_iquery();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((relative_xri_ref)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("#");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((relative_xri_ref)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_ifragment();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((relative_xri_ref)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new relative_xri_ref(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("relative-xri-ref", decoded, this.index - s0);
        return rule;
    }

    private relative_xri_part decode_relative_xri_part() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<relative_xri_part> e1;
        this.push("relative-xri-part");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<relative_xri_part>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_path_abs();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((relative_xri_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_path_noscheme();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((relative_xri_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ipath_empty();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((relative_xri_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new relative_xri_part(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("relative-xri-part", decoded, this.index - s0);
        return rule;
    }

    private xri_hier_part decode_xri_hier_part() {
        Rule rule;
        this.push("xri-hier-part");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<xri_hier_part> e1 = new ArrayList<xri_hier_part>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_authority();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_hier_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_path_abempty();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_hier_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_hier_part(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-hier-part", decoded, this.index - s0);
        return rule;
    }

    private xri_authority decode_xri_authority() {
        Rule rule;
        this.push("xri-authority");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int c1;
            boolean f1;
            ArrayList<xri_authority> e1 = new ArrayList<xri_authority>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_global_subseg();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_authority)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                while (f1) {
                    rule = this.decode_subseg();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_authority)rule);
                    ++c1;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_authority(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-authority", decoded, this.index - s0);
        return rule;
    }

    private subseg decode_subseg() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<subseg> e1;
        this.push("subseg");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<subseg>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_global_subseg();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((subseg)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_local_subseg();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((subseg)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xref();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((subseg)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new subseg(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("subseg", decoded, this.index - s0);
        return rule;
    }

    private global_subseg decode_global_subseg() {
        Rule rule;
        this.push("global-subseg");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<global_subseg> e1 = new ArrayList<global_subseg>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_gcs_char();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((global_subseg)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<global_subseg> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<global_subseg>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_local_subseg();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((global_subseg)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_xref();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((global_subseg)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_literal();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((global_subseg)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new global_subseg(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("global-subseg", decoded, this.index - s0);
        return rule;
    }

    private local_subseg decode_local_subseg() {
        Rule rule;
        this.push("local-subseg");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<local_subseg> e1 = new ArrayList<local_subseg>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_lcs_char();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((local_subseg)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<local_subseg> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<local_subseg>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_xref();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((local_subseg)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_literal();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((local_subseg)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new local_subseg(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("local-subseg", decoded, this.index - s0);
        return rule;
    }

    private gcs_char decode_gcs_char() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<gcs_char> e1;
        this.push("gcs-char");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<gcs_char>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("=");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((gcs_char)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("@");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((gcs_char)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("+");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((gcs_char)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("$");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((gcs_char)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new gcs_char(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("gcs-char", decoded, this.index - s0);
        return rule;
    }

    private lcs_char decode_lcs_char() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<lcs_char> e1;
        this.push("lcs-char");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<lcs_char>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("*");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((lcs_char)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("!");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((lcs_char)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new lcs_char(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("lcs-char", decoded, this.index - s0);
        return rule;
    }

    private literal decode_literal() {
        Rule rule;
        this.push("literal");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<literal> e1 = new ArrayList<literal>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_pchar();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((literal)rule);
                    ++c1;
                }
                while (f1) {
                    rule = this.decode_xri_pchar();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((literal)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new literal(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("literal", decoded, this.index - s0);
        return rule;
    }

    private literal_nc decode_literal_nc() {
        Rule rule;
        this.push("literal-nc");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<literal_nc> e1 = new ArrayList<literal_nc>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_pchar_nc();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((literal_nc)rule);
                    ++c1;
                }
                while (f1) {
                    rule = this.decode_xri_pchar_nc();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((literal_nc)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new literal_nc(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("literal-nc", decoded, this.index - s0);
        return rule;
    }

    private xref decode_xref() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<xref> e1;
        this.push("xref");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<xref>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xref_empty();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xref_xri_reference();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xref_IRI();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xref(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xref", decoded, this.index - s0);
        return rule;
    }

    private xref_empty decode_xref_empty() {
        Rule rule;
        this.push("xref-empty");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<xref_empty> e1 = new ArrayList<xref_empty>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("()");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref_empty)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xref_empty(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xref-empty", decoded, this.index - s0);
        return rule;
    }

    private xref_xri_reference decode_xref_xri_reference() {
        Rule rule;
        this.push("xref-xri-reference");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<xref_xri_reference> e1 = new ArrayList<xref_xri_reference>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("(");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref_xri_reference)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_reference();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref_xri_reference)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(")");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref_xri_reference)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xref_xri_reference(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xref-xri-reference", decoded, this.index - s0);
        return rule;
    }

    private xref_IRI decode_xref_IRI() {
        Rule rule;
        this.push("xref-IRI");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<xref_IRI> e1 = new ArrayList<xref_IRI>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("(");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref_IRI)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_IRI();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref_IRI)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(")");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xref_IRI)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xref_IRI(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xref-IRI", decoded, this.index - s0);
        return rule;
    }

    private xri_path decode_xri_path() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<xri_path> e1;
        this.push("xri-path");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<xri_path>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_path_abempty();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_path)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_path_abs();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_path)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_path_noscheme();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_path)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ipath_empty();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_path)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_path(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-path", decoded, this.index - s0);
        return rule;
    }

    private xri_path_abempty decode_xri_path_abempty() {
        Rule rule;
        this.push("xri-path-abempty");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    decoded = false;
                    if (!decoded) {
                        int i2;
                        int c2;
                        boolean f2;
                        ArrayList<xri_path_abempty> e2 = new ArrayList<xri_path_abempty>();
                        int s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("/");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_path_abempty)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_xri_segment();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_path_abempty)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_path_abempty(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-path-abempty", decoded, this.index - s0);
        return rule;
    }

    private xri_path_abs decode_xri_path_abs() {
        Rule rule;
        this.push("xri-path-abs");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<xri_path_abs> e1 = new ArrayList<xri_path_abs>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("/");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_path_abs)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        int c2;
                        boolean f2;
                        ArrayList<xri_path_abs> e2 = new ArrayList<xri_path_abs>();
                        int s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (int i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_xri_segment_nz();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_path_abs)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            while (f2) {
                                decoded = false;
                                if (!decoded) {
                                    int i3;
                                    int c3;
                                    boolean f3;
                                    ArrayList<xri_path_abs> e3 = new ArrayList<xri_path_abs>();
                                    int s3 = this.index;
                                    decoded = true;
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_StringValue("/");
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((xri_path_abs)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_xri_segment();
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((xri_path_abs)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        e2.addAll(e3);
                                    } else {
                                        this.index = s3;
                                    }
                                }
                                if (decoded) {
                                    ++c2;
                                }
                                f2 = decoded;
                            }
                            decoded = true;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_path_abs(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-path-abs", decoded, this.index - s0);
        return rule;
    }

    private xri_path_noscheme decode_xri_path_noscheme() {
        Rule rule;
        this.push("xri-path-noscheme");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int c1;
            boolean f1;
            ArrayList<xri_path_noscheme> e1 = new ArrayList<xri_path_noscheme>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_segment_nc();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_path_noscheme)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                while (f1) {
                    decoded = false;
                    if (!decoded) {
                        int i2;
                        int c2;
                        boolean f2;
                        ArrayList<xri_path_noscheme> e2 = new ArrayList<xri_path_noscheme>();
                        int s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("/");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_path_noscheme)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_xri_segment();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_path_noscheme)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_path_noscheme(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-path-noscheme", decoded, this.index - s0);
        return rule;
    }

    private xri_segment decode_xri_segment() {
        Rule rule;
        this.push("xri-segment");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int c1;
            boolean f1;
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        ArrayList<xri_segment> e2 = new ArrayList<xri_segment>();
                        int s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            boolean f2 = true;
                            int c2 = 0;
                            for (int i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_literal();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_segment)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                while (f1) {
                    rule = this.decode_subseg();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_segment(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-segment", decoded, this.index - s0);
        return rule;
    }

    private xri_segment_nz decode_xri_segment_nz() {
        Rule rule;
        this.push("xri-segment-nz");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int c1;
            boolean f1;
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<xri_segment_nz> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<xri_segment_nz>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_literal();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_segment_nz)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_subseg();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_segment_nz)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                while (f1) {
                    rule = this.decode_subseg();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_segment_nz(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-segment-nz", decoded, this.index - s0);
        return rule;
    }

    private xri_segment_nc decode_xri_segment_nc() {
        Rule rule;
        this.push("xri-segment-nc");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int c1;
            boolean f1;
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<xri_segment_nc> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<xri_segment_nc>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_literal_nc();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_segment_nc)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_subseg();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((xri_segment_nc)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                while (f1) {
                    rule = this.decode_subseg();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_segment_nc(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-segment-nc", decoded, this.index - s0);
        return rule;
    }

    private xri_pchar decode_xri_pchar() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<xri_pchar> e1;
        this.push("xri-pchar");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<xri_pchar>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_iunreserved();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_pchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_pct_encoded();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_pchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_sub_delims();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_pchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(":");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_pchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_pchar(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-pchar", decoded, this.index - s0);
        return rule;
    }

    private xri_pchar_nc decode_xri_pchar_nc() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<xri_pchar_nc> e1;
        this.push("xri-pchar-nc");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<xri_pchar_nc>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_iunreserved();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_pchar_nc)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_pct_encoded();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_pchar_nc)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_sub_delims();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_pchar_nc)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_pchar_nc(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-pchar-nc", decoded, this.index - s0);
        return rule;
    }

    private xri_reserved decode_xri_reserved() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<xri_reserved> e1;
        this.push("xri-reserved");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<xri_reserved>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_gen_delims();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_reserved)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_xri_sub_delims();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_reserved)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_reserved(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-reserved", decoded, this.index - s0);
        return rule;
    }

    private xri_gen_delims decode_xri_gen_delims() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<StringValue> e1;
        this.push("xri-gen-delims");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<StringValue>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(":");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("/");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("?");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("#");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("[");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("]");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("(");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(")");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_gcs_char();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_lcs_char();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_gen_delims(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-gen-delims", decoded, this.index - s0);
        return (xri_gen_delims)rule;
    }

    private xri_sub_delims decode_xri_sub_delims() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<xri_sub_delims> e1;
        this.push("xri-sub-delims");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<xri_sub_delims>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("&");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_sub_delims)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(";");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_sub_delims)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(",");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_sub_delims)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("'");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((xri_sub_delims)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new xri_sub_delims(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("xri-sub-delims", decoded, this.index - s0);
        return rule;
    }

    private IRI decode_IRI() {
        Rule rule;
        this.push("IRI");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i2;
            int c2;
            boolean f2;
            int s2;
            ArrayList<IRI> e2;
            int i1;
            int c1;
            boolean f1;
            ArrayList<IRI> e1 = new ArrayList<IRI>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_scheme();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IRI)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(":");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IRI)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ihier_part();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IRI)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<IRI>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("?");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IRI)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_iquery();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IRI)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("#");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IRI)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_ifragment();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IRI)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new IRI(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("IRI", decoded, this.index - s0);
        return rule;
    }

    private scheme decode_scheme() {
        Rule rule;
        this.push("scheme");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int c1;
            boolean f1;
            ArrayList<scheme> e1 = new ArrayList<scheme>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ALPHA();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((scheme)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                while (f1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    decoded = false;
                    if (!decoded) {
                        ArrayList<scheme> e2 = new ArrayList<scheme>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_ALPHA();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((scheme)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        ArrayList<scheme> e2 = new ArrayList<scheme>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_DIGIT();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((scheme)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        ArrayList<scheme> e2 = new ArrayList<scheme>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("+");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((scheme)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        ArrayList<scheme> e2 = new ArrayList<scheme>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("-");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((scheme)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        ArrayList<scheme> e2 = new ArrayList<scheme>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(".");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((scheme)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new scheme(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("scheme", decoded, this.index - s0);
        return rule;
    }

    private ihier_part decode_ihier_part() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<ihier_part> e1;
        this.push("ihier-part");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<ihier_part>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("//");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihier_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_iauthority();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihier_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ipath_abempty();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihier_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ipath_abs();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihier_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ipath_rootless();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihier_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ipath_empty();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihier_part)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ihier_part(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ihier-part", decoded, this.index - s0);
        return rule;
    }

    private iauthority decode_iauthority() {
        Rule rule;
        this.push("iauthority");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i2;
            int c2;
            boolean f2;
            int s2;
            ArrayList<iauthority> e2;
            int i1;
            int c1;
            boolean f1;
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<iauthority>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_iuserinfo();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iauthority)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("@");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iauthority)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ihost();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iauthority)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_port();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iauthority)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new iauthority(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("iauthority", decoded, this.index - s0);
        return rule;
    }

    private iuserinfo decode_iuserinfo() {
        Rule rule;
        this.push("iuserinfo");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<iuserinfo> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<iuserinfo>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_iunreserved();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iuserinfo)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_pct_encoded();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iuserinfo)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_sub_delims();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iuserinfo)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iuserinfo)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new iuserinfo(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("iuserinfo", decoded, this.index - s0);
        return rule;
    }

    private ihost decode_ihost() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<ihost> e1;
        this.push("ihost");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<ihost>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_IP_literal();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihost)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_IPv4address();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihost)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ireg_name();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ihost)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ihost(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ihost", decoded, this.index - s0);
        return rule;
    }

    private IP_literal decode_IP_literal() {
        Rule rule;
        this.push("IP-literal");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<IP_literal> e1 = new ArrayList<IP_literal>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("[");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IP_literal)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<IP_literal> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<IP_literal>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_IPv6address();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IP_literal)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_IPvFuture();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IP_literal)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("]");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IP_literal)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new IP_literal(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("IP-literal", decoded, this.index - s0);
        return rule;
    }

    private IPvFuture decode_IPvFuture() {
        Rule rule;
        this.push("IPvFuture");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<IPvFuture> e1 = new ArrayList<IPvFuture>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("v");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPvFuture)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_HEXDIG();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPvFuture)rule);
                    ++c1;
                }
                while (f1) {
                    rule = this.decode_HEXDIG();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPvFuture)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(".");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPvFuture)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<IPvFuture> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<IPvFuture>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_unreserved();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IPvFuture)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_sub_delims();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IPvFuture)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IPvFuture)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                while (f1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    decoded = false;
                    if (!decoded) {
                        ArrayList<IPvFuture> e2 = new ArrayList<IPvFuture>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_unreserved();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IPvFuture)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        ArrayList<IPvFuture> e2 = new ArrayList<IPvFuture>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_sub_delims();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IPvFuture)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        ArrayList<IPvFuture> e2 = new ArrayList<IPvFuture>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((IPvFuture)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new IPvFuture(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("IPvFuture", decoded, this.index - s0);
        return rule;
    }

    private IPv6address decode_IPv6address() {
        int i3;
        int c3;
        boolean f3;
        int s3;
        ArrayList<ls32> e3;
        Rule rule;
        int i2;
        int c2;
        boolean f2;
        int s2;
        ArrayList<ls32> e2;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList e1;
        this.push("IPv6address");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 6 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<ls32>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 6;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ls32();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("::");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 5 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 5;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ls32();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("::");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 4 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 4;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ls32();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                decoded = false;
                                if (!decoded) {
                                    e3 = new ArrayList<ls32>();
                                    s3 = this.index;
                                    decoded = true;
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_h16();
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_StringValue(":");
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        e2.addAll(e3);
                                    } else {
                                        this.index = s3;
                                    }
                                }
                                if (decoded) {
                                    ++c2;
                                }
                                f2 = decoded;
                            }
                            decoded = true;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("::");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 3 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 3;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ls32();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 2 && f2; ++i2) {
                                decoded = false;
                                if (!decoded) {
                                    e3 = new ArrayList();
                                    s3 = this.index;
                                    decoded = true;
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_h16();
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_StringValue(":");
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        e2.addAll(e3);
                                    } else {
                                        this.index = s3;
                                    }
                                }
                                if (decoded) {
                                    ++c2;
                                }
                                f2 = decoded;
                            }
                            decoded = true;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("::");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 2 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 2;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ls32();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 3 && f2; ++i2) {
                                decoded = false;
                                if (!decoded) {
                                    e3 = new ArrayList();
                                    s3 = this.index;
                                    decoded = true;
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_h16();
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_StringValue(":");
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        e2.addAll(e3);
                                    } else {
                                        this.index = s3;
                                    }
                                }
                                if (decoded) {
                                    ++c2;
                                }
                                f2 = decoded;
                            }
                            decoded = true;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("::");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_h16();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(":");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ls32();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 4 && f2; ++i2) {
                                decoded = false;
                                if (!decoded) {
                                    e3 = new ArrayList();
                                    s3 = this.index;
                                    decoded = true;
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_h16();
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_StringValue(":");
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        e2.addAll(e3);
                                    } else {
                                        this.index = s3;
                                    }
                                }
                                if (decoded) {
                                    ++c2;
                                }
                                f2 = decoded;
                            }
                            decoded = true;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("::");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ls32();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 5 && f2; ++i2) {
                                decoded = false;
                                if (!decoded) {
                                    e3 = new ArrayList();
                                    s3 = this.index;
                                    decoded = true;
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_h16();
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_StringValue(":");
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        e2.addAll(e3);
                                    } else {
                                        this.index = s3;
                                    }
                                }
                                if (decoded) {
                                    ++c2;
                                }
                                f2 = decoded;
                            }
                            decoded = true;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("::");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_h16();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 6 && f2; ++i2) {
                                decoded = false;
                                if (!decoded) {
                                    e3 = new ArrayList();
                                    s3 = this.index;
                                    decoded = true;
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_h16();
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_StringValue(":");
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ls32)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        e2.addAll(e3);
                                    } else {
                                        this.index = s3;
                                    }
                                }
                                if (decoded) {
                                    ++c2;
                                }
                                f2 = decoded;
                            }
                            decoded = true;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("::");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new IPv6address(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("IPv6address", decoded, this.index - s0);
        return (IPv6address)rule;
    }

    private ls32 decode_ls32() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList e1;
        this.push("ls32");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        int i2;
                        int c2;
                        boolean f2;
                        ArrayList<ls32> e2 = new ArrayList<ls32>();
                        int s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue(":");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_h16();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ls32)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_IPv4address();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add(rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ls32(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ls32", decoded, this.index - s0);
        return rule;
    }

    private h16 decode_h16() {
        Rule rule;
        this.push("h16");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<h16> e1 = new ArrayList<h16>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                int i1;
                boolean f1 = true;
                int c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_HEXDIG();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((h16)rule);
                    ++c1;
                }
                for (i1 = 1; i1 < 4 && f1; ++i1) {
                    rule = this.decode_HEXDIG();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((h16)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new h16(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("h16", decoded, this.index - s0);
        return rule;
    }

    private IPv4address decode_IPv4address() {
        Rule rule;
        this.push("IPv4address");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<IPv4address> e1 = new ArrayList<IPv4address>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_dec_octet();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPv4address)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(".");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPv4address)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_dec_octet();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPv4address)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(".");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPv4address)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_dec_octet();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPv4address)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(".");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPv4address)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_dec_octet();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((IPv4address)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new IPv4address(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("IPv4address", decoded, this.index - s0);
        return rule;
    }

    private dec_octet decode_dec_octet() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<dec_octet> e1;
        this.push("dec-octet");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<dec_octet>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x31-39", "[\\x31-\\x39]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("1");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 2 && f1; ++i1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 2;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("2");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x30-34", "[\\x30-\\x34]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("25");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x30-35", "[\\x30-\\x35]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((dec_octet)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new dec_octet(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("dec-octet", decoded, this.index - s0);
        return rule;
    }

    private ireg_name decode_ireg_name() {
        Rule rule;
        this.push("ireg-name");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<ireg_name> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<ireg_name>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_iunreserved();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ireg_name)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_pct_encoded();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ireg_name)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_sub_delims();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ireg_name)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ireg_name(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ireg-name", decoded, this.index - s0);
        return rule;
    }

    private port decode_port() {
        Rule rule;
        this.push("port");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<port> e1 = new ArrayList<port>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((port)rule);
                    ++c1;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new port(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("port", decoded, this.index - s0);
        return rule;
    }

    private ipath_abempty decode_ipath_abempty() {
        Rule rule;
        this.push("ipath-abempty");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    decoded = false;
                    if (!decoded) {
                        int i2;
                        int c2;
                        boolean f2;
                        ArrayList<ipath_abempty> e2 = new ArrayList<ipath_abempty>();
                        int s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("/");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ipath_abempty)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_isegment();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ipath_abempty)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ipath_abempty(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ipath-abempty", decoded, this.index - s0);
        return rule;
    }

    private ipath_abs decode_ipath_abs() {
        Rule rule;
        this.push("ipath-abs");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<ipath_abs> e1 = new ArrayList<ipath_abs>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("/");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ipath_abs)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    decoded = false;
                    if (!decoded) {
                        int c2;
                        boolean f2;
                        ArrayList<ipath_abs> e2 = new ArrayList<ipath_abs>();
                        int s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (int i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_isegment_nz();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ipath_abs)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            while (f2) {
                                decoded = false;
                                if (!decoded) {
                                    int i3;
                                    int c3;
                                    boolean f3;
                                    ArrayList<ipath_abs> e3 = new ArrayList<ipath_abs>();
                                    int s3 = this.index;
                                    decoded = true;
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_StringValue("/");
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ipath_abs)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        f3 = true;
                                        c3 = 0;
                                        for (i3 = 0; i3 < 1 && f3; ++i3) {
                                            rule = this.decode_isegment();
                                            f3 = rule != null;
                                            if (!f3) continue;
                                            e3.add((ipath_abs)rule);
                                            ++c3;
                                        }
                                        boolean bl = decoded = c3 == 1;
                                    }
                                    if (decoded) {
                                        e2.addAll(e3);
                                    } else {
                                        this.index = s3;
                                    }
                                }
                                if (decoded) {
                                    ++c2;
                                }
                                f2 = decoded;
                            }
                            decoded = true;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ipath_abs(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ipath-abs", decoded, this.index - s0);
        return rule;
    }

    private ipath_rootless decode_ipath_rootless() {
        Rule rule;
        this.push("ipath-rootless");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int c1;
            boolean f1;
            ArrayList<ipath_rootless> e1 = new ArrayList<ipath_rootless>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_isegment_nz();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ipath_rootless)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                while (f1) {
                    decoded = false;
                    if (!decoded) {
                        int i2;
                        int c2;
                        boolean f2;
                        ArrayList<ipath_rootless> e2 = new ArrayList<ipath_rootless>();
                        int s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("/");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ipath_rootless)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_isegment();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ipath_rootless)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ipath_rootless(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ipath-rootless", decoded, this.index - s0);
        return rule;
    }

    private ipath_empty decode_ipath_empty() {
        Rule rule;
        this.push("ipath-empty");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<ipath_empty> e1 = new ArrayList<ipath_empty>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ipath_empty)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ipath_empty(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ipath-empty", decoded, this.index - s0);
        return rule;
    }

    private isegment decode_isegment() {
        Rule rule;
        this.push("isegment");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<isegment> e1 = new ArrayList<isegment>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    rule = this.decode_ipchar();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((isegment)rule);
                    ++c1;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new isegment(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("isegment", decoded, this.index - s0);
        return rule;
    }

    private isegment_nz decode_isegment_nz() {
        Rule rule;
        this.push("isegment-nz");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<isegment_nz> e1 = new ArrayList<isegment_nz>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ipchar();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((isegment_nz)rule);
                    ++c1;
                }
                while (f1) {
                    rule = this.decode_ipchar();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((isegment_nz)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 >= 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new isegment_nz(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("isegment-nz", decoded, this.index - s0);
        return rule;
    }

    private iquery decode_iquery() {
        Rule rule;
        this.push("iquery");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<iquery> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<iquery>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_ipchar();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iquery)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_iprivate();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iquery)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("/");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iquery)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("?");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((iquery)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new iquery(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("iquery", decoded, this.index - s0);
        return rule;
    }

    private iprivate decode_iprivate() {
        Rule rule;
        this.push("iprivate");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<iprivate> e1 = new ArrayList<iprivate>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%xE000-F8FF", "[\\uE000-\\uF8FF]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((iprivate)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new iprivate(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("iprivate", decoded, this.index - s0);
        return rule;
    }

    private ifragment decode_ifragment() {
        Rule rule;
        this.push("ifragment");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<ifragment> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<ifragment>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_ipchar();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ifragment)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("/");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ifragment)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_StringValue("?");
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((ifragment)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ifragment(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ifragment", decoded, this.index - s0);
        return rule;
    }

    private ipchar decode_ipchar() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<ipchar> e1;
        this.push("ipchar");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<ipchar>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_iunreserved();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ipchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_pct_encoded();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ipchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_sub_delims();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ipchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(":");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ipchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("@");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ipchar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ipchar(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ipchar", decoded, this.index - s0);
        return rule;
    }

    private iunreserved decode_iunreserved() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<ALPHA> e1;
        this.push("iunreserved");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<ALPHA>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ALPHA();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("-");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(".");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("_");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("~");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ucschar();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new iunreserved(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("iunreserved", decoded, this.index - s0);
        return (iunreserved)rule;
    }

    private pct_encoded decode_pct_encoded() {
        Rule rule;
        this.push("pct-encoded");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<pct_encoded> e1 = new ArrayList<pct_encoded>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("%");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((pct_encoded)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_HEXDIG();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((pct_encoded)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_HEXDIG();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((pct_encoded)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new pct_encoded(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("pct-encoded", decoded, this.index - s0);
        return rule;
    }

    private ucschar decode_ucschar() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<ucschar> e1;
        this.push("ucschar");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<ucschar>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%xA0-D7FF", "[\\xA0-\\uD7FF]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ucschar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%xF900-FDCF", "[\\uF900-\\uFDCF]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ucschar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%xFDF0-FFEF", "[\\uFDF0-\\uFFEF]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ucschar)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ucschar(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ucschar", decoded, this.index - s0);
        return rule;
    }

    private reserved decode_reserved() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<reserved> e1;
        this.push("reserved");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<reserved>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_gen_delims();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((reserved)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_sub_delims();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((reserved)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new reserved(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("reserved", decoded, this.index - s0);
        return rule;
    }

    private gen_delims decode_gen_delims() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<StringValue> e1;
        this.push("gen-delims");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<StringValue>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(":");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("/");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("?");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("#");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("[");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("]");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("@");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new gen_delims(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("gen-delims", decoded, this.index - s0);
        return (gen_delims)rule;
    }

    private sub_delims decode_sub_delims() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<StringValue> e1;
        this.push("sub-delims");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<StringValue>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("!");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("$");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("&");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("'");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("*");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("+");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(",");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(";");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("=");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((StringValue)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new sub_delims(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("sub-delims", decoded, this.index - s0);
        return (sub_delims)rule;
    }

    private unreserved decode_unreserved() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<ALPHA> e1;
        this.push("unreserved");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<ALPHA>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_ALPHA();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("-");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue(".");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("_");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("~");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new unreserved(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("unreserved", decoded, this.index - s0);
        return (unreserved)rule;
    }

    private ALPHA decode_ALPHA() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<ALPHA> e1;
        this.push("ALPHA");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<ALPHA>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x41-5A", "[\\x41-\\x5A]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x61-7A", "[\\x61-\\x7A]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((ALPHA)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new ALPHA(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("ALPHA", decoded, this.index - s0);
        return rule;
    }

    private BIT decode_BIT() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<BIT> e1;
        this.push("BIT");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<BIT>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("0");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((BIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("1");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((BIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new BIT(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("BIT", decoded, this.index - s0);
        return rule;
    }

    private CHAR decode_CHAR() {
        Rule rule;
        this.push("CHAR");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<CHAR> e1 = new ArrayList<CHAR>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x01-7F", "[\\x01-\\x7F]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((CHAR)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new CHAR(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("CHAR", decoded, this.index - s0);
        return rule;
    }

    private CR decode_CR() {
        Rule rule;
        this.push("CR");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<CR> e1 = new ArrayList<CR>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x0D", "[\\x0D]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((CR)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new CR(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("CR", decoded, this.index - s0);
        return rule;
    }

    private CRLF decode_CRLF() {
        Rule rule;
        this.push("CRLF");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            int i1;
            int c1;
            boolean f1;
            ArrayList<CRLF> e1 = new ArrayList<CRLF>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_CR();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((CRLF)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_LF();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((CRLF)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new CRLF(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("CRLF", decoded, this.index - s0);
        return rule;
    }

    private CTL decode_CTL() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<CTL> e1;
        this.push("CTL");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<CTL>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x00-1F", "[\\x00-\\x1F]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((CTL)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x7F", "[\\x7F]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((CTL)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new CTL(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("CTL", decoded, this.index - s0);
        return rule;
    }

    private DIGIT decode_DIGIT() {
        Rule rule;
        this.push("DIGIT");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<DIGIT> e1 = new ArrayList<DIGIT>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x30-39", "[\\x30-\\x39]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DIGIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new DIGIT(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("DIGIT", decoded, this.index - s0);
        return rule;
    }

    private DQUOTE decode_DQUOTE() {
        Rule rule;
        this.push("DQUOTE");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<DQUOTE> e1 = new ArrayList<DQUOTE>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x22", "[\\x22]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DQUOTE)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new DQUOTE(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("DQUOTE", decoded, this.index - s0);
        return rule;
    }

    private HEXDIG decode_HEXDIG() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<DIGIT> e1;
        this.push("HEXDIG");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<DIGIT>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_DIGIT();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DIGIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("A");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DIGIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("B");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DIGIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("C");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DIGIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("D");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DIGIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("E");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DIGIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_StringValue("F");
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((DIGIT)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new HEXDIG(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("HEXDIG", decoded, this.index - s0);
        return (HEXDIG)rule;
    }

    private HTAB decode_HTAB() {
        Rule rule;
        this.push("HTAB");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<HTAB> e1 = new ArrayList<HTAB>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x09", "[\\x09]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((HTAB)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new HTAB(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("HTAB", decoded, this.index - s0);
        return rule;
    }

    private LF decode_LF() {
        Rule rule;
        this.push("LF");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<LF> e1 = new ArrayList<LF>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x0A", "[\\x0A]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((LF)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new LF(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("LF", decoded, this.index - s0);
        return rule;
    }

    private LWSP decode_LWSP() {
        Rule rule;
        this.push("LWSP");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList e1 = new ArrayList();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                while (f1) {
                    int i2;
                    int c2;
                    boolean f2;
                    int s2;
                    ArrayList<LWSP> e2;
                    decoded = false;
                    if (!decoded) {
                        e2 = new ArrayList<LWSP>();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_WSP();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((LWSP)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (!decoded) {
                        e2 = new ArrayList();
                        s2 = this.index;
                        decoded = true;
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_CRLF();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((LWSP)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            f2 = true;
                            c2 = 0;
                            for (i2 = 0; i2 < 1 && f2; ++i2) {
                                rule = this.decode_WSP();
                                f2 = rule != null;
                                if (!f2) continue;
                                e2.add((LWSP)rule);
                                ++c2;
                            }
                            boolean bl = decoded = c2 == 1;
                        }
                        if (decoded) {
                            e1.addAll(e2);
                        } else {
                            this.index = s2;
                        }
                    }
                    if (decoded) {
                        ++c1;
                    }
                    f1 = decoded;
                }
                decoded = true;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new LWSP(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("LWSP", decoded, this.index - s0);
        return rule;
    }

    private OCTET decode_OCTET() {
        Rule rule;
        this.push("OCTET");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<OCTET> e1 = new ArrayList<OCTET>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x00-FF", "[\\x00-\\xFF]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((OCTET)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new OCTET(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("OCTET", decoded, this.index - s0);
        return rule;
    }

    private SP decode_SP() {
        Rule rule;
        this.push("SP");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<SP> e1 = new ArrayList<SP>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x20", "[\\x20]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((SP)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new SP(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("SP", decoded, this.index - s0);
        return rule;
    }

    private VCHAR decode_VCHAR() {
        Rule rule;
        this.push("VCHAR");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            ArrayList<VCHAR> e1 = new ArrayList<VCHAR>();
            int s1 = this.index;
            decoded = true;
            if (decoded) {
                boolean f1 = true;
                int c1 = 0;
                for (int i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_NumericValue("%x21-7E", "[\\x21-\\x7E]", 1);
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((VCHAR)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new VCHAR(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("VCHAR", decoded, this.index - s0);
        return rule;
    }

    private WSP decode_WSP() {
        Rule rule;
        int i1;
        int c1;
        boolean f1;
        int s1;
        ArrayList<WSP> e1;
        this.push("WSP");
        boolean decoded = true;
        int s0 = this.index;
        ArrayList e0 = new ArrayList();
        decoded = false;
        if (!decoded) {
            e1 = new ArrayList<WSP>();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_SP();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((WSP)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        if (!decoded) {
            e1 = new ArrayList();
            s1 = this.index;
            decoded = true;
            if (decoded) {
                f1 = true;
                c1 = 0;
                for (i1 = 0; i1 < 1 && f1; ++i1) {
                    rule = this.decode_HTAB();
                    f1 = rule != null;
                    if (!f1) continue;
                    e1.add((WSP)rule);
                    ++c1;
                }
                boolean bl = decoded = c1 == 1;
            }
            if (decoded) {
                e0.addAll(e1);
            } else {
                this.index = s1;
            }
        }
        rule = null;
        if (decoded) {
            rule = new WSP(this.text.substring(s0, this.index), e0);
        } else {
            this.index = s0;
        }
        this.pop("WSP", decoded, this.index - s0);
        return rule;
    }

    private StringValue decode_StringValue(String regex) {
        this.push("*StringValue", regex);
        boolean decoded = true;
        int start = this.index;
        StringValue stringValue = null;
        try {
            String value = this.text.substring(this.index, this.index + regex.length());
            decoded = value.equalsIgnoreCase(regex);
            if (decoded) {
                this.index += regex.length();
                stringValue = new StringValue(value, null);
            }
        }
        catch (IndexOutOfBoundsException e) {
            decoded = false;
        }
        this.pop("*StringValue", decoded, this.index - start);
        return stringValue;
    }

    private NumericValue decode_NumericValue(String spelling, String regex, int length) {
        this.push("*NumericValue", spelling, regex);
        boolean decoded = true;
        int start = this.index;
        NumericValue numericValue = null;
        try {
            String value = this.text.substring(this.index, this.index + length);
            decoded = Pattern.matches(regex, value);
            if (decoded) {
                this.index += length;
                numericValue = new NumericValue(value, null);
            }
        }
        catch (IndexOutOfBoundsException e) {
            decoded = false;
        }
        this.pop("*NumericValue", decoded, this.index - start);
        return numericValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WSP
    extends Rule {
        private WSP(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public WSP(WSP rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_WSP(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VCHAR
    extends Rule {
        private VCHAR(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public VCHAR(VCHAR rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_VCHAR(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SP
    extends Rule {
        private SP(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public SP(SP rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_SP(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OCTET
    extends Rule {
        private OCTET(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public OCTET(OCTET rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_OCTET(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LWSP
    extends Rule {
        private LWSP(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public LWSP(LWSP rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_LWSP(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LF
    extends Rule {
        private LF(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public LF(LF rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_LF(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HTAB
    extends Rule {
        private HTAB(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public HTAB(HTAB rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_HTAB(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HEXDIG
    extends Rule {
        private HEXDIG(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public HEXDIG(HEXDIG rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_HEXDIG(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DQUOTE
    extends Rule {
        private DQUOTE(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public DQUOTE(DQUOTE rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_DQUOTE(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DIGIT
    extends Rule {
        private DIGIT(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public DIGIT(DIGIT rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_DIGIT(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CTL
    extends Rule {
        private CTL(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public CTL(CTL rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_CTL(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CRLF
    extends Rule {
        private CRLF(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public CRLF(CRLF rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_CRLF(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CR
    extends Rule {
        private CR(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public CR(CR rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_CR(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CHAR
    extends Rule {
        private CHAR(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public CHAR(CHAR rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_CHAR(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BIT
    extends Rule {
        private BIT(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public BIT(BIT rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_BIT(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ALPHA
    extends Rule {
        private ALPHA(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ALPHA(ALPHA rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ALPHA(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class unreserved
    extends Rule {
        private unreserved(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public unreserved(unreserved rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_unreserved(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class sub_delims
    extends Rule {
        private sub_delims(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public sub_delims(sub_delims rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_sub_delims(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class gen_delims
    extends Rule {
        private gen_delims(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public gen_delims(gen_delims rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_gen_delims(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class reserved
    extends Rule {
        private reserved(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public reserved(reserved rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_reserved(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ucschar
    extends Rule {
        private ucschar(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ucschar(ucschar rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ucschar(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class pct_encoded
    extends Rule {
        private pct_encoded(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public pct_encoded(pct_encoded rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_pct_encoded(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class iunreserved
    extends Rule {
        private iunreserved(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public iunreserved(iunreserved rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_iunreserved(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ipchar
    extends Rule {
        private ipchar(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ipchar(ipchar rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ipchar(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ifragment
    extends Rule {
        private ifragment(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ifragment(ifragment rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ifragment(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class iprivate
    extends Rule {
        private iprivate(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public iprivate(iprivate rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_iprivate(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class iquery
    extends Rule {
        private iquery(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public iquery(iquery rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_iquery(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class isegment_nz
    extends Rule {
        private isegment_nz(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public isegment_nz(isegment_nz rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_isegment_nz(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class isegment
    extends Rule {
        private isegment(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public isegment(isegment rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_isegment(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ipath_empty
    extends Rule {
        private ipath_empty(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ipath_empty(ipath_empty rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ipath_empty(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ipath_rootless
    extends Rule {
        private ipath_rootless(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ipath_rootless(ipath_rootless rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ipath_rootless(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ipath_abs
    extends Rule {
        private ipath_abs(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ipath_abs(ipath_abs rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ipath_abs(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ipath_abempty
    extends Rule {
        private ipath_abempty(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ipath_abempty(ipath_abempty rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ipath_abempty(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class port
    extends Rule {
        private port(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public port(port rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_port(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ireg_name
    extends Rule {
        private ireg_name(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ireg_name(ireg_name rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ireg_name(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class dec_octet
    extends Rule {
        private dec_octet(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public dec_octet(dec_octet rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_dec_octet(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IPv4address
    extends Rule {
        private IPv4address(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public IPv4address(IPv4address rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_IPv4address(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class h16
    extends Rule {
        private h16(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public h16(h16 rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_h16(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ls32
    extends Rule {
        private ls32(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ls32(ls32 rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ls32(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IPv6address
    extends Rule {
        private IPv6address(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public IPv6address(IPv6address rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_IPv6address(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IPvFuture
    extends Rule {
        private IPvFuture(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public IPvFuture(IPvFuture rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_IPvFuture(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IP_literal
    extends Rule {
        private IP_literal(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public IP_literal(IP_literal rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_IP_literal(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ihost
    extends Rule {
        private ihost(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ihost(ihost rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ihost(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class iuserinfo
    extends Rule {
        private iuserinfo(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public iuserinfo(iuserinfo rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_iuserinfo(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class iauthority
    extends Rule {
        private iauthority(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public iauthority(iauthority rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_iauthority(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ihier_part
    extends Rule {
        private ihier_part(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public ihier_part(ihier_part rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_ihier_part(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class scheme
    extends Rule {
        private scheme(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public scheme(scheme rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_scheme(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IRI
    extends Rule {
        private IRI(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public IRI(IRI rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_IRI(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_sub_delims
    extends Rule {
        private xri_sub_delims(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_sub_delims(xri_sub_delims rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_sub_delims(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_gen_delims
    extends Rule {
        private xri_gen_delims(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_gen_delims(xri_gen_delims rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_gen_delims(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_reserved
    extends Rule {
        private xri_reserved(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_reserved(xri_reserved rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_reserved(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_pchar_nc
    extends Rule {
        private xri_pchar_nc(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_pchar_nc(xri_pchar_nc rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_pchar_nc(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_pchar
    extends Rule {
        private xri_pchar(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_pchar(xri_pchar rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_pchar(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_segment_nc
    extends Rule {
        private xri_segment_nc(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_segment_nc(xri_segment_nc rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_segment_nc(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_segment_nz
    extends Rule {
        private xri_segment_nz(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_segment_nz(xri_segment_nz rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_segment_nz(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_segment
    extends Rule {
        private xri_segment(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_segment(xri_segment rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_segment(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_path_noscheme
    extends Rule {
        private xri_path_noscheme(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_path_noscheme(xri_path_noscheme rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_path_noscheme(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_path_abs
    extends Rule {
        private xri_path_abs(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_path_abs(xri_path_abs rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_path_abs(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_path_abempty
    extends Rule {
        private xri_path_abempty(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_path_abempty(xri_path_abempty rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_path_abempty(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_path
    extends Rule {
        private xri_path(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_path(xri_path rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_path(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xref_IRI
    extends Rule {
        private xref_IRI(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xref_IRI(xref_IRI rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xref_IRI(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xref_xri_reference
    extends Rule {
        private xref_xri_reference(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xref_xri_reference(xref_xri_reference rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xref_xri_reference(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xref_empty
    extends Rule {
        private xref_empty(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xref_empty(xref_empty rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xref_empty(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xref
    extends Rule {
        private xref(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xref(xref rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xref(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class literal_nc
    extends Rule {
        private literal_nc(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public literal_nc(literal_nc rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_literal_nc(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class literal
    extends Rule {
        private literal(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public literal(literal rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_literal(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class lcs_char
    extends Rule {
        private lcs_char(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public lcs_char(lcs_char rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_lcs_char(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class gcs_char
    extends Rule {
        private gcs_char(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public gcs_char(gcs_char rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_gcs_char(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class local_subseg
    extends Rule {
        private local_subseg(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public local_subseg(local_subseg rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_local_subseg(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class global_subseg
    extends Rule {
        private global_subseg(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public global_subseg(global_subseg rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_global_subseg(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class subseg
    extends Rule {
        private subseg(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public subseg(subseg rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_subseg(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_authority
    extends Rule {
        private xri_authority(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_authority(xri_authority rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_authority(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_hier_part
    extends Rule {
        private xri_hier_part(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_hier_part(xri_hier_part rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_hier_part(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class relative_xri_part
    extends Rule {
        private relative_xri_part(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public relative_xri_part(relative_xri_part rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_relative_xri_part(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class relative_xri_ref
    extends Rule {
        private relative_xri_ref(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public relative_xri_ref(relative_xri_ref rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_relative_xri_ref(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri_reference
    extends Rule {
        private xri_reference(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri_reference(xri_reference rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri_reference(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class xri
    extends Rule {
        private xri(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        public xri(xri rule) {
            super(rule.spelling, rule.rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_xri(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NumericValue
    extends Rule {
        public NumericValue(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_NumericValue(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StringValue
    extends Rule {
        public StringValue(String spelling, ArrayList<Rule> rules) {
            super(spelling, rules);
        }

        @Override
        public Object visit(Visitor visitor) {
            return visitor.visit_StringValue(this);
        }
    }
}

