/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtils {
    private static ThreadLocal soDOMParser = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new DOMParser();
        }
    };

    public static DOMParser getDOMParser() {
        DOMParser oParser = (DOMParser)soDOMParser.get();
        oParser.reset();
        return oParser;
    }

    public static Element getFirstChildElement(Node oNode, String sNS, String sTag) {
        Element oElem = DOMUtils.getFirstChildElement(oNode);
        while (oElem != null && !DOMUtils.isElementNamed(oElem, sNS, sTag)) {
            oElem = DOMUtils.getNextSiblingElement(oElem);
        }
        return oElem;
    }

    public static Element getNextSiblingElement(Node oNode) {
        Node oNext;
        for (oNext = oNode.getNextSibling(); oNext != null && oNext.getNodeType() != 1; oNext = oNext.getNextSibling()) {
        }
        return (Element)oNext;
    }

    public static boolean isElementNamed(Element oElem, String sNS, String sTag) {
        boolean bMatch;
        if (oElem == null) {
            return false;
        }
        boolean bl = sNS == null ? oElem.getNamespaceURI() == null : (bMatch = sNS.equals(oElem.getNamespaceURI()));
        if (bMatch) {
            bMatch = sTag == null ? oElem.getLocalName() == null : sTag.equals(oElem.getLocalName());
        }
        return bMatch;
    }

    public static Element getFirstChildElement(Node n) {
        Node child;
        for (child = n.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        if (child != null) {
            return (Element)child;
        }
        return null;
    }

    public static String toString(Element oElt) {
        return DOMUtils.toString(oElt, true, false);
    }

    public static String toString(Element oElt, boolean bIndent, boolean bOmitXMLDeclaration) {
        OutputFormat oFormat = new OutputFormat("XML", "UTF-8", bIndent);
        oFormat.setOmitXMLDeclaration(bOmitXMLDeclaration);
        return DOMUtils.toString(oElt, oFormat);
    }

    public static String toString(Element oElt, OutputFormat oFormat) {
        StringWriter oWriter = new StringWriter();
        XMLSerializer oSerialize = new XMLSerializer((Writer)oWriter, oFormat);
        try {
            oElt.getOwnerDocument().normalizeDocument();
            oSerialize.serialize(oElt);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Problem serializing the XML document:\n" + ioe.getMessage());
        }
        return oWriter.toString();
    }

    public static Date fromXMLDateTime(String sTime) throws ParseException {
        int nDot = sTime.indexOf(46);
        SimpleDateFormat oDF = nDot > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        oDF.setTimeZone(TimeZone.getTimeZone("GMT"));
        return oDF.parse(sTime);
    }

    public static String toXMLDateTime(Date oTime) {
        SimpleDateFormat oDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        oDF.setTimeZone(TimeZone.getTimeZone("GMT"));
        return oDF.format(oTime);
    }

    public static String getText(Node root) {
        NodeList list = root.getChildNodes();
        if (list == null && list.getLength() == 0) {
            String str = root.getNodeValue();
            if (str == null) {
                str = "";
            }
            return str;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.getLength(); ++i) {
            String val;
            Node node = list.item(i);
            if (!(node instanceof Text) || (val = ((Text)node).getNodeValue()) == null || val.length() <= 0) continue;
            buf.append(val);
        }
        return buf.toString();
    }

    public static String toString(Document doc) {
        StringWriter str = new StringWriter();
        try {
            OutputFormat out = new OutputFormat(doc);
            out.setIndenting(true);
            out.setIndent(1);
            out.setStandalone(false);
            out.setEncoding("UTF-8");
            out.setLineWidth(0);
            XMLSerializer ser = new XMLSerializer((Writer)str, out);
            doc.normalizeDocument();
            ser.serialize(doc.getDocumentElement());
        }
        catch (Exception e) {
            return null;
        }
        return str.toString();
    }
}

