/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.XRIAbsolutePath;
import org.openxri.XRIParseException;
import org.openxri.resolve.MimeType;
import org.openxri.resolve.ResolverFlags;
import org.openxri.xml.SEPElement;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.Service;

public class SEPSelector {
    private static Log log = LogFactory.getLog((String)Service.class.getName());
    private ArrayList seps = null;
    private String matchTypeValue = null;
    private String matchMediaTypeValue = null;
    private String matchPathValue = null;
    private boolean matchedNonDefaultType = false;
    private boolean matchedNonDefaultMediaType = false;
    private boolean matchedNonDefaultPath = false;
    private ArrayList matchedPhase1List = null;
    private ArrayList indexes = new ArrayList();

    public static List select(List seps, String inType, String inMediaType, String inPath, ResolverFlags flags) {
        int n = seps.size();
        ArrayList<Service> sepOut = new ArrayList<Service>();
        ArrayList<Service> defaultSepOut = new ArrayList<Service>(n);
        boolean noDefaultType = flags.isNoDefaultT();
        boolean noDefaultPath = flags.isNoDefaultP();
        boolean noDefaultMediaType = flags.isNoDefaultM();
        boolean[] positiveType = new boolean[n];
        boolean[] positivePath = new boolean[n];
        boolean[] positiveMediaType = new boolean[n];
        boolean[] defaultType = new boolean[n];
        boolean[] defaultPath = new boolean[n];
        boolean[] defaultMediaType = new boolean[n];
        boolean[] presentType = new boolean[n];
        boolean[] presentPath = new boolean[n];
        boolean[] presentMediaType = new boolean[n];
        log.trace((Object)("select type='" + inType + "' mtype='" + inMediaType + "' path='" + inPath + "' len(SEPs)=" + n));
        for (int i = 0; i < n; ++i) {
            Service sep = (Service)seps.get(i);
            defaultSepOut.add(null);
            log.trace((Object)("SEPSelector.select SEP[" + i + "] = " + sep));
            boolean sepDone = false;
            sepDone = false;
            List sels = sep.getTypes();
            for (SEPType typeSEL : sels) {
                presentType[i] = true;
                if (SEPSelector.matchSEL(typeSEL, inType)) {
                    if (typeSEL.getSelect()) {
                        log.trace((Object)("SEPSelector.select SEP[" + i + "] Type is selected."));
                        sepOut.add(sep);
                        sepDone = true;
                        break;
                    }
                    log.trace((Object)("SEPSelector.select SEP[" + i + "] Type is a positive match."));
                    positiveType[i] = true;
                    continue;
                }
                if (noDefaultType || positiveType[i] || !SEPSelector.isDefaultMatch(typeSEL)) continue;
                log.trace((Object)("SEPSelector.select SEP[" + i + "] Type is a default match."));
                defaultType[i] = true;
            }
            if (sepDone) continue;
            if (!presentType[i] && !noDefaultType) {
                log.trace((Object)("SEPSelector.select SEP[" + i + "] Type is a default match (no Type element found)."));
                defaultType[i] = true;
            }
            sepDone = false;
            sels = sep.getPaths();
            for (SEPPath pathSEL : sels) {
                presentPath[i] = true;
                if (SEPSelector.matchSEL(pathSEL, inPath)) {
                    if (pathSEL.getSelect()) {
                        log.trace((Object)("SEPSelector.select SEP[" + i + "] Path is selected."));
                        sepOut.add(sep);
                        sepDone = true;
                        break;
                    }
                    log.trace((Object)("SEPSelector.select SEP[" + i + "] Path is a positive match."));
                    positivePath[i] = true;
                    continue;
                }
                if (noDefaultPath || positivePath[i] || !SEPSelector.isDefaultMatch(pathSEL)) continue;
                log.trace((Object)("SEPSelector.select SEP[" + i + "] Path is a default match."));
                defaultPath[i] = true;
            }
            if (sepDone) continue;
            if (!presentPath[i] && !noDefaultPath) {
                log.trace((Object)("SEPSelector.select SEP[" + i + "] Path is a default match (no Path element found)."));
                defaultPath[i] = true;
            }
            sepDone = false;
            sels = sep.getMediaTypes();
            for (SEPMediaType mediaTypeSEL : sels) {
                presentMediaType[i] = true;
                if (SEPSelector.matchSEL(mediaTypeSEL, inMediaType)) {
                    if (mediaTypeSEL.getSelect()) {
                        log.trace((Object)("SEPSelector.select SEP[" + i + "] MediaType is selected."));
                        sepOut.add(sep);
                        sepDone = true;
                        break;
                    }
                    log.trace((Object)("SEPSelector.select SEP[" + i + "] MediaType is a positive match."));
                    positiveMediaType[i] = true;
                    continue;
                }
                if (noDefaultMediaType || positiveMediaType[i] || !SEPSelector.isDefaultMatch(mediaTypeSEL)) continue;
                log.trace((Object)("SEPSelector.select SEP[" + i + "] MediaType is a default match."));
                defaultMediaType[i] = true;
            }
            if (sepDone) continue;
            if (!presentMediaType[i] && !noDefaultMediaType) {
                log.trace((Object)("SEPSelector.select SEP[" + i + "] MediaType is a default match (no MediaType element found)."));
                defaultMediaType[i] = true;
            }
            if (positiveType[i] && positivePath[i] && positiveMediaType[i]) {
                log.trace((Object)("SEPSelector.select SEP[" + i + "] is an ALL positive match."));
                sepOut.add(sep);
                continue;
            }
            if (!sepOut.isEmpty() || !positiveType[i] && !defaultType[i] || !positivePath[i] && !defaultPath[i] || !positiveMediaType[i] && !defaultMediaType[i]) continue;
            log.trace((Object)("SEPSelector.select SEP[" + i + "] is a default match."));
            defaultSepOut.set(i, sep);
        }
        if (sepOut.isEmpty()) {
            Object sep;
            int i;
            int[] numMatches = new int[n];
            for (i = 0; i < n; ++i) {
                sep = defaultSepOut.get(i);
                if (sep == null) continue;
                if (positiveType[i]) {
                    int n2 = i;
                    numMatches[n2] = numMatches[n2] + 1;
                }
                if (positivePath[i]) {
                    int n3 = i;
                    numMatches[n3] = numMatches[n3] + 1;
                }
                if (!positiveMediaType[i]) continue;
                int n4 = i;
                numMatches[n4] = numMatches[n4] + 1;
            }
            for (i = 0; i < n; ++i) {
                if (numMatches[i] < 2) continue;
                log.trace((Object)("SEPSelector.select Phase 2 - SEP[" + i + "] is selected for having 2 positive matches."));
                sepOut.add((Service)seps.get(i));
            }
            if (sepOut.isEmpty()) {
                for (i = 0; i < n; ++i) {
                    if (numMatches[i] != 1) continue;
                    log.trace((Object)("SEPSelector.select Phase 2 - SEP[" + i + "] is selected for having 1 positive match."));
                    sepOut.add((Service)seps.get(i));
                }
            }
            if (sepOut.isEmpty()) {
                for (i = 0; i < n; ++i) {
                    sep = defaultSepOut.get(i);
                    if (sep == null) continue;
                    log.trace((Object)("SEPSelector.select Phase 2 - SEP[" + i + "] is selected for being a default match."));
                    sepOut.add((Service)sep);
                }
            }
        }
        return sepOut;
    }

    public static boolean isDefaultMatch(SEPElement sel) {
        String m = sel.getMatch();
        return m != null && m.equals("default");
    }

    private static boolean matchSEL(SEPElement element, String inValue) {
        String matchAttr = element.getMatch();
        String selVal = element.getValue();
        if (matchAttr != null) {
            if (matchAttr.equals("any")) {
                return true;
            }
            if (matchAttr.equals("non-null")) {
                return inValue != null && inValue.length() > 0;
            }
            if (matchAttr.equals("null")) {
                return inValue == null || inValue.length() == 0;
            }
        }
        if (matchAttr == null || matchAttr.equals("content")) {
            if (inValue == null || inValue.length() == 0) {
                return selVal.length() == 0;
            }
            if (element instanceof SEPType) {
                return SEPSelector.matchType(selVal, inValue);
            }
            if (element instanceof SEPPath) {
                return SEPSelector.matchPath(selVal, inValue);
            }
            if (element instanceof SEPMediaType) {
                return SEPSelector.matchMediaType(selVal, inValue);
            }
            throw new RuntimeException("Unsupported SEL");
        }
        return false;
    }

    public static boolean matchType(String selType, String inType) {
        return inType.equals(selType);
    }

    public static boolean matchPath(String selPath, String inPath) {
        if (inPath.equalsIgnoreCase(selPath)) {
            return true;
        }
        log.trace((Object)("xrdPath = '" + selPath + "'"));
        log.trace((Object)("inputPath = '" + inPath + "'"));
        if (selPath.length() > 0 && selPath.charAt(0) != '/') {
            selPath = '/' + selPath;
        }
        try {
            XRIAbsolutePath xrdAbsPath = new XRIAbsolutePath(selPath);
            XRIAbsolutePath inputAbsPath = new XRIAbsolutePath(inPath);
            return xrdAbsPath.isPrefixOf(inputAbsPath);
        }
        catch (XRIParseException e) {
            log.error((Object)("matchPath(selPath='" + selPath + "', inPath='" + inPath + "' - XRIParseException caught: " + e.getMessage()));
            return false;
        }
    }

    public static boolean matchMediaType(String selMediaType, String inMediaType) {
        MimeType candidateMimeType = MimeType.parse(inMediaType);
        MimeType critMimeType = MimeType.parse(selMediaType);
        return critMimeType.equals(candidateMimeType);
    }

    public SEPSelector(ArrayList pSeps) {
        this.seps = pSeps;
    }

    public void reset() {
        this.seps = null;
    }

    public ArrayList getSelectedSEPs(String type, String mediaType, String path) {
        this.matchTypeValue = type;
        this.matchMediaTypeValue = mediaType;
        this.matchPathValue = path;
        this.matchedNonDefaultType = false;
        this.matchedNonDefaultMediaType = false;
        this.matchedNonDefaultPath = false;
        this.matchedPhase1List = new ArrayList();
        this.applyMatchingRules();
        this.removeMatchDefaults();
        this.applySelectionRules();
        ArrayList returnList = new ArrayList();
        for (int i = 0; i < this.seps.size(); ++i) {
            Integer inx = new Integer(i);
            if (this.indexes.contains(inx)) continue;
            returnList.add(this.seps.get(i));
        }
        this.matchedPhase1List.clear();
        this.indexes.clear();
        return returnList;
    }

    private boolean applyMatchingRules() {
        try {
            for (int i = 0; i < this.seps.size(); ++i) {
                SEPElement element;
                int j;
                SEPElement element2;
                int j2;
                Service service = (Service)this.seps.get(i);
                service = (Service)service.clone();
                Vector<SEPElement> types = service.getTypes();
                Vector<SEPElement> mtypes = service.getMediaTypes();
                Vector<SEPElement> paths = service.getPaths();
                Vector elements = new Vector();
                if (types.size() == 0) {
                    SEPType type = new SEPType(null, "default", Boolean.FALSE);
                    service.addType(type);
                    types = service.getTypes();
                }
                if (mtypes.size() == 0) {
                    SEPMediaType mtype = new SEPMediaType(null, "default", Boolean.FALSE);
                    service.addMediaType(mtype);
                    mtypes = service.getMediaTypes();
                }
                if (paths.size() == 0) {
                    SEPPath path = new SEPPath(null, "default", Boolean.FALSE);
                    service.addPath(path);
                    paths = service.getPaths();
                }
                elements.addAll(service.getTypes());
                elements.addAll(service.getMediaTypes());
                elements.addAll(service.getPaths());
                boolean foundMatchNone = false;
                for (j2 = 0; j2 < elements.size(); ++j2) {
                    element2 = (SEPElement)elements.get(j2);
                    if (element2.getMatch() == null || !element2.getMatch().equals("none")) continue;
                    foundMatchNone = true;
                }
                if (foundMatchNone) {
                    this.matchedPhase1List.add(null);
                    continue;
                }
                for (j2 = 0; j2 < elements.size(); ++j2) {
                    element2 = (SEPElement)elements.get(j2);
                    if (element2.getMatch() != null && !element2.getMatch().equals("")) continue;
                    element2.setMatch("content");
                }
                Vector<SEPElement> output = new Vector<SEPElement>();
                for (j = 0; j < types.size(); ++j) {
                    element = (SEPElement)types.get(j);
                    if (element.getMatch().equals("default")) {
                        output.add(element);
                        continue;
                    }
                    if (!this.match(element)) continue;
                    this.matchedNonDefaultType = true;
                    output.add(element);
                }
                types = output;
                service.setTypes(types);
                output = new Vector();
                for (j = 0; j < mtypes.size(); ++j) {
                    element = (SEPElement)mtypes.get(j);
                    if (element.getMatch().equals("default")) {
                        output.add(element);
                        continue;
                    }
                    if (!this.match(element)) continue;
                    this.matchedNonDefaultMediaType = true;
                    output.add(element);
                }
                mtypes = output;
                service.setMediaTypes(mtypes);
                output = new Vector();
                for (j = 0; j < paths.size(); ++j) {
                    element = (SEPElement)paths.get(j);
                    if (element.getMatch().equals("default")) {
                        output.add(element);
                        continue;
                    }
                    if (!this.match(element)) continue;
                    this.matchedNonDefaultPath = true;
                    output.add(element);
                }
                paths = output;
                service.setPaths(paths);
                this.matchedPhase1List.add(service);
            }
        }
        catch (CloneNotSupportedException cnse) {
            log.error((Object)"This should not happen as we implemented Service.clone() - the only clone call we make here");
            throw new RuntimeException("Internal error: " + cnse.getMessage());
        }
        return true;
    }

    private boolean removeMatchDefaults() {
        for (int i = 0; i < this.matchedPhase1List.size(); ++i) {
            SEPElement element;
            int j;
            Service sep = (Service)this.matchedPhase1List.get(i);
            if (sep == null) continue;
            if (this.matchedNonDefaultType) {
                Vector<SEPElement> newTypes = new Vector<SEPElement>();
                for (j = 0; j < sep.getTypes().size(); ++j) {
                    element = (SEPElement)sep.getTypes().get(j);
                    if (!element.getMatch().equals("default")) {
                        newTypes.add(element);
                        continue;
                    }
                    log.trace((Object)("removeMatchDefaults - removing Type[" + j + "] from Service[" + i + "]"));
                }
                sep.setTypes(newTypes);
            }
            if (this.matchedNonDefaultPath) {
                Vector<SEPElement> newPaths = new Vector<SEPElement>();
                for (j = 0; j < sep.getPaths().size(); ++j) {
                    element = (SEPElement)sep.getPaths().get(j);
                    if (!element.getMatch().equals("default")) {
                        newPaths.add(element);
                        continue;
                    }
                    log.trace((Object)("removeMatchDefaults - removing Path[" + j + "] from Service[" + i + "]"));
                }
                sep.setPaths(newPaths);
            }
            if (!this.matchedNonDefaultMediaType) continue;
            Vector<SEPElement> newMediaTypes = new Vector<SEPElement>();
            for (j = 0; j < sep.getMediaTypes().size(); ++j) {
                element = (SEPElement)sep.getMediaTypes().get(j);
                if (!element.getMatch().equals("default")) {
                    newMediaTypes.add(element);
                    continue;
                }
                log.trace((Object)("removeMatchDefaults - removing MediaType[" + j + "] from Service[" + i + "]"));
            }
            sep.setMediaTypes(newMediaTypes);
        }
        return true;
    }

    private boolean applySelectionRules() {
        for (int i = 0; i < this.matchedPhase1List.size(); ++i) {
            Service sep = (Service)this.matchedPhase1List.get(i);
            if (sep == null) {
                log.debug((Object)("applySelectionRules - service[" + i + "] is inactive"));
                continue;
            }
            if (!this.canBeSelected(sep)) {
                log.debug((Object)("applySelectionRules - service[" + i + "] will not be selected"));
                this.indexes.add(new Integer(i));
                continue;
            }
            log.debug((Object)("applySelectionRules - service[" + i + "] is good to go"));
        }
        return true;
    }

    private boolean canBeSelected(Service service) {
        Vector elements = new Vector();
        elements.addAll(service.getTypes());
        elements.addAll(service.getMediaTypes());
        elements.addAll(service.getPaths());
        boolean typeMatched = false;
        boolean mediaTypeMatched = false;
        boolean pathMatched = false;
        boolean selectService = false;
        for (int i = 0; i < elements.size(); ++i) {
            SEPElement element = (SEPElement)elements.get(i);
            if (element.getMatch().equals("none")) {
                return false;
            }
            if (element.getSelect()) {
                selectService = true;
            }
            if (element instanceof SEPType) {
                typeMatched = true;
                continue;
            }
            if (element instanceof SEPMediaType) {
                mediaTypeMatched = true;
                continue;
            }
            if (!(element instanceof SEPPath)) continue;
            pathMatched = true;
        }
        return selectService || typeMatched && mediaTypeMatched && pathMatched;
    }

    private boolean match(SEPElement element) {
        String elementMatch = element.getMatch();
        String elementValue = element.getValue();
        String matchElementValue = null;
        if (element instanceof SEPType) {
            matchElementValue = this.matchTypeValue;
        } else if (element instanceof SEPMediaType) {
            matchElementValue = this.matchMediaTypeValue;
        } else if (element instanceof SEPPath) {
            matchElementValue = this.matchPathValue;
        }
        if (elementMatch.equals("content")) {
            if (matchElementValue == null && elementValue == null) {
                return true;
            }
            if (matchElementValue != null && elementValue == null) {
                return false;
            }
            if (matchElementValue == null && elementValue != null) {
                return false;
            }
            return this.matchContent(element);
        }
        if (elementMatch.equals("any")) {
            return true;
        }
        if (elementMatch.equals("non-null")) {
            return matchElementValue != null && matchElementValue.length() != 0;
        }
        if (elementMatch.equals("null")) {
            return matchElementValue == null || matchElementValue.length() == 0;
        }
        if (elementMatch.equals("none")) {
            return false;
        }
        return false;
    }

    public boolean matchContent(SEPElement candidate) {
        if (candidate instanceof SEPType) {
            return this.matchContent((SEPType)candidate);
        }
        if (candidate instanceof SEPPath) {
            return this.matchContent((SEPPath)candidate);
        }
        if (candidate instanceof SEPMediaType) {
            return this.matchContent((SEPMediaType)candidate);
        }
        return false;
    }

    public boolean matchContent(SEPType type) {
        return this.matchTypeValue.equals(type.getValue());
    }

    public boolean matchContent(SEPPath path) {
        String xrdPath = this.trimPath(path.getValue());
        String inputPath = this.trimPath(this.matchPathValue);
        if (inputPath.equalsIgnoreCase(xrdPath)) {
            return true;
        }
        log.trace((Object)("xrdPath = '" + xrdPath + "'"));
        log.trace((Object)("inputPath = '" + inputPath + "'"));
        XRIAbsolutePath xrdAbsPath = new XRIAbsolutePath("/" + xrdPath);
        XRIAbsolutePath inputAbsPath = new XRIAbsolutePath("/" + inputPath);
        return xrdAbsPath.isPrefixOf(inputAbsPath);
    }

    public boolean matchContent(SEPMediaType mtype) {
        MimeType candidateMimeType = MimeType.parse(mtype.getValue());
        MimeType critMimeType = MimeType.parse(this.matchMediaTypeValue);
        return critMimeType.equals(candidateMimeType);
    }

    private String trimPath(String path) {
        char last;
        StringBuffer sb = new StringBuffer(path.trim());
        while (sb.length() > 0 && ((last = sb.charAt(sb.length() - 1)) == '/' || last == '*' || last == '!')) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

