/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;

public class ForwardingService
extends Service {
    public static final String SERVICE_TYPE = "xri://+i-service*(+forwarding)*($v*1.0)";
    public static final String INDEX_PATH = "(+index)";
    public static final String[] RECOMMENDED_PERSONAL_DICTIONARY = new String[]{"+blog", "+call", "+chat", "+email", "+home", "+links", "+photos", "+resume", "+songs", "+work"};
    public static final String[] RECOMMENDED_ORGANIZATIONAL_DICTIONARY = new String[]{"+about", "+account", "+blog", "+call", "+chat", "+customer.service", "+email", "+home", "+investor.relations", "+links"};

    public ForwardingService(URI[] forwardingPages, String providerID, boolean makeDefault, boolean useIndexPath) {
        if (providerID != null) {
            this.setProviderId(providerID);
        }
        if (useIndexPath) {
            this.addPath(new SEPPath(INDEX_PATH, null, Boolean.TRUE));
        }
        this.addPath(new SEPPath(null, "non-null", null));
        if (makeDefault) {
            this.addPath(new SEPPath(null, "null", null));
        }
        this.addType(new SEPType(SERVICE_TYPE, null, Boolean.TRUE));
        this.addType(new SEPType(null, "null", null));
        this.addMediaType(new SEPMediaType(null, "default", null));
        for (int i = 0; i < forwardingPages.length; ++i) {
            URI forwardingPage = forwardingPages[i];
            try {
                this.addURI(new SEPUri(forwardingPage.toString(), null, "qxri"));
                continue;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    public ForwardingService(URI forwardingPage, String providerID, boolean makeDefault, boolean useIndexPath) {
        this(new URI[]{forwardingPage}, providerID, makeDefault, useIndexPath);
    }

    public ForwardingService(URI[] forwardingPages, String providerID, boolean makeDefault) {
        this(forwardingPages, providerID, makeDefault, true);
    }

    public ForwardingService(URI forwardingPage, String providerID, boolean makeDefault) {
        this(new URI[]{forwardingPage}, providerID, makeDefault, true);
    }

    public ForwardingService(URI[] forwardingPages, String providerID) {
        this(forwardingPages, providerID, true, true);
    }

    public ForwardingService(URI forwardingPage, String providerID) {
        this(new URI[]{forwardingPage}, providerID, true, true);
    }

    public ForwardingService(URI[] forwardingPages) {
        this(forwardingPages, null, true, true);
    }

    public ForwardingService(URI forwardingPage) {
        this(new URI[]{forwardingPage}, null, true, true);
    }

    public static boolean isInstance(Service service) {
        if (service instanceof ForwardingService) {
            return true;
        }
        List serviceTypes = service.getTypes();
        for (int i = 0; i < serviceTypes.size(); ++i) {
            SEPType serviceType = (SEPType)serviceTypes.get(i);
            if (!SERVICE_TYPE.equals(serviceType.getValue())) continue;
            return true;
        }
        return false;
    }
}

