/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.vertx;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.transport.Transport;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.ZitiAddress;
import org.openziti.ZitiContext;
import org.openziti.netty.ZitiChannelFactory;
import org.openziti.netty.ZitiServerChannelFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J*\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0007H\u0016J\u0018\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lorg/openziti/vertx/ZitiTransport;", "Lio/vertx/core/spi/transport/Transport;", "ztx", "Lorg/openziti/ZitiContext;", "(Lorg/openziti/ZitiContext;)V", "binding", "", "", "Lorg/openziti/ZitiAddress$Bind;", "(Lorg/openziti/ZitiContext;Ljava/util/Map;)V", "getBinding", "()Ljava/util/Map;", "getZtx", "()Lorg/openziti/ZitiContext;", "channelFactory", "Lio/netty/channel/ChannelFactory;", "Lio/netty/channel/Channel;", "domainSocket", "", "convert", "address", "Lio/vertx/core/net/SocketAddress;", "Ljava/net/SocketAddress;", "datagramChannel", "Lio/netty/channel/socket/DatagramChannel;", "family", "Lio/netty/channel/socket/InternetProtocolFamily;", "eventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "type", "nThreads", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "ioRatio", "serverChannelFactory", "Lio/netty/channel/ServerChannel;", "ziti-vertx"})
public final class ZitiTransport
implements Transport {
    @NotNull
    private final ZitiContext ztx;
    @NotNull
    private final Map<Integer, ZitiAddress.Bind> binding;

    public ZitiTransport(@NotNull ZitiContext ztx, @NotNull Map<Integer, ZitiAddress.Bind> binding) {
        Intrinsics.checkNotNullParameter((Object)ztx, (String)"ztx");
        Intrinsics.checkNotNullParameter(binding, (String)"binding");
        this.ztx = ztx;
        this.binding = binding;
    }

    @NotNull
    public final ZitiContext getZtx() {
        return this.ztx;
    }

    @NotNull
    public final Map<Integer, ZitiAddress.Bind> getBinding() {
        return this.binding;
    }

    public ZitiTransport(@NotNull ZitiContext ztx) {
        Intrinsics.checkNotNullParameter((Object)ztx, (String)"ztx");
        this(ztx, MapsKt.emptyMap());
    }

    @NotNull
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        return (ChannelFactory)new ZitiChannelFactory(this.ztx);
    }

    @NotNull
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        return (ChannelFactory)new ZitiServerChannelFactory(this.ztx, this.binding);
    }

    @NotNull
    public EventLoopGroup eventLoopGroup(int type, int nThreads, @Nullable ThreadFactory threadFactory, int ioRatio) {
        return (EventLoopGroup)new DefaultEventLoopGroup(nThreads, threadFactory);
    }

    @NotNull
    public DatagramChannel datagramChannel() {
        throw new IllegalStateException("Not supported".toString());
    }

    @NotNull
    public DatagramChannel datagramChannel(@Nullable InternetProtocolFamily family) {
        throw new IllegalStateException("Not supported".toString());
    }

    @Nullable
    public ZitiAddress.Bind convert(@Nullable SocketAddress address) {
        ZitiAddress.Bind bind;
        SocketAddress socketAddress = address;
        if (socketAddress != null) {
            SocketAddress it = socketAddress;
            boolean bl = false;
            bind = this.binding.get(it.port());
        } else {
            bind = null;
        }
        return bind;
    }

    @Nullable
    public SocketAddress convert(@Nullable java.net.SocketAddress address) {
        return address instanceof ZitiAddress.Session ? SocketAddress.domainSocketAddress((String)(((ZitiAddress.Session)address).getService() + "/" + ((ZitiAddress.Session)address).getCallerId())) : super.convert(address);
    }
}

