/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.vertx;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.transport.Transport;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.ZitiAddress;
import org.openziti.ZitiContext;
import org.openziti.netty.ZitiChannelFactory;
import org.openziti.netty.ZitiServerChannelFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u0018\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0014\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0014\u0010!\u001a\u0004\u0018\u00010#2\b\u0010\"\u001a\u0004\u0018\u00010$H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/openziti/vertx/ZitiTransport;", "Lio/vertx/core/spi/transport/Transport;", "ztx", "Lorg/openziti/ZitiContext;", "binding", "", "", "Lorg/openziti/ZitiAddress$Bind;", "<init>", "(Lorg/openziti/ZitiContext;Ljava/util/Map;)V", "(Lorg/openziti/ZitiContext;)V", "getZtx", "()Lorg/openziti/ZitiContext;", "getBinding", "()Ljava/util/Map;", "channelFactory", "Lio/netty/channel/ChannelFactory;", "Lio/netty/channel/Channel;", "domainSocket", "", "serverChannelFactory", "Lio/netty/channel/ServerChannel;", "eventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "type", "nThreads", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "ioRatio", "datagramChannel", "Lio/netty/channel/socket/DatagramChannel;", "family", "Lio/netty/channel/socket/InternetProtocolFamily;", "convert", "address", "Lio/vertx/core/net/SocketAddress;", "Ljava/net/SocketAddress;", "ziti-vertx"})
public final class ZitiTransport
implements Transport {
    @NotNull
    private final ZitiContext ztx;
    @NotNull
    private final Map<Integer, ZitiAddress.Bind> binding;

    public ZitiTransport(@NotNull ZitiContext ztx, @NotNull Map<Integer, ZitiAddress.Bind> binding) {
        Intrinsics.checkNotNullParameter((Object)ztx, (String)"ztx");
        Intrinsics.checkNotNullParameter(binding, (String)"binding");
        this.ztx = ztx;
        this.binding = binding;
    }

    @NotNull
    public final ZitiContext getZtx() {
        return this.ztx;
    }

    @NotNull
    public final Map<Integer, ZitiAddress.Bind> getBinding() {
        return this.binding;
    }

    public ZitiTransport(@NotNull ZitiContext ztx) {
        Intrinsics.checkNotNullParameter((Object)ztx, (String)"ztx");
        this(ztx, MapsKt.emptyMap());
    }

    @NotNull
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        return (ChannelFactory)new ZitiChannelFactory(this.ztx);
    }

    @NotNull
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        return (ChannelFactory)new ZitiServerChannelFactory(this.ztx, this.binding);
    }

    @NotNull
    public EventLoopGroup eventLoopGroup(int type, int nThreads, @Nullable ThreadFactory threadFactory, int ioRatio) {
        return (EventLoopGroup)new DefaultEventLoopGroup(nThreads, threadFactory);
    }

    @NotNull
    public DatagramChannel datagramChannel() {
        throw new IllegalStateException("Not supported".toString());
    }

    @NotNull
    public DatagramChannel datagramChannel(@Nullable InternetProtocolFamily family) {
        throw new IllegalStateException("Not supported".toString());
    }

    @Nullable
    public ZitiAddress.Bind convert(@Nullable SocketAddress address) {
        ZitiAddress.Bind bind;
        SocketAddress socketAddress = address;
        if (socketAddress != null) {
            SocketAddress it = socketAddress;
            boolean bl = false;
            bind = this.binding.get(it.port());
        } else {
            bind = null;
        }
        return bind;
    }

    @Nullable
    public SocketAddress convert(@Nullable java.net.SocketAddress address) {
        return address instanceof ZitiAddress.Session ? SocketAddress.domainSocketAddress((String)(((ZitiAddress.Session)address).getService() + "/" + ((ZitiAddress.Session)address).getCallerId())) : super.convert(address);
    }
}

