/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.nio;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.AsynchronousSocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.internal.ZitiSSLSocket;
import org.openziti.net.nio.AsyncSocketImpl;
import org.openziti.net.nio.AsyncTLSChannelSocket;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/openziti/net/nio/AsyncTLSSocketFactory;", "Ljavax/net/ssl/SSLSocketFactory;", "()V", "ssl", "Ljavax/net/ssl/SSLContext;", "(Ljavax/net/ssl/SSLContext;)V", "getImplMethod", "Ljava/lang/reflect/Method;", "implField", "Ljava/lang/reflect/Field;", "getSsl", "()Ljavax/net/ssl/SSLContext;", "createSocket", "Ljava/net/Socket;", "host", "Ljava/net/InetAddress;", "port", "", "address", "localAddress", "localPort", "transport", "", "autoClose", "", "localHost", "getDefaultCipherSuites", "", "()[Ljava/lang/String;", "getSupportedCipherSuites", "ziti"})
public final class AsyncTLSSocketFactory
extends SSLSocketFactory {
    private final Method getImplMethod;
    private final Field implField;
    @NotNull
    private final SSLContext ssl;

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        SSLEngine sSLEngine = this.ssl.createSSLEngine();
        Intrinsics.checkNotNullExpressionValue((Object)sSLEngine, (String)"ssl.createSSLEngine()");
        String[] stringArray = sSLEngine.getEnabledCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ssl.createSSLEngine().enabledCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        SSLEngine sSLEngine = this.ssl.createSSLEngine();
        Intrinsics.checkNotNullExpressionValue((Object)sSLEngine, (String)"ssl.createSSLEngine()");
        String[] stringArray = sSLEngine.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ssl.createSSLEngine().supportedCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull Socket transport, @NotNull String host, int port, boolean autoClose) {
        Object impl;
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Object object = this.getImplMethod;
        if (object == null || (object = ((Method)object).invoke((Object)transport, new Object[0])) == null) {
            Field field = this.implField;
            object = impl = field != null ? field.get(transport) : null;
        }
        if (impl instanceof AsyncSocketImpl) {
            AsynchronousSocketChannel ch = ((AsyncSocketImpl)impl).getChannel$ziti();
            return new AsyncTLSChannelSocket(ch, host, port, this.ssl);
        }
        SSLEngine sSLEngine = this.ssl.createSSLEngine(host, port);
        Intrinsics.checkNotNullExpressionValue((Object)sSLEngine, (String)"ssl.createSSLEngine(host, port)");
        return new ZitiSSLSocket(transport, sSLEngine);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable String host, int port) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), null, this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port, @Nullable InetAddress localHost, int localPort) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), new InetSocketAddress(localHost, localPort), this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress host, int port) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), null, this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress address, int port, @Nullable InetAddress localAddress, int localPort) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(address, port), new InetSocketAddress(localAddress, localPort), this.ssl);
    }

    @NotNull
    public final SSLContext getSsl() {
        return this.ssl;
    }

    public AsyncTLSSocketFactory(@NotNull SSLContext ssl) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        this.ssl = ssl;
        Method m = null;
        try {
            Method method2 = Socket.class.getDeclaredMethod("getImpl", new Class[0]);
            boolean bl2 = false;
            bl = false;
            Method $this$apply = method2;
            boolean bl3 = false;
            $this$apply.setAccessible(true);
            m = method2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Field f2 = null;
        try {
            Field field = Socket.class.getDeclaredField("impl");
            bl = false;
            boolean bl4 = false;
            Field $this$apply = field;
            boolean bl5 = false;
            $this$apply.setAccessible(true);
            f2 = field;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.implField = f2;
        this.getImplMethod = m;
    }

    public AsyncTLSSocketFactory() {
        SSLContext sSLContext = SSLContext.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"SSLContext.getDefault()");
        this(sSLContext);
    }
}

