/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.identity;

import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.net.URI;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.jetbrains.annotations.NotNull;
import org.openziti.identity.IdentityConfig;
import org.openziti.util.CertsKt;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"findIdentityAlias", "", "ks", "Ljava/security/KeyStore;", "keystoreFromConfig", "id", "Lorg/openziti/identity/IdentityConfig;", "loadKeystore", "f", "Ljava/io/File;", "pwd", "", "ziti"})
public final class UtilKt {
    @NotNull
    public static final String findIdentityAlias(@NotNull KeyStore ks) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Enumeration<String> enumeration = ks.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"ks.aliases()");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            String a = (String)iterator.next();
            if (!ks.isKeyEntry(a)) continue;
            String string = a;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"a");
            return string;
        }
        String string = "no suitable key entry";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    public static final KeyStore keystoreFromConfig(@NotNull IdentityConfig id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(null);
        List<X509Certificate> certs = CertsKt.readCerts(StringsKt.replace$default((String)id.getId().getCert(), (String)"pem:", (String)"", (boolean)false, (int)4, null));
        URI ztAPI = URI.create(id.getZtAPI());
        Principal principal = certs.get(0).getSubjectDN();
        Intrinsics.checkNotNullExpressionValue((Object)principal, (String)"certs[0].subjectDN");
        RDN rDN = new X500Name(principal.getName()).getRDNs(BCStyle.CN)[0];
        Intrinsics.checkNotNullExpressionValue((Object)rDN, (String)"X500Name(certs[0].subjec\u2026e).getRDNs(BCStyle.CN)[0]");
        AttributeTypeAndValue attributeTypeAndValue = rDN.getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)attributeTypeAndValue, (String)"X500Name(certs[0].subjec\u2026RDNs(BCStyle.CN)[0].first");
        String name = attributeTypeAndValue.getValue().toASN1Primitive().toString();
        StringBuilder stringBuilder = new StringBuilder().append("ziti://");
        URI uRI = ztAPI;
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"ztAPI");
        String alias = stringBuilder.append(uRI.getHost()).append(':').append(ztAPI.getPort()).append('/').append(name).toString();
        String string = StringsKt.replace$default((String)id.getId().getKey(), (String)"pem:", (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        PrivateKey key = CertsKt.readKey(new StringReader(string));
        Collection $this$toTypedArray$iv = certs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
        if (x509CertificateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        KeyStore.PrivateKeyEntry keyEntry = new KeyStore.PrivateKeyEntry(key, x509CertificateArray);
        ks.setEntry(alias, keyEntry, new KeyStore.PasswordProtection(new char[0]));
        String string2 = id.getId().getCa();
        if (string2 != null) {
            String string3 = string2;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string3;
            boolean bl4 = false;
            List<X509Certificate> cacerts = CertsKt.readCerts(StringsKt.replace$default((String)it, (String)"pem:", (String)"", (boolean)false, (int)4, null));
            for (X509Certificate ca : cacerts) {
                String caAlias = alias + "-ca-" + ca.getSerialNumber();
                ks.setCertificateEntry(caAlias, ca);
            }
        }
        KeyStore keyStore = ks;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"ks");
        return keyStore;
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull File f2, @NotNull char[] pwd) {
        Intrinsics.checkNotNullParameter((Object)f2, (String)"f");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        ZitiLog log = new ZitiLog();
        KeyStore ks = KeyStore.getInstance("PKCS12");
        try {
            File file = f2;
            boolean bl = false;
            ks.load(new FileInputStream(file), pwd);
            KeyStore keyStore = ks;
            Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"ks");
            return keyStore;
        }
        catch (Exception exception) {
            try {
                IdentityConfig id = IdentityConfig.Companion.load(f2);
                return UtilKt.keystoreFromConfig(id);
            }
            catch (Exception ex) {
                log.w("failed to load identity config: " + ex.getLocalizedMessage());
                throw (Throwable)new IllegalArgumentException("unsupported format");
            }
        }
    }
}

