/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import org.bouncycastle.crypto.params.DESParameters;

public class DESedeParameters
extends DESParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public DESedeParameters(byte[] byArray) {
        super(byArray);
        if (DESedeParameters.isWeakKey(byArray, 0, byArray.length)) {
            throw new IllegalArgumentException("attempt to create weak DESede key");
        }
    }

    public static boolean isWeakKey(byte[] byArray, int n, int n2) {
        for (int k = n; k < n2; k += 8) {
            if (!DESParameters.isWeakKey(byArray, k)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWeakKey(byte[] byArray, int n) {
        return DESedeParameters.isWeakKey(byArray, n, byArray.length - n);
    }

    public static boolean isRealEDEKey(byte[] byArray, int n) {
        return byArray.length == 16 ? DESedeParameters.isReal2Key(byArray, n) : DESedeParameters.isReal3Key(byArray, n);
    }

    public static boolean isReal2Key(byte[] byArray, int n) {
        boolean bl = false;
        for (int k = n; k != n + 8; ++k) {
            if (byArray[k] == byArray[k + 8]) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isReal3Key(byte[] byArray, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int k = n; k != n + 8; ++k) {
            bl |= byArray[k] != byArray[k + 8];
            bl2 |= byArray[k] != byArray[k + 16];
            bl3 |= byArray[k + 8] != byArray[k + 16];
        }
        return bl && bl2 && bl3;
    }
}

