/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

public final class ByteUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ByteUtils() {
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return byArray2 == null;
        }
        if (byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        for (int k = byArray.length - 1; k >= 0; --k) {
            bl &= byArray[k] == byArray2[k];
        }
        return bl;
    }

    public static boolean equals(byte[][] byArray, byte[][] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        for (int k = byArray.length - 1; k >= 0; --k) {
            bl &= ByteUtils.equals(byArray[k], byArray2[k]);
        }
        return bl;
    }

    public static boolean equals(byte[][][] byArray, byte[][][] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        boolean bl = true;
        for (int k = byArray.length - 1; k >= 0; --k) {
            if (byArray[k].length != byArray2[k].length) {
                return false;
            }
            for (int i2 = byArray[k].length - 1; i2 >= 0; --i2) {
                bl &= ByteUtils.equals(byArray[k][i2], byArray2[k][i2]);
            }
        }
        return bl;
    }

    public static int deepHashCode(byte[] byArray) {
        int n = 1;
        for (int k = 0; k < byArray.length; ++k) {
            n = 31 * n + byArray[k];
        }
        return n;
    }

    public static int deepHashCode(byte[][] byArray) {
        int n = 1;
        for (int k = 0; k < byArray.length; ++k) {
            n = 31 * n + ByteUtils.deepHashCode(byArray[k]);
        }
        return n;
    }

    public static int deepHashCode(byte[][][] byArray) {
        int n = 1;
        for (int k = 0; k < byArray.length; ++k) {
            n = 31 * n + ByteUtils.deepHashCode(byArray[k]);
        }
        return n;
    }

    public static byte[] clone(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static byte[] fromHexString(String string) {
        char[] cArray = string.toUpperCase().toCharArray();
        int n = 0;
        for (int k = 0; k < cArray.length; ++k) {
            if ((cArray[k] < '0' || cArray[k] > '9') && (cArray[k] < 'A' || cArray[k] > 'F')) continue;
            ++n;
        }
        byte[] byArray = new byte[n + 1 >> 1];
        int n2 = n & 1;
        for (int k = 0; k < cArray.length; ++k) {
            if (cArray[k] >= '0' && cArray[k] <= '9') {
                int n3 = n2 >> 1;
                byArray[n3] = (byte)(byArray[n3] << 4);
                int n4 = n2 >> 1;
                byArray[n4] = (byte)(byArray[n4] | cArray[k] - 48);
            } else {
                if (cArray[k] < 'A' || cArray[k] > 'F') continue;
                int n5 = n2 >> 1;
                byArray[n5] = (byte)(byArray[n5] << 4);
                int n6 = n2 >> 1;
                byArray[n6] = (byte)(byArray[n6] | cArray[k] - 65 + 10);
            }
            ++n2;
        }
        return byArray;
    }

    public static String toHexString(byte[] byArray) {
        String string = "";
        for (int k = 0; k < byArray.length; ++k) {
            string = string + HEX_CHARS[byArray[k] >>> 4 & 0xF];
            string = string + HEX_CHARS[byArray[k] & 0xF];
        }
        return string;
    }

    public static String toHexString(byte[] byArray, String string, String string2) {
        String string3 = new String(string);
        for (int k = 0; k < byArray.length; ++k) {
            string3 = string3 + HEX_CHARS[byArray[k] >>> 4 & 0xF];
            string3 = string3 + HEX_CHARS[byArray[k] & 0xF];
            if (k >= byArray.length - 1) continue;
            string3 = string3 + string2;
        }
        return string3;
    }

    public static String toBinaryString(byte[] byArray) {
        String string = "";
        for (int k = 0; k < byArray.length; ++k) {
            byte by = byArray[k];
            for (int i2 = 0; i2 < 8; ++i2) {
                int n = by >>> i2 & 1;
                string = string + n;
            }
            if (k == byArray.length - 1) continue;
            string = string + " ";
        }
        return string;
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int k = byArray.length - 1; k >= 0; --k) {
            byArray3[k] = (byte)(byArray[k] ^ byArray2[k]);
        }
        return byArray3;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] concatenate(byte[][] byArray) {
        int n = byArray[0].length;
        byte[] byArray2 = new byte[byArray.length * n];
        int n2 = 0;
        for (int k = 0; k < byArray.length; ++k) {
            System.arraycopy(byArray[k], 0, byArray2, n2, n);
            n2 += n;
        }
        return byArray2;
    }

    public static byte[][] split(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        if (n > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[][] byArrayArray = new byte[][]{new byte[n], new byte[byArray.length - n]};
        System.arraycopy(byArray, 0, byArrayArray[0], 0, n);
        System.arraycopy(byArray, n, byArrayArray[1], 0, byArray.length - n);
        return byArrayArray;
    }

    public static byte[] subArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2 - n];
        System.arraycopy(byArray, n, byArray2, 0, n2 - n);
        return byArray2;
    }

    public static byte[] subArray(byte[] byArray, int n) {
        return ByteUtils.subArray(byArray, n, byArray.length);
    }

    public static char[] toCharArray(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int k = 0; k < byArray.length; ++k) {
            cArray[k] = (char)byArray[k];
        }
        return cArray;
    }
}

