/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.dns;

import java.io.Writer;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.dns.DNSResolver;
import org.openziti.util.IPUtil;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u000201B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u001c\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\t2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\nH\u0002J\u0015\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b$J\u0015\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b)J\u0012\u0010*\u001a\u0004\u0018\u00010\u00112\u0006\u0010&\u001a\u00020\tH\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00112\u0006\u0010&\u001a\u00020\tH\u0002J\u0015\u0010,\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b/R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000e0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager;", "Lorg/openziti/net/dns/DNSResolver;", "()V", "PREFIX", "", "getPREFIX$ziti", "()[B", "domains", "", "", "Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "getDomains$ziti", "()Ljava/util/Map;", "host2Ip", "Lorg/openziti/net/dns/ZitiDNSManager$Entry;", "getHost2Ip$ziti", "ip2host", "Ljava/net/InetAddress;", "getIp2host$ziti", "postfix", "Ljava/util/concurrent/atomic/AtomicInteger;", "getPostfix$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "startPostfix", "", "dump", "", "writer", "Ljava/io/Writer;", "lookup", "addr", "nextAddr", "dnsname", "domain", "registerDomain", "domainName", "registerDomain$ziti", "registerHostname", "hostname", "registerHostname$ziti", "reset", "reset$ziti", "resolve", "resolveOrAssign", "unregisterDomain", "unregisterDomain$ziti", "unregisterHostname", "unregisterHostname$ziti", "Domain", "Entry", "ziti"})
public final class ZitiDNSManager
implements DNSResolver {
    @NotNull
    public static final ZitiDNSManager INSTANCE = new ZitiDNSManager();
    @NotNull
    private static final byte[] PREFIX;
    public static final int startPostfix = 257;
    @NotNull
    private static final AtomicInteger postfix;
    @NotNull
    private static final Map<String, Entry> host2Ip;
    @NotNull
    private static final Map<InetAddress, Entry> ip2host;
    @NotNull
    private static final Map<String, Domain> domains;

    private ZitiDNSManager() {
    }

    @NotNull
    public final byte[] getPREFIX$ziti() {
        return PREFIX;
    }

    @NotNull
    public final AtomicInteger getPostfix$ziti() {
        return postfix;
    }

    @NotNull
    public final Map<String, Entry> getHost2Ip$ziti() {
        return host2Ip;
    }

    @NotNull
    public final Map<InetAddress, Entry> getIp2host$ziti() {
        return ip2host;
    }

    @NotNull
    public final Map<String, Domain> getDomains$ziti() {
        return domains;
    }

    @NotNull
    public final InetAddress registerHostname$ziti(@NotNull String hostname) {
        InetAddress inetAddress;
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        if (IPUtil.isValidIPv4(hostname)) {
            inetAddress = Inet4Address.getByName(hostname);
        } else if (IPUtil.isValidIPv6(hostname)) {
            inetAddress = Inet6Address.getByName(hostname);
        } else {
            Entry entry;
            Map<String, Entry> $this$getOrPut$iv = host2Ip;
            boolean $i$f$getOrPut = false;
            Entry value$iv = $this$getOrPut$iv.get(hostname);
            if (value$iv == null) {
                boolean bl = false;
                Entry e2 = ZitiDNSManager.nextAddr$default(INSTANCE, hostname, null, 2, null);
                Map<InetAddress, Entry> map2 = INSTANCE.getIp2host$ziti();
                InetAddress inetAddress2 = e2.getAddr();
                boolean bl2 = false;
                map2.put(inetAddress2, e2);
                Entry answer$iv = e2;
                $this$getOrPut$iv.put(hostname, answer$iv);
                entry = answer$iv;
            } else {
                entry = value$iv;
            }
            Entry entry2 = entry;
            inetAddress = entry2.getAddr();
        }
        InetAddress ip = inetAddress;
        Intrinsics.checkNotNullExpressionValue(ip, "ip");
        return ip;
    }

    public final void unregisterHostname$ziti(@NotNull String hostname) {
        Entry e2;
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        Entry entry = e2 = host2Ip.remove(hostname);
        if (entry != null) {
            Entry entry2 = entry;
            boolean bl = false;
            boolean bl2 = false;
            Entry it = entry2;
            boolean bl3 = false;
            INSTANCE.getIp2host$ziti().remove(e2.getAddr());
        }
    }

    public final void registerDomain$ziti(@NotNull String domainName) {
        String string;
        boolean bl;
        int n;
        String string2;
        Intrinsics.checkNotNullParameter(domainName, "domainName");
        if (StringsKt.startsWith$default(domainName, "*.", false, 2, null)) {
            string2 = domainName;
            n = 2;
            bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default(domainName, ".", false, 2, null)) {
            string2 = domainName;
            n = 1;
            bl = false;
            String string4 = string2.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
        } else {
            string = domainName;
        }
        string2 = string;
        n = 0;
        String string5 = string2;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        String key = string6;
        domains.putIfAbsent(key, new Domain(Intrinsics.stringPlus("*.", key)));
    }

    /*
     * WARNING - void declaration
     */
    public final void unregisterDomain$ziti(@NotNull String domainName) {
        String string;
        boolean bl;
        int n;
        String string2;
        Intrinsics.checkNotNullParameter(domainName, "domainName");
        if (StringsKt.startsWith$default(domainName, "*.", false, 2, null)) {
            string2 = domainName;
            n = 2;
            bl = false;
            String string3 = string2.substring(n);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default(domainName, ".", false, 2, null)) {
            string2 = domainName;
            n = 1;
            bl = false;
            String string4 = string2.substring(n);
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
        } else {
            string = domainName;
        }
        string2 = string;
        n = 0;
        String string5 = string2;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        String key = string6;
        Domain domain = domains.remove(key);
        if (domain != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = host2Ip.values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entry it = (Entry)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getDomain() == domain)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List entries2 = (List)destination$iv$iv;
            Iterable $this$forEach$iv = entries2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry it = (Entry)element$iv;
                boolean bl3 = false;
                INSTANCE.getHost2Ip$ziti().remove(it.getName());
                INSTANCE.getIp2host$ziti().remove(it.getAddr());
            }
        }
    }

    @Override
    @Nullable
    public InetAddress resolve(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        String string = hostname;
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return this.resolveOrAssign(string2);
    }

    private final InetAddress resolveOrAssign(String hostname) {
        Object object;
        Entry entry = host2Ip.get(hostname);
        if (entry != null) {
            Entry entry2 = entry;
            boolean bl = false;
            boolean bl2 = false;
            Entry it = entry2;
            boolean bl3 = false;
            return it.getAddr();
        }
        String name = hostname;
        do {
            if ((object = domains.get(name)) != null) {
                Domain domain = object;
                boolean bl = false;
                boolean bl4 = false;
                Domain it = domain;
                boolean bl5 = false;
                Entry entry3 = INSTANCE.nextAddr(hostname, it);
                Map<Object, Entry> map2 = INSTANCE.getIp2host$ziti();
                InetAddress inetAddress = entry3.getAddr();
                boolean bl6 = false;
                map2.put(inetAddress, entry3);
                map2 = INSTANCE.getHost2Ip$ziti();
                boolean bl7 = false;
                map2.put((InetAddress)((Object)hostname), entry3);
                return entry3.getAddr();
            }
            name = StringsKt.substringAfter(name, '.', "");
            object = name;
            boolean bl = false;
        } while (object.length() > 0);
        return null;
    }

    @Override
    @Nullable
    public String lookup(@NotNull InetAddress addr) {
        Intrinsics.checkNotNullParameter(addr, "addr");
        Entry entry = ip2host.get(addr);
        return entry == null ? null : entry.getName();
    }

    private final Entry nextAddr(String dnsname, Domain domain) {
        int nextPostfix = postfix.incrementAndGet();
        if ((nextPostfix & 0xFF) == 0) {
            nextPostfix = postfix.incrementAndGet();
        }
        Object object = new byte[]{(byte)(nextPostfix >> 8 & 0xFF), (byte)(nextPostfix & 0xFF)};
        byte[] ip = ArraysKt.plus(PREFIX, object);
        object = InetAddress.getByAddress(dnsname, ip);
        Intrinsics.checkNotNullExpressionValue(object, "getByAddress(dnsname, ip)");
        return new Entry(dnsname, (InetAddress)object, domain);
    }

    static /* synthetic */ Entry nextAddr$default(ZitiDNSManager zitiDNSManager, String string, Domain domain, int n, Object object) {
        if ((n & 2) != 0) {
            domain = null;
        }
        return zitiDNSManager.nextAddr(string, domain);
    }

    public final void reset$ziti() {
        host2Ip.clear();
        ip2host.clear();
        postfix.set(257);
    }

    @Override
    public void dump(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Object object = host2Ip;
        boolean bl = false;
        Iterator<Map.Entry<String, Entry>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Appendable appendable;
            Object object2 = object = iterator2.next();
            boolean bl2 = false;
            String h = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            Entry ip = (Entry)object3.getValue();
            object3 = writer;
            CharSequence charSequence = h + " -> " + ip;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue(object3.append(charSequence), "append(value)");
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append('\\n')");
        }
    }

    static {
        byte[] byArray = new byte[]{100, 64};
        PREFIX = byArray;
        postfix = new AtomicInteger(257);
        boolean bl = false;
        host2Ip = new LinkedHashMap();
        bl = false;
        ip2host = new LinkedHashMap();
        bl = false;
        domains = new LinkedHashMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "ziti"})
    public static final class Domain {
        @NotNull
        private final String name;

        public Domain(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager$Entry;", "", "name", "", "addr", "Ljava/net/InetAddress;", "domain", "Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "(Ljava/lang/String;Ljava/net/InetAddress;Lorg/openziti/net/dns/ZitiDNSManager$Domain;)V", "getAddr", "()Ljava/net/InetAddress;", "getDomain", "()Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "getName", "()Ljava/lang/String;", "repr", "getRepr", "repr$delegate", "Lkotlin/Lazy;", "toString", "ziti"})
    public static final class Entry {
        @NotNull
        private final String name;
        @NotNull
        private final InetAddress addr;
        @Nullable
        private final Domain domain;
        @NotNull
        private final Lazy repr$delegate;

        public Entry(@NotNull String name, @NotNull InetAddress addr, @Nullable Domain domain) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(addr, "addr");
            this.name = name;
            this.addr = addr;
            this.domain = domain;
            this.repr$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
                final /* synthetic */ Entry this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    Object object;
                    Object object2;
                    Object object3 = this.this$0.getDomain();
                    if (object3 == null) {
                        object2 = null;
                    } else {
                        Domain domain = object3;
                        Entry entry = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        Domain it = domain;
                        boolean bl3 = false;
                        object2 = entry.getAddr() + " [" + it.getName() + ']';
                    }
                    Object object4 = object2;
                    if (object4 == null) {
                        object3 = this.this$0.getAddr().toString();
                        Intrinsics.checkNotNullExpressionValue(object3, "addr.toString()");
                        object = object3;
                    } else {
                        object = object4;
                    }
                    return object;
                }
            });
        }

        public /* synthetic */ Entry(String string, InetAddress inetAddress, Domain domain, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                domain = null;
            }
            this(string, inetAddress, domain);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final InetAddress getAddr() {
            return this.addr;
        }

        @Nullable
        public final Domain getDomain() {
            return this.domain;
        }

        private final String getRepr() {
            Lazy lazy = this.repr$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public String toString() {
            return this.getRepr();
        }
    }
}

