/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.crypto;

import com.goterl.lazysodium.interfaces.SecretStream;
import com.goterl.lazysodium.utils.Key;
import com.goterl.lazysodium.utils.SessionPair;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.crypto.Crypto;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u0005\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/openziti/crypto/StreamImpl;", "Lorg/openziti/crypto/Crypto$SecretStream;", "pair", "Lcom/goterl/lazysodium/utils/SessionPair;", "(Lcom/goterl/lazysodium/utils/SessionPair;)V", "header", "Ljava/util/concurrent/atomic/AtomicReference;", "", "kotlin.jvm.PlatformType", "getHeader", "()Ljava/util/concurrent/atomic/AtomicReference;", "rxKey", "getRxKey", "()[B", "setRxKey", "([B)V", "rxState", "Lcom/goterl/lazysodium/interfaces/SecretStream$State;", "getRxState", "()Lcom/goterl/lazysodium/interfaces/SecretStream$State;", "setRxState", "(Lcom/goterl/lazysodium/interfaces/SecretStream$State;)V", "txState", "getTxState", "decrypt", "b", "encrypt", "init", "", "peerHeader", "initialized", "", "ziti"})
public final class StreamImpl
implements Crypto.SecretStream {
    @NotNull
    private final AtomicReference<byte[]> header;
    @NotNull
    private final SecretStream.State txState;
    @Nullable
    private byte[] rxKey;
    public SecretStream.State rxState;

    public StreamImpl(@NotNull SessionPair pair) {
        Intrinsics.checkNotNullParameter(pair, "pair");
        this.header = new AtomicReference<byte[]>(new byte[24]);
        this.rxKey = pair.getRx();
        new SecureRandom().nextBytes(this.header.get());
        SecretStream.State state2 = Crypto.INSTANCE.getSodium$ziti().cryptoSecretStreamInitPush(this.header.get(), Key.fromBytes(pair.getTx()));
        Intrinsics.checkNotNullExpressionValue(state2, "Crypto.sodium.cryptoSecr\u2026, Key.fromBytes(pair.tx))");
        this.txState = state2;
    }

    @NotNull
    public final AtomicReference<byte[]> getHeader() {
        return this.header;
    }

    @NotNull
    public final SecretStream.State getTxState() {
        return this.txState;
    }

    @Nullable
    public final byte[] getRxKey() {
        return this.rxKey;
    }

    public final void setRxKey(@Nullable byte[] byArray) {
        this.rxKey = byArray;
    }

    @NotNull
    public final SecretStream.State getRxState() {
        SecretStream.State state2 = this.rxState;
        if (state2 != null) {
            return state2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("rxState");
        return null;
    }

    public final void setRxState(@NotNull SecretStream.State state2) {
        Intrinsics.checkNotNullParameter(state2, "<set-?>");
        this.rxState = state2;
    }

    @Override
    @NotNull
    public byte[] header() {
        byte[] byArray = this.header.getAndSet(null);
        if (byArray != null) {
            byte[] it = byArray;
            boolean bl = false;
            return it;
        }
        throw new IllegalStateException("header was already consumed".toString());
    }

    @Override
    public boolean initialized() {
        return this.rxState != null;
    }

    @Override
    public void init(@NotNull byte[] peerHeader) {
        Intrinsics.checkNotNullParameter(peerHeader, "peerHeader");
        if (this.rxKey != null) {
            byte[] it = this.rxKey;
            boolean bl = false;
            SecretStream.State rxs = new SecretStream.State();
            Crypto.INSTANCE.getSodium$ziti().cryptoSecretStreamInitPull(rxs, peerHeader, it);
            this.setRxState(rxs);
            Arrays.fill(it, (byte)0);
            this.setRxKey(null);
            return;
        }
        throw new IllegalStateException("rxState was already initialized".toString());
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        byte[] cipher = new byte[b.length + 17];
        Crypto.INSTANCE.getSodium$ziti().cryptoSecretStreamPush(this.txState, cipher, b, b.length, (byte)0);
        return cipher;
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter(b, "b");
        byte[] plain = new byte[b.length - 17];
        Crypto.INSTANCE.getSodium$ziti().cryptoSecretStreamPull(this.getRxState(), plain, null, b, b.length);
        return plain;
    }
}

