/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.identity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.jetbrains.annotations.NotNull;
import org.openziti.identity.IdentityConfig;
import org.openziti.util.CertsKt;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0000\u00a8\u0006\u000e"}, d2={"findIdentityAlias", "", "ks", "Ljava/security/KeyStore;", "keystoreFromConfig", "id", "Lorg/openziti/identity/IdentityConfig;", "loadKeystore", "f", "Ljava/io/File;", "pwd", "", "i", "", "ziti"})
public final class UtilKt {
    @NotNull
    public static final String findIdentityAlias(@NotNull KeyStore ks) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Enumeration<String> enumeration = ks.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"ks.aliases()");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            String a = (String)iterator.next();
            if (!ks.isKeyEntry(a)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
            return a;
        }
        throw new IllegalStateException("no suitable key entry".toString());
    }

    @NotNull
    public static final KeyStore keystoreFromConfig(@NotNull IdentityConfig id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(null);
        List<X509Certificate> certs = CertsKt.readCerts(StringsKt.replace$default((String)id.getId().getCert(), (String)"pem:", (String)"", (boolean)false, (int)4, null));
        URI ztAPI = URI.create(id.getZtAPI());
        String name = new X500Name(certs.get(0).getSubjectDN().getName()).getRDNs(BCStyle.CN)[0].getFirst().getValue().toASN1Primitive().toString();
        String alias = "ziti://" + ztAPI.getHost() + ':' + ztAPI.getPort() + '/' + name;
        PrivateKey key = CertsKt.readKey(new StringReader(StringsKt.replace$default((String)id.getId().getKey(), (String)"pem:", (String)"", (boolean)false, (int)4, null)));
        Collection $this$toTypedArray$iv = certs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
        if (x509CertificateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        KeyStore.PrivateKeyEntry keyEntry = new KeyStore.PrivateKeyEntry(key, x509CertificateArray);
        ks.setEntry(alias, keyEntry, new KeyStore.PasswordProtection(new char[0]));
        String string = id.getId().getCa();
        if (string != null) {
            String it = string;
            boolean bl = false;
            List<X509Certificate> cacerts = CertsKt.readCerts(StringsKt.replace$default((String)it, (String)"pem:", (String)"", (boolean)false, (int)4, null));
            for (X509Certificate ca : cacerts) {
                String caAlias = alias + "-ca-" + ca.getSerialNumber();
                ks.setCertificateEntry(caAlias, ca);
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)ks, (String)"ks");
        return ks;
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull byte[] i2) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        ZitiLog log = new ZitiLog();
        try {
            InputStream inputStream = new ByteArrayInputStream(i2);
            Charset charset = Charsets.UTF_8;
            IdentityConfig id = IdentityConfig.Companion.load(new InputStreamReader(inputStream, charset));
            return UtilKt.keystoreFromConfig(id);
        }
        catch (Exception ex) {
            log.w(Intrinsics.stringPlus((String)"failed to load identity config: ", (Object)ex.getLocalizedMessage()));
            throw new IllegalArgumentException("unsupported format");
        }
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull File f, @NotNull char[] pwd) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        ZitiLog log = new ZitiLog();
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException("Failed to parse keystore.  " + f.getAbsolutePath() + " does not exist or can not be read");
        }
        KeyStore ks = KeyStore.getInstance("PKCS12");
        try {
            ks.load(new FileInputStream(f), pwd);
            Intrinsics.checkNotNullExpressionValue((Object)ks, (String)"ks");
            return ks;
        }
        catch (Exception ex) {
            log.t(Intrinsics.stringPlus((String)"Failed to parse identity file as a keystore, trying to load it as a plain identity config instead: ", (Object)ex.getLocalizedMessage()));
            try {
                IdentityConfig id = IdentityConfig.Companion.load(f);
                return UtilKt.keystoreFromConfig(id);
            }
            catch (Exception ex2) {
                log.w(Intrinsics.stringPlus((String)"failed to load identity config: ", (Object)ex2.getLocalizedMessage()));
                throw new IllegalArgumentException("unsupported format");
            }
        }
    }
}

