/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Platform;

public class LastErrorException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int errorCode;

    private static String formatMessage(int code) {
        return Platform.isWindows() ? "GetLastError() returned " + code : "errno was " + code;
    }

    private static String parseMessage(String m) {
        try {
            return LastErrorException.formatMessage(Integer.parseInt(m));
        }
        catch (NumberFormatException e2) {
            return m;
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public LastErrorException(String msg2) {
        super(LastErrorException.parseMessage(msg2.trim()));
        try {
            if (msg2.startsWith("[")) {
                msg2 = msg2.substring(1, msg2.indexOf("]"));
            }
            this.errorCode = Integer.parseInt(msg2);
        }
        catch (NumberFormatException e2) {
            this.errorCode = -1;
        }
    }

    public LastErrorException(int code) {
        this(code, LastErrorException.formatMessage(code));
    }

    protected LastErrorException(int code, String msg2) {
        super(msg2);
        this.errorCode = code;
    }
}

