/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.internal;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketImpl;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002LMB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0012\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0016J\u001a\u0010\u0014\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\tH\u0016J#\u0010#\u001a\u0002H$\"\u0004\b\u0000\u0010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u0002H$\u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020\u0017H\u0016J\b\u0010,\u001a\u00020!H\u0016J\b\u0010-\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020\u0017H\u0016J\b\u0010/\u001a\u00020\u0017H\u0016J\b\u00100\u001a\u00020\tH\u0016J\b\u00101\u001a\u00020\u0017H\u0016J\b\u00102\u001a\u00020\tH\u0016J\b\u00103\u001a\u00020\tH\u0016J\b\u00104\u001a\u00020\tH\u0016J\b\u00105\u001a\u00020\tH\u0016J\b\u00106\u001a\u00020\tH\u0016J\u0010\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0017H\u0016J\u0010\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\tH\u0016J\u0010\u0010;\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\tH\u0016J+\u0010<\u001a\u00020\u0001\"\u0004\b\u0000\u0010$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u0002H$\u0018\u00010&2\u0006\u0010=\u001a\u0002H$H\u0016\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\u0017H\u0016J\u0010\u0010A\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\tH\u0016J\u0010\u0010B\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\u0017H\u0016J\u0018\u0010C\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\t2\u0006\u0010D\u001a\u00020\u0017H\u0016J\u0010\u0010E\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\tH\u0016J\u0010\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u0017H\u0016J\b\u0010H\u001a\u00020\u0010H\u0016J\b\u0010I\u001a\u00020\u0010H\u0016J\u0012\u0010J\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0KH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/openziti/net/internal/SocketChannelSocket;", "Ljava/net/Socket;", "()V", "ch", "Ljava/nio/channels/SocketChannel;", "(Ljava/nio/channels/SocketChannel;)V", "getCh", "()Ljava/nio/channels/SocketChannel;", "inputShut", "", "outputShut", "sel", "Ljava/nio/channels/Selector;", "selKey", "Ljava/nio/channels/SelectionKey;", "bind", "", "bindpoint", "Ljava/net/SocketAddress;", "close", "connect", "endpoint", "timeout", "", "getChannel", "getInetAddress", "Ljava/net/InetAddress;", "getInputStream", "Ljava/io/InputStream;", "getKeepAlive", "getLocalAddress", "getLocalPort", "getLocalSocketAddress", "Ljava/net/InetSocketAddress;", "getOOBInline", "getOption", "T", "name", "Ljava/net/SocketOption;", "(Ljava/net/SocketOption;)Ljava/lang/Object;", "getOutputStream", "Ljava/io/OutputStream;", "getPort", "getReceiveBufferSize", "getRemoteSocketAddress", "getReuseAddress", "getSendBufferSize", "getSoLinger", "getTcpNoDelay", "getTrafficClass", "isBound", "isClosed", "isConnected", "isInputShutdown", "isOutputShutdown", "sendUrgentData", "data", "setKeepAlive", "on", "setOOBInline", "setOption", "value", "(Ljava/net/SocketOption;Ljava/lang/Object;)Ljava/net/Socket;", "setReceiveBufferSize", "size", "setReuseAddress", "setSendBufferSize", "setSoLinger", "linger", "setTcpNoDelay", "setTrafficClass", "tc", "shutdownInput", "shutdownOutput", "supportedOptions", "", "Input", "Output", "ziti"})
public final class SocketChannelSocket
extends Socket {
    @NotNull
    private final SocketChannel ch;
    private boolean inputShut;
    private boolean outputShut;
    @NotNull
    private final Selector sel;
    @NotNull
    private final SelectionKey selKey;

    public SocketChannelSocket(@NotNull SocketChannel ch2) {
        Intrinsics.checkNotNullParameter(ch2, "ch");
        super((SocketImpl)null);
        this.ch = ch2;
        this.ch.configureBlocking(false);
        Object object = this.ch.provider().openSelector();
        Intrinsics.checkNotNullExpressionValue(object, "ch.provider().openSelector()");
        this.sel = (Selector)object;
        object = this.ch.register(this.sel, 8);
        Intrinsics.checkNotNullExpressionValue(object, "ch.register(sel, SelectionKey.OP_CONNECT)");
        this.selKey = object;
    }

    @NotNull
    public final SocketChannel getCh() {
        return this.ch;
    }

    public SocketChannelSocket() {
        SocketChannel socketChannel = SocketChannel.open();
        Intrinsics.checkNotNullExpressionValue(socketChannel, "open()");
        this(socketChannel);
    }

    @Override
    public void bind(@Nullable SocketAddress bindpoint) {
        this.ch.bind(bindpoint);
    }

    @Override
    public void close() {
        Object object;
        Closeable closeable = this.sel;
        try {
            Selector $this$close_u24lambda_u2d0 = closeable;
            boolean bl = false;
            $this$close_u24lambda_u2d0.close();
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable $this$close_u24lambda_u2d0) {
            object = Result.constructor-impl(ResultKt.createFailure($this$close_u24lambda_u2d0));
        }
        closeable = this.ch;
        try {
            Closeable $this$close_u24lambda_u2d1 = closeable;
            boolean bl = false;
            ((AbstractInterruptibleChannel)$this$close_u24lambda_u2d1).close();
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
    }

    @Override
    public void connect(@Nullable SocketAddress endpoint) {
        this.connect(endpoint, 0);
    }

    @Override
    public void connect(@Nullable SocketAddress endpoint, int timeout) {
        if (timeout == 0) {
            this.ch.configureBlocking(true);
            this.ch.connect(endpoint);
            this.ch.configureBlocking(false);
            this.selKey.interestOps(1);
            return;
        }
        this.ch.configureBlocking(false);
        if (this.ch.connect(endpoint)) {
            this.selKey.interestOps(1);
            return;
        }
        long start2 = System.currentTimeMillis();
        do {
            this.sel.select(timeout);
            if (!this.selKey.isConnectable()) continue;
            if (this.ch.finishConnect()) {
                this.selKey.interestOps(1);
            } else {
                this.close();
            }
            return;
        } while (System.currentTimeMillis() - start2 <= (long)timeout);
        this.close();
        throw new SocketTimeoutException();
    }

    @Override
    @Nullable
    public InetAddress getInetAddress() {
        return this.getRemoteSocketAddress().getAddress();
    }

    @Override
    @Nullable
    public InetAddress getLocalAddress() {
        SocketAddress socketAddress = this.ch.getLocalAddress();
        if (socketAddress == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        return ((InetSocketAddress)socketAddress).getAddress();
    }

    @Override
    public int getPort() {
        return this.getRemoteSocketAddress().getPort();
    }

    @Override
    public int getLocalPort() {
        return this.getLocalSocketAddress().getPort();
    }

    @Override
    @NotNull
    public InetSocketAddress getRemoteSocketAddress() {
        SocketAddress socketAddress = this.ch.getRemoteAddress();
        if (socketAddress == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        return (InetSocketAddress)socketAddress;
    }

    @Override
    @NotNull
    public InetSocketAddress getLocalSocketAddress() {
        SocketAddress socketAddress = this.ch.getLocalAddress();
        if (socketAddress == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        return (InetSocketAddress)socketAddress;
    }

    @Override
    @NotNull
    public SocketChannel getChannel() {
        return this.ch;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new Input();
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return new Output();
    }

    @Override
    public void setTcpNoDelay(boolean on) {
        this.ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)on);
    }

    @Override
    public boolean getTcpNoDelay() {
        Boolean bl = this.ch.getOption(StandardSocketOptions.TCP_NODELAY);
        Intrinsics.checkNotNullExpressionValue(bl, "ch.getOption(StandardSocketOptions.TCP_NODELAY)");
        return bl;
    }

    @Override
    public void setSoLinger(boolean on, int linger) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)linger);
    }

    @Override
    public int getSoLinger() {
        Integer n = this.ch.getOption(StandardSocketOptions.SO_LINGER);
        Intrinsics.checkNotNullExpressionValue(n, "ch.getOption(StandardSocketOptions.SO_LINGER)");
        return ((Number)n).intValue();
    }

    @Override
    public void sendUrgentData(int data) {
        throw new IllegalStateException("not supported".toString());
    }

    @Override
    public void setOOBInline(boolean on) {
        throw new IllegalStateException("not supported".toString());
    }

    @Override
    public boolean getOOBInline() {
        throw new IllegalStateException("not supported".toString());
    }

    @Override
    public void setSendBufferSize(int size) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)size);
    }

    @Override
    public int getSendBufferSize() {
        Integer n = this.ch.getOption(StandardSocketOptions.SO_SNDBUF);
        Intrinsics.checkNotNullExpressionValue(n, "ch.getOption(StandardSocketOptions.SO_SNDBUF)");
        return ((Number)n).intValue();
    }

    @Override
    public void setReceiveBufferSize(int size) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)size);
    }

    @Override
    public int getReceiveBufferSize() {
        Integer n = this.ch.getOption(StandardSocketOptions.SO_RCVBUF);
        Intrinsics.checkNotNullExpressionValue(n, "ch.getOption(StandardSocketOptions.SO_RCVBUF)");
        return ((Number)n).intValue();
    }

    @Override
    public void setKeepAlive(boolean on) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)on);
    }

    @Override
    public boolean getKeepAlive() {
        Boolean bl = this.ch.getOption(StandardSocketOptions.SO_KEEPALIVE);
        Intrinsics.checkNotNullExpressionValue(bl, "ch.getOption(StandardSocketOptions.SO_KEEPALIVE)");
        return bl;
    }

    @Override
    public void setTrafficClass(int tc) {
        this.ch.setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)tc);
    }

    @Override
    public int getTrafficClass() {
        Integer n = this.ch.getOption(StandardSocketOptions.IP_TOS);
        Intrinsics.checkNotNullExpressionValue(n, "ch.getOption(StandardSocketOptions.IP_TOS)");
        return ((Number)n).intValue();
    }

    @Override
    public void setReuseAddress(boolean on) {
        this.ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)on);
    }

    @Override
    public boolean getReuseAddress() {
        Boolean bl = this.ch.getOption(StandardSocketOptions.SO_REUSEADDR);
        Intrinsics.checkNotNullExpressionValue(bl, "ch.getOption(StandardSocketOptions.SO_REUSEADDR)");
        return bl;
    }

    @Override
    public void shutdownInput() {
        this.ch.shutdownInput();
        this.inputShut = true;
    }

    @Override
    public void shutdownOutput() {
        this.ch.shutdownOutput();
        this.outputShut = true;
    }

    @Override
    public boolean isConnected() {
        return this.ch.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.ch.getLocalAddress() != null;
    }

    @Override
    public boolean isClosed() {
        return !this.ch.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return this.ch.isConnected() && this.inputShut;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.ch.isConnected() && this.outputShut;
    }

    @Override
    @NotNull
    public <T> Socket setOption(@Nullable SocketOption<T> name, T value) {
        SocketChannelSocket socketChannelSocket;
        SocketChannelSocket $this$setOption_u24lambda_u2d2 = socketChannelSocket = this;
        boolean bl = false;
        $this$setOption_u24lambda_u2d2.getCh().setOption((SocketOption)name, (Object)value);
        return socketChannelSocket;
    }

    @Override
    public <T> T getOption(@Nullable SocketOption<T> name) {
        return this.ch.getOption(name);
    }

    @Override
    @NotNull
    public Set<SocketOption<?>> supportedOptions() {
        Set<SocketOption<?>> set = this.ch.supportedOptions();
        Intrinsics.checkNotNullExpressionValue(set, "ch.supportedOptions()");
        return set;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/openziti/net/internal/SocketChannelSocket$Output;", "Ljava/io/OutputStream;", "(Lorg/openziti/net/internal/SocketChannelSocket;)V", "write", "", "b", "", "off", "", "len", "ziti"})
    public final class Output
    extends OutputStream {
        public Output() {
            Intrinsics.checkNotNullParameter(SocketChannelSocket.this, "this$0");
        }

        @Override
        public void write(int b) {
            byte[] byArray = new byte[]{(byte)b};
            this.write(byArray);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter(b, "b");
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            int timeout = SocketChannelSocket.this.getSoTimeout();
            long start2 = System.currentTimeMillis();
            while (buf.hasRemaining()) {
                if (SocketChannelSocket.this.getCh().write(buf) != 0) continue;
                long toRemaining = (long)timeout - (System.currentTimeMillis() - start2);
                if (toRemaining <= 0L) {
                    this.close();
                    throw new SocketTimeoutException();
                }
                SocketChannelSocket.this.sel.select(toRemaining);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/openziti/net/internal/SocketChannelSocket$Input;", "Ljava/io/InputStream;", "(Lorg/openziti/net/internal/SocketChannelSocket;)V", "close", "", "read", "", "b", "", "off", "len", "ziti"})
    public final class Input
    extends InputStream {
        public Input() {
            Intrinsics.checkNotNullParameter(SocketChannelSocket.this, "this$0");
        }

        @Override
        public int read() {
            byte[] b = new byte[1];
            int rc = this.read(b);
            if (rc == -1) {
                return rc;
            }
            return b[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter(b, "b");
            if (SocketChannelSocket.this.isInputShutdown()) {
                return -1;
            }
            ByteBuffer buf = ByteBuffer.wrap(b, off, len);
            long start2 = System.currentTimeMillis();
            int timeout = SocketChannelSocket.this.getSoTimeout();
            SelectionKey selectionKey = SocketChannelSocket.this.selKey;
            SocketChannelSocket socketChannelSocket = SocketChannelSocket.this;
            synchronized (selectionKey) {
                int count2;
                block9: {
                    boolean bl = false;
                    int rc = socketChannelSocket.getCh().read(buf);
                    if (rc == 0) break block9;
                    int n = rc;
                    return n;
                }
                block4: while (true) {
                    SelectionKey k;
                    long toRemaining = 0L;
                    if (timeout > 0) {
                        long elapsed = System.currentTimeMillis() - start2;
                        if (elapsed >= (long)timeout) {
                            throw new SocketTimeoutException();
                        }
                        toRemaining = (long)timeout - elapsed;
                    }
                    socketChannelSocket.sel.select(toRemaining);
                    Iterator<SelectionKey> iterator2 = socketChannelSocket.sel.selectedKeys().iterator();
                    do {
                        if (!iterator2.hasNext()) continue block4;
                    } while (!(k = iterator2.next()).isReadable() || (count2 = socketChannelSocket.getCh().read(buf)) == 0);
                    break;
                }
                int n = count2;
                return n;
            }
        }

        @Override
        public void close() {
            SocketChannelSocket.this.shutdownInput();
            SocketChannelSocket.this.sel.close();
        }
    }
}

