/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium.utils;

import com.goterl.lazysodium.utils.LibraryLoadingException;
import com.goterl.resourceloader.SharedLibraryLoader;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibraryLoader {
    private final Logger logger = LoggerFactory.getLogger("LazysodiumJava");
    private List<Class> classes = new ArrayList<Class>();

    public LibraryLoader(List<Class> classesToRegister) {
        this.classes.addAll(classesToRegister);
    }

    public void loadLibrary(Mode mode, String systemFallBack) {
        switch (mode) {
            case PREFER_SYSTEM: {
                try {
                    this.loadSystemLibrary(systemFallBack);
                }
                catch (Throwable suppressed) {
                    this.logger.debug("Tried loading native libraries from system but failed. Message: {}.", (Object)suppressed.getMessage());
                    this.loadBundledLibrary();
                }
                break;
            }
            case PREFER_BUNDLED: {
                try {
                    this.loadBundledLibrary();
                }
                catch (Throwable suppressed) {
                    this.logger.debug("Tried loading native libraries from the bundled resources but failed. Message: {}.", (Object)suppressed.getMessage());
                    this.loadSystemLibrary(systemFallBack);
                }
                break;
            }
            case BUNDLED_ONLY: {
                this.loadBundledLibrary();
                break;
            }
            case SYSTEM_ONLY: {
                this.loadSystemLibrary(systemFallBack);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mode: " + (Object)((Object)mode));
            }
        }
    }

    public void loadSystemLibrary(String library) {
        SharedLibraryLoader.get().loadSystemLibrary(library, this.classes);
    }

    public void loadAbsolutePath(String absPath) {
        SharedLibraryLoader.get().loadSystemLibrary(absPath, this.classes);
    }

    private void loadBundledLibrary() {
        String pathInJar = LibraryLoader.getSodiumPathInResources();
        SharedLibraryLoader.get().load(pathInJar, this.classes);
    }

    public static String getSodiumPathInResources() {
        boolean is64Bit;
        boolean bl = is64Bit = Native.POINTER_SIZE == 8;
        if (Platform.isWindows()) {
            if (is64Bit) {
                return LibraryLoader.getPath("windows64", "libsodium.dll");
            }
            return LibraryLoader.getPath("windows", "libsodium.dll");
        }
        if (Platform.isMac()) {
            if (Platform.isARM()) {
                return LibraryLoader.getPath("mac/aarch64", "libsodium.dylib");
            }
            return LibraryLoader.getPath("mac/intel", "libsodium.dylib");
        }
        if (Platform.isARM()) {
            return LibraryLoader.getPath("armv6", "libsodium.so");
        }
        if (Platform.isLinux()) {
            if (is64Bit) {
                return LibraryLoader.getPath("linux64", "libsodium.so");
            }
            return LibraryLoader.getPath("linux", "libsodium.so");
        }
        String message = String.format("Unsupported platform: %s/%s", System.getProperty("os.name"), System.getProperty("os.arch"));
        throw new LibraryLoadingException(message);
    }

    private static String getPath(String folder, String name) {
        String separator = "/";
        return folder + separator + name;
    }

    public static enum Mode {
        PREFER_SYSTEM,
        PREFER_BUNDLED,
        BUNDLED_ONLY,
        SYSTEM_ONLY;

    }
}

