/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.RequiredTypeException;
import io.jsonwebtoken.impl.JwtMap;
import java.util.Date;
import java.util.Map;

public class DefaultClaims
extends JwtMap
implements Claims {
    private static final String CONVERSION_ERROR_MSG = "Cannot convert existing claim value of type '%s' to desired type '%s'. JJWT only converts simple String, Date, Long, Integer, Short and Byte types automatically. Anything more complex is expected to be already converted to your desired type by the JSON Deserializer implementation. You may specify a custom Deserializer for a JwtParser with the desired conversion configuration via the JwtParserBuilder.deserializeJsonWith() method. See https://github.com/jwtk/jjwt#custom-json-processor for more information. If using Jackson, you can specify custom claim POJO types as described in https://github.com/jwtk/jjwt#json-jackson-custom-types";

    public DefaultClaims() {
    }

    public DefaultClaims(Map<String, ?> map2) {
        super(map2);
    }

    @Override
    public String getIssuer() {
        return this.getString("iss");
    }

    @Override
    public Claims setIssuer(String iss) {
        this.setValue("iss", iss);
        return this;
    }

    @Override
    public String getSubject() {
        return this.getString("sub");
    }

    @Override
    public Claims setSubject(String sub) {
        this.setValue("sub", sub);
        return this;
    }

    @Override
    public String getAudience() {
        return this.getString("aud");
    }

    @Override
    public Claims setAudience(String aud) {
        this.setValue("aud", aud);
        return this;
    }

    @Override
    public Date getExpiration() {
        return this.get("exp", Date.class);
    }

    @Override
    public Claims setExpiration(Date exp) {
        this.setDateAsSeconds("exp", exp);
        return this;
    }

    @Override
    public Date getNotBefore() {
        return this.get("nbf", Date.class);
    }

    @Override
    public Claims setNotBefore(Date nbf) {
        this.setDateAsSeconds("nbf", nbf);
        return this;
    }

    @Override
    public Date getIssuedAt() {
        return this.get("iat", Date.class);
    }

    @Override
    public Claims setIssuedAt(Date iat) {
        this.setDateAsSeconds("iat", iat);
        return this;
    }

    @Override
    public String getId() {
        return this.getString("jti");
    }

    @Override
    public Claims setId(String jti) {
        this.setValue("jti", jti);
        return this;
    }

    private static boolean isSpecDate(String claimName) {
        return "exp".equals(claimName) || "iat".equals(claimName) || "nbf".equals(claimName);
    }

    @Override
    public Object put(String s, Object o) {
        if (o instanceof Date && DefaultClaims.isSpecDate(s)) {
            Date date = (Date)o;
            return this.setDateAsSeconds(s, date);
        }
        return super.put(s, o);
    }

    @Override
    public <T> T get(String claimName, Class<T> requiredType) {
        Object value = this.get(claimName);
        if (value == null) {
            return null;
        }
        if (Date.class.equals(requiredType)) {
            value = DefaultClaims.isSpecDate(claimName) ? DefaultClaims.toSpecDate(value, claimName) : DefaultClaims.toDate(value, claimName);
        }
        return this.castClaimValue(value, requiredType);
    }

    private <T> T castClaimValue(Object value, Class<T> requiredType) {
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (requiredType == Long.class) {
                value = (long)intValue;
            } else if (requiredType == Short.class && Short.MIN_VALUE <= intValue && intValue <= Short.MAX_VALUE) {
                value = (short)intValue;
            } else if (requiredType == Byte.class && -128 <= intValue && intValue <= 127) {
                value = (byte)intValue;
            }
        }
        if (!requiredType.isInstance(value)) {
            throw new RequiredTypeException(String.format(CONVERSION_ERROR_MSG, value.getClass(), requiredType));
        }
        return requiredType.cast(value);
    }
}

