/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.orgjson.io;

import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class OrgJsonDeserializer
implements Deserializer<Object> {
    @Override
    public Object deserialize(byte[] bytes) throws DeserializationException {
        Assert.notNull(bytes, "JSON byte array cannot be null");
        if (bytes.length == 0) {
            throw new DeserializationException("Invalid JSON: zero length byte array.");
        }
        try {
            String s = new String(bytes, Strings.UTF_8);
            return this.parse(s);
        }
        catch (Exception e2) {
            String msg2 = "Invalid JSON: " + e2.getMessage();
            throw new DeserializationException(msg2, e2);
        }
    }

    private Object parse(String json) throws JSONException {
        JSONTokener tokener = new JSONTokener(json);
        char c = tokener.nextClean();
        tokener.back();
        if (c == '{') {
            JSONObject o = new JSONObject(tokener);
            return this.toMap(o);
        }
        if (c == '[') {
            JSONArray a = new JSONArray(tokener);
            return this.toList(a);
        }
        Object value = tokener.nextValue();
        return this.convertIfNecessary(value);
    }

    private Map<String, Object> toMap(JSONObject o) {
        LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>();
        Iterator<String> iterator2 = o.keys();
        while (iterator2.hasNext()) {
            String key = iterator2.next();
            Object value = o.get(key);
            value = this.convertIfNecessary(value);
            map2.put(key, value);
        }
        return map2;
    }

    private List<Object> toList(JSONArray a) {
        int length = a.length();
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i2 = 0; i2 < length; ++i2) {
            Object value = a.get(i2);
            value = this.convertIfNecessary(value);
            list.add(value);
        }
        return list;
    }

    private Object convertIfNecessary(Object v2) {
        List<Object> value = v2;
        if (JSONObject.NULL.equals(value)) {
            value = null;
        } else if (value instanceof JSONArray) {
            value = this.toList((JSONArray)((Object)value));
        } else if (value instanceof JSONObject) {
            value = this.toMap((JSONObject)((Object)value));
        }
        return value;
    }
}

