/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.TrustRootIndex;

public final class BasicCertificateChainCleaner
extends CertificateChainCleaner {
    private static final int MAX_SIGNERS = 9;
    private final TrustRootIndex trustRootIndex;

    public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
        this.trustRootIndex = trustRootIndex;
    }

    @Override
    public List<Certificate> clean(List<Certificate> chain, String hostname) throws SSLPeerUnverifiedException {
        ArrayDeque<Certificate> queue = new ArrayDeque<Certificate>(chain);
        ArrayList<Certificate> result2 = new ArrayList<Certificate>();
        result2.add((Certificate)queue.removeFirst());
        boolean foundTrustedCertificate = false;
        block0: for (int c = 0; c < 9; ++c) {
            X509Certificate toVerify = (X509Certificate)result2.get(result2.size() - 1);
            X509Certificate trustedCert = this.trustRootIndex.findByIssuerAndSignature(toVerify);
            if (trustedCert != null) {
                if (result2.size() > 1 || !toVerify.equals(trustedCert)) {
                    result2.add(trustedCert);
                }
                if (this.verifySignature(trustedCert, trustedCert)) {
                    return result2;
                }
                foundTrustedCertificate = true;
                continue;
            }
            Iterator i2 = queue.iterator();
            while (i2.hasNext()) {
                X509Certificate signingCert = (X509Certificate)i2.next();
                if (!this.verifySignature(toVerify, signingCert)) continue;
                i2.remove();
                result2.add(signingCert);
                continue block0;
            }
            if (foundTrustedCertificate) {
                return result2;
            }
            throw new SSLPeerUnverifiedException("Failed to find a trusted cert that signed " + toVerify);
        }
        throw new SSLPeerUnverifiedException("Certificate chain too long: " + result2);
    }

    private boolean verifySignature(X509Certificate toVerify, X509Certificate signingCert) {
        if (!toVerify.getIssuerDN().equals(signingCert.getSubjectDN())) {
            return false;
        }
        try {
            toVerify.verify(signingCert.getPublicKey());
            return true;
        }
        catch (GeneralSecurityException verifyFailed) {
            return false;
        }
    }

    public int hashCode() {
        return this.trustRootIndex.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        return other instanceof BasicCertificateChainCleaner && ((BasicCertificateChainCleaner)other).trustRootIndex.equals(this.trustRootIndex);
    }
}

