/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (0 != GCMUtil.areEqual(this.H, byArray)) {
            return;
        }
        this.H = new byte[16];
        GCMUtil.copy(byArray, this.H);
        for (int k = 0; k < 16; ++k) {
            long[][] lArray = this.T[k];
            if (k == 0) {
                GCMUtil.asLongs(this.H, lArray[1]);
                GCMUtil.multiplyP7(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP8(this.T[k - 1][1], lArray[1]);
            }
            for (int i2 = 2; i2 < 256; i2 += 2) {
                GCMUtil.divideP(lArray[i2 >> 1], lArray[i2]);
                GCMUtil.xor(lArray[i2], lArray[1], lArray[i2 + 1]);
            }
        }
    }

    public void multiplyH(byte[] byArray) {
        long[] lArray = this.T[15][byArray[15] & 0xFF];
        long l = lArray[0];
        long l2 = lArray[1];
        for (int k = 14; k >= 0; --k) {
            lArray = this.T[k][byArray[k] & 0xFF];
            l ^= lArray[0];
            l2 ^= lArray[1];
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }
}

