/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Pack;

public class Tables8kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[32][16][2];
        } else if (0 != GCMUtil.areEqual(this.H, byArray)) {
            return;
        }
        this.H = new byte[16];
        GCMUtil.copy(byArray, this.H);
        for (int k = 0; k < 32; ++k) {
            long[][] lArray = this.T[k];
            if (k == 0) {
                GCMUtil.asLongs(this.H, lArray[1]);
                GCMUtil.multiplyP3(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP4(this.T[k - 1][1], lArray[1]);
            }
            for (int i2 = 2; i2 < 16; i2 += 2) {
                GCMUtil.divideP(lArray[i2 >> 1], lArray[i2]);
                GCMUtil.xor(lArray[i2], lArray[1], lArray[i2 + 1]);
            }
        }
    }

    public void multiplyH(byte[] byArray) {
        long l = 0L;
        long l2 = 0L;
        for (int k = 15; k >= 0; --k) {
            long[] lArray = this.T[k + k + 1][byArray[k] & 0xF];
            long[] lArray2 = this.T[k + k][(byArray[k] & 0xF0) >>> 4];
            l ^= lArray[0] ^ lArray2[0];
            l2 ^= lArray[1] ^ lArray2[1];
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }
}

