/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AlphabetMapper;

public class BasicAlphabetMapper
implements AlphabetMapper {
    private Map<Character, Integer> indexMap = new HashMap<Character, Integer>();
    private Map<Integer, Character> charMap = new HashMap<Integer, Character>();

    public BasicAlphabetMapper(String string) {
        this(string.toCharArray());
    }

    public BasicAlphabetMapper(char[] cArray) {
        for (int k = 0; k != cArray.length; ++k) {
            if (this.indexMap.containsKey(Character.valueOf(cArray[k]))) {
                throw new IllegalArgumentException("duplicate key detected in alphabet: " + cArray[k]);
            }
            this.indexMap.put(Character.valueOf(cArray[k]), k);
            this.charMap.put(k, Character.valueOf(cArray[k]));
        }
    }

    public int getRadix() {
        return this.indexMap.size();
    }

    public byte[] convertToIndexes(char[] cArray) {
        byte[] byArray;
        if (this.indexMap.size() <= 256) {
            byArray = new byte[cArray.length];
            for (int k = 0; k != cArray.length; ++k) {
                byArray[k] = this.indexMap.get(Character.valueOf(cArray[k])).byteValue();
            }
        } else {
            byArray = new byte[cArray.length * 2];
            for (int k = 0; k != cArray.length; ++k) {
                int n = this.indexMap.get(Character.valueOf(cArray[k]));
                byArray[k * 2] = (byte)(n >> 8 & 0xFF);
                byArray[k * 2 + 1] = (byte)(n & 0xFF);
            }
        }
        return byArray;
    }

    public char[] convertToChars(byte[] byArray) {
        char[] cArray;
        if (this.charMap.size() <= 256) {
            cArray = new char[byArray.length];
            for (int k = 0; k != byArray.length; ++k) {
                cArray[k] = this.charMap.get(byArray[k] & 0xFF).charValue();
            }
        } else {
            if ((byArray.length & 1) != 0) {
                throw new IllegalArgumentException("two byte radix and input string odd length");
            }
            cArray = new char[byArray.length / 2];
            for (int k = 0; k != byArray.length; k += 2) {
                cArray[k / 2] = this.charMap.get(byArray[k] << 8 & 0xFF00 | byArray[k + 1] & 0xFF).charValue();
            }
        }
        return cArray;
    }
}

