/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.Matrix;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mMatrix
extends Matrix {
    protected GF2mField field;
    protected int[][] matrix;

    public GF2mMatrix(GF2mField gF2mField, byte[] byArray) {
        int n;
        this.field = gF2mField;
        int n2 = 1;
        for (n = 8; gF2mField.getDegree() > n; n += 8) {
            ++n2;
        }
        if (byArray.length < 5) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numRows = (byArray[3] & 0xFF) << 24 ^ (byArray[2] & 0xFF) << 16 ^ (byArray[1] & 0xFF) << 8 ^ byArray[0] & 0xFF;
        int n3 = n2 * this.numRows;
        if (this.numRows <= 0 || (byArray.length - 4) % n3 != 0) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numColumns = (byArray.length - 4) / n3;
        this.matrix = new int[this.numRows][this.numColumns];
        n2 = 4;
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                for (int i3 = 0; i3 < n; i3 += 8) {
                    int[] nArray = this.matrix[k];
                    int n4 = i2;
                    nArray[n4] = nArray[n4] ^ (byArray[n2++] & 0xFF) << i3;
                }
                if (this.field.isElementOfThisField(this.matrix[k][i2])) continue;
                throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
            }
        }
    }

    public GF2mMatrix(GF2mMatrix gF2mMatrix) {
        this.numRows = gF2mMatrix.numRows;
        this.numColumns = gF2mMatrix.numColumns;
        this.field = gF2mMatrix.field;
        this.matrix = new int[this.numRows][];
        for (int k = 0; k < this.numRows; ++k) {
            this.matrix[k] = IntUtils.clone(gF2mMatrix.matrix[k]);
        }
    }

    protected GF2mMatrix(GF2mField gF2mField, int[][] nArray) {
        this.field = gF2mField;
        this.matrix = nArray;
        this.numRows = nArray.length;
        this.numColumns = nArray[0].length;
    }

    public byte[] getEncoded() {
        int n;
        int n2 = 1;
        for (n = 8; this.field.getDegree() > n; n += 8) {
            ++n2;
        }
        byte[] byArray = new byte[this.numRows * this.numColumns * n2 + 4];
        byArray[0] = (byte)(this.numRows & 0xFF);
        byArray[1] = (byte)(this.numRows >>> 8 & 0xFF);
        byArray[2] = (byte)(this.numRows >>> 16 & 0xFF);
        byArray[3] = (byte)(this.numRows >>> 24 & 0xFF);
        n2 = 4;
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                for (int i3 = 0; i3 < n; i3 += 8) {
                    byArray[n2++] = (byte)(this.matrix[k][i2] >>> i3);
                }
            }
        }
        return byArray;
    }

    public boolean isZero() {
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                if (this.matrix[k][i2] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public Matrix computeInverse() {
        int n;
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] nArray = new int[this.numRows][this.numRows];
        for (int k = this.numRows - 1; k >= 0; --k) {
            nArray[k] = IntUtils.clone(this.matrix[k]);
        }
        int[][] nArray2 = new int[this.numRows][this.numRows];
        for (n = this.numRows - 1; n >= 0; --n) {
            nArray2[n][n] = 1;
        }
        for (n = 0; n < this.numRows; ++n) {
            int n2;
            int n3;
            if (nArray[n][n] == 0) {
                n3 = 0;
                for (n2 = n + 1; n2 < this.numRows; ++n2) {
                    if (nArray[n2][n] == 0) continue;
                    n3 = 1;
                    GF2mMatrix.swapColumns(nArray, n, n2);
                    GF2mMatrix.swapColumns(nArray2, n, n2);
                    n2 = this.numRows;
                }
                if (n3 == 0) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            n3 = nArray[n][n];
            n2 = this.field.inverse(n3);
            this.multRowWithElementThis(nArray[n], n2);
            this.multRowWithElementThis(nArray2[n], n2);
            for (int k = 0; k < this.numRows; ++k) {
                if (k == n || (n3 = nArray[k][n]) == 0) continue;
                int[] nArray3 = this.multRowWithElement(nArray[n], n3);
                int[] nArray4 = this.multRowWithElement(nArray2[n], n3);
                this.addToRow(nArray3, nArray[k]);
                this.addToRow(nArray4, nArray2[k]);
            }
        }
        return new GF2mMatrix(this.field, nArray2);
    }

    private static void swapColumns(int[][] nArray, int n, int n2) {
        int[] nArray2 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = nArray2;
    }

    private void multRowWithElementThis(int[] nArray, int n) {
        for (int k = nArray.length - 1; k >= 0; --k) {
            nArray[k] = this.field.mult(nArray[k], n);
        }
    }

    private int[] multRowWithElement(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length];
        for (int k = nArray.length - 1; k >= 0; --k) {
            nArray2[k] = this.field.mult(nArray[k], n);
        }
        return nArray2;
    }

    private void addToRow(int[] nArray, int[] nArray2) {
        for (int k = nArray2.length - 1; k >= 0; --k) {
            nArray2[k] = this.field.add(nArray[k], nArray2[k]);
        }
    }

    public Matrix rightMultiply(Matrix matrix) {
        throw new RuntimeException("Not implemented.");
    }

    public Matrix rightMultiply(Permutation permutation) {
        throw new RuntimeException("Not implemented.");
    }

    public Vector leftMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public Vector rightMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GF2mMatrix)) {
            return false;
        }
        GF2mMatrix gF2mMatrix = (GF2mMatrix)object;
        if (!this.field.equals(gF2mMatrix.field) || gF2mMatrix.numRows != this.numColumns || gF2mMatrix.numColumns != this.numColumns) {
            return false;
        }
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                if (this.matrix[k][i2] == gF2mMatrix.matrix[k][i2]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = (this.field.hashCode() * 31 + this.numRows) * 31 + this.numColumns;
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                n = n * 31 + this.matrix[k][i2];
            }
        }
        return n;
    }

    public String toString() {
        String string = this.numRows + " x " + this.numColumns + " Matrix over " + this.field.toString() + ": \n";
        for (int k = 0; k < this.numRows; ++k) {
            for (int i2 = 0; i2 < this.numColumns; ++i2) {
                string = string + this.field.elementToStr(this.matrix[k][i2]) + " : ";
            }
            string = string + "\n";
        }
        return string;
    }
}

