/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.internal;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0014\u001a\u00020\u000bH\u0016J \u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0017\u0012\u0004\u0012\u00020\u000b0\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010 \u001a\u00020\u000fH\u0016J\b\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020\u000fH\u0016J\b\u0010#\u001a\u00020\u000fH\u0016J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u000fH\u0016J\u001f\u0010&\u001a\u00020\u00072\u0010\u0010'\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010(J\u001f\u0010)\u001a\u00020\u00072\u0010\u0010*\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010(J*\u0010+\u001a\u00020\u00072 \u0010,\u001a\u001c\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0017\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0016H\u0016J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u000fH\u0016J\u0010\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u000fH\u0016J\u0010\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u000fH\u0016JA\u00103\u001a\n 5*\u0004\u0018\u000104042\b\u00106\u001a\u0004\u0018\u0001072\u0010\u00108\u001a\f\u0012\u0006\b\u0001\u0012\u000207\u0018\u00010\u00112\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0016\u00a2\u0006\u0002\u0010<JA\u0010=\u001a\n 5*\u0004\u0018\u000104042\u0010\u0010>\u001a\f\u0012\u0006\b\u0001\u0012\u000207\u0018\u00010\u00112\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\b\u0010?\u001a\u0004\u0018\u000107H\u0016\u00a2\u0006\u0002\u0010@R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006A"}, d2={"Lorg/openziti/net/internal/SSLEngineWrapper;", "Ljavax/net/ssl/SSLEngine;", "delegate", "(Ljavax/net/ssl/SSLEngine;)V", "getDelegate", "()Ljavax/net/ssl/SSLEngine;", "beginHandshake", "", "closeInbound", "closeOutbound", "getApplicationProtocol", "", "getDelegatedTask", "Ljava/lang/Runnable;", "getEnableSessionCreation", "", "getEnabledCipherSuites", "", "()[Ljava/lang/String;", "getEnabledProtocols", "getHandshakeApplicationProtocol", "getHandshakeApplicationProtocolSelector", "Ljava/util/function/BiFunction;", "", "getHandshakeSession", "Ljavax/net/ssl/SSLSession;", "getHandshakeStatus", "Ljavax/net/ssl/SSLEngineResult$HandshakeStatus;", "getNeedClientAuth", "getSession", "getSupportedCipherSuites", "getSupportedProtocols", "getUseClientMode", "getWantClientAuth", "isInboundDone", "isOutboundDone", "setEnableSessionCreation", "flag", "setEnabledCipherSuites", "ciphers", "([Ljava/lang/String;)V", "setEnabledProtocols", "protocols", "setHandshakeApplicationProtocolSelector", "selector", "setNeedClientAuth", "need", "setUseClientMode", "mode", "setWantClientAuth", "want", "unwrap", "Ljavax/net/ssl/SSLEngineResult;", "kotlin.jvm.PlatformType", "src", "Ljava/nio/ByteBuffer;", "dsts", "offset", "", "length", "(Ljava/nio/ByteBuffer;[Ljava/nio/ByteBuffer;II)Ljavax/net/ssl/SSLEngineResult;", "wrap", "srcs", "dst", "([Ljava/nio/ByteBuffer;IILjava/nio/ByteBuffer;)Ljavax/net/ssl/SSLEngineResult;", "ziti"})
public final class SSLEngineWrapper
extends SSLEngine {
    @NotNull
    private final SSLEngine delegate;

    public SSLEngineWrapper(@NotNull SSLEngine delegate) {
        Intrinsics.checkNotNullParameter(delegate, "delegate");
        super(delegate.getPeerHost(), delegate.getPeerPort());
        this.delegate = delegate;
    }

    @NotNull
    public final SSLEngine getDelegate() {
        return this.delegate;
    }

    @Override
    public SSLEngineResult wrap(@Nullable ByteBuffer[] srcs, int offset, int length, @Nullable ByteBuffer dst) {
        return this.delegate.wrap(srcs, offset, length, dst);
    }

    @Override
    public SSLEngineResult unwrap(@Nullable ByteBuffer src, @Nullable ByteBuffer[] dsts, int offset, int length) {
        return this.delegate.unwrap(src, dsts, offset, length);
    }

    @Override
    @NotNull
    public Runnable getDelegatedTask() {
        Runnable runnable = this.delegate.getDelegatedTask();
        Intrinsics.checkNotNullExpressionValue(runnable, "delegate.delegatedTask");
        return runnable;
    }

    @Override
    public void closeInbound() {
        this.delegate.closeInbound();
    }

    @Override
    public boolean isInboundDone() {
        return this.delegate.isInboundDone();
    }

    @Override
    public void closeOutbound() {
        this.delegate.closeOutbound();
    }

    @Override
    public boolean isOutboundDone() {
        return this.delegate.isOutboundDone();
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.delegate.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue(stringArray, "delegate.supportedCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getEnabledCipherSuites() {
        String[] stringArray = this.delegate.getEnabledCipherSuites();
        Intrinsics.checkNotNullExpressionValue(stringArray, "delegate.enabledCipherSuites");
        return stringArray;
    }

    @Override
    public void setEnabledCipherSuites(@Nullable String[] ciphers) {
        this.delegate.setEnabledCipherSuites(ciphers);
    }

    @Override
    @NotNull
    public String[] getSupportedProtocols() {
        String[] stringArray = this.delegate.getSupportedProtocols();
        Intrinsics.checkNotNullExpressionValue(stringArray, "delegate.supportedProtocols");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getEnabledProtocols() {
        String[] stringArray = this.delegate.getEnabledProtocols();
        Intrinsics.checkNotNullExpressionValue(stringArray, "delegate.enabledProtocols");
        return stringArray;
    }

    @Override
    public void setEnabledProtocols(@Nullable String[] protocols) {
        this.delegate.setEnabledProtocols(protocols);
    }

    @Override
    @NotNull
    public SSLSession getSession() {
        SSLSession sSLSession = this.delegate.getSession();
        Intrinsics.checkNotNullExpressionValue(sSLSession, "delegate.session");
        return sSLSession;
    }

    @Override
    public void beginHandshake() {
        if (this.delegate.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.delegate.beginHandshake();
        }
    }

    @Override
    @NotNull
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        SSLEngineResult.HandshakeStatus handshakeStatus = this.delegate.getHandshakeStatus();
        Intrinsics.checkNotNullExpressionValue((Object)handshakeStatus, "delegate.handshakeStatus");
        return handshakeStatus;
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.delegate.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.delegate.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.delegate.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.delegate.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.delegate.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.delegate.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.delegate.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.delegate.getEnableSessionCreation();
    }

    @Override
    @NotNull
    public String getApplicationProtocol() {
        String string = this.delegate.getApplicationProtocol();
        Intrinsics.checkNotNullExpressionValue(string, "delegate.applicationProtocol");
        return string;
    }

    @Override
    @NotNull
    public String getHandshakeApplicationProtocol() {
        String string = this.delegate.getHandshakeApplicationProtocol();
        Intrinsics.checkNotNullExpressionValue(string, "delegate.handshakeApplicationProtocol");
        return string;
    }

    @Override
    @NotNull
    public SSLSession getHandshakeSession() {
        SSLSession sSLSession = this.delegate.getHandshakeSession();
        Intrinsics.checkNotNullExpressionValue(sSLSession, "delegate.handshakeSession");
        return sSLSession;
    }

    @Override
    public void setHandshakeApplicationProtocolSelector(@Nullable BiFunction<SSLEngine, List<String>, String> selector) {
        this.delegate.setHandshakeApplicationProtocolSelector(selector);
    }

    @Override
    @NotNull
    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        BiFunction<SSLEngine, List<String>, String> biFunction = this.delegate.getHandshakeApplicationProtocolSelector();
        Intrinsics.checkNotNullExpressionValue(biFunction, "delegate.handshakeApplicationProtocolSelector");
        return biFunction;
    }
}

