/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.nio;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.AsynchronousSocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.internal.ZitiSSLSocket;
import org.openziti.net.nio.AsyncSocketImpl;
import org.openziti.net.nio.AsyncTLSChannelSocket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0013\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/openziti/net/nio/AsyncTLSSocketFactory;", "Ljavax/net/ssl/SSLSocketFactory;", "()V", "ssl", "Ljavax/net/ssl/SSLContext;", "(Ljavax/net/ssl/SSLContext;)V", "getImplMethod", "Ljava/lang/reflect/Method;", "implField", "Ljava/lang/reflect/Field;", "getSsl", "()Ljavax/net/ssl/SSLContext;", "createSocket", "Ljava/net/Socket;", "host", "Ljava/net/InetAddress;", "port", "", "address", "localAddress", "localPort", "transport", "", "autoClose", "", "localHost", "getDefaultCipherSuites", "", "()[Ljava/lang/String;", "getSupportedCipherSuites", "ziti"})
public final class AsyncTLSSocketFactory
extends SSLSocketFactory {
    @NotNull
    private final SSLContext ssl;
    @Nullable
    private final Method getImplMethod;
    @Nullable
    private final Field implField;

    public AsyncTLSSocketFactory(@NotNull SSLContext ssl) {
        Intrinsics.checkNotNullParameter(ssl, "ssl");
        this.ssl = ssl;
        Method m = null;
        try {
            Method method2;
            Method $this$_init__u24lambda_u2d0 = method2 = Socket.class.getDeclaredMethod("getImpl", new Class[0]);
            boolean bl = false;
            $this$_init__u24lambda_u2d0.setAccessible(true);
            m = method2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Field f = null;
        try {
            Field field;
            Field $this$_init__u24lambda_u2d1 = field = Socket.class.getDeclaredField("impl");
            boolean bl = false;
            $this$_init__u24lambda_u2d1.setAccessible(true);
            f = field;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.implField = f;
        this.getImplMethod = m;
    }

    @NotNull
    public final SSLContext getSsl() {
        return this.ssl;
    }

    public AsyncTLSSocketFactory() {
        SSLContext sSLContext = SSLContext.getDefault();
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getDefault()");
        this(sSLContext);
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.ssl.createSSLEngine().getEnabledCipherSuites();
        Intrinsics.checkNotNullExpressionValue(stringArray, "ssl.createSSLEngine().enabledCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.ssl.createSSLEngine().getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue(stringArray, "ssl.createSSLEngine().supportedCipherSuites");
        return stringArray;
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull Socket transport, @NotNull String host, int port, boolean autoClose) {
        Object impl;
        Intrinsics.checkNotNullParameter(transport, "transport");
        Intrinsics.checkNotNullParameter(host, "host");
        Method method2 = this.getImplMethod;
        Object object = method2 == null ? null : method2.invoke((Object)transport, new Object[0]);
        if (object == null) {
            Field field = this.implField;
            object = field == null ? null : field.get(transport);
        }
        if ((impl = object) instanceof AsyncSocketImpl) {
            AsynchronousSocketChannel ch2 = ((AsyncSocketImpl)impl).getChannel$ziti();
            return new AsyncTLSChannelSocket(ch2, host, port, this.ssl);
        }
        SSLEngine sSLEngine = this.ssl.createSSLEngine(host, port);
        Intrinsics.checkNotNullExpressionValue(sSLEngine, "ssl.createSSLEngine(host, port)");
        return new ZitiSSLSocket(transport, sSLEngine);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable String host, int port) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), null, this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port, @Nullable InetAddress localHost, int localPort) {
        Intrinsics.checkNotNullParameter(host, "host");
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), new InetSocketAddress(localHost, localPort), this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress host, int port) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), null, this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress address, int port, @Nullable InetAddress localAddress, int localPort) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(address, port), new InetSocketAddress(localAddress, localPort), this.ssl);
    }
}

