/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.util;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0012\u001a\u00020\u0011H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lorg/openziti/util/BufferPool;", "", "capacity", "", "bufferSize", "direct", "", "(IIZ)V", "getBufferSize", "()I", "getCapacity", "getDirect", "()Z", "leftToAlloc", "Ljava/util/concurrent/atomic/AtomicInteger;", "pool", "Lkotlinx/coroutines/channels/Channel;", "Ljava/nio/ByteBuffer;", "get", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "put", "", "b", "ziti"})
public final class BufferPool {
    private final int capacity;
    private final int bufferSize;
    private final boolean direct;
    @NotNull
    private final AtomicInteger leftToAlloc;
    @NotNull
    private final Channel<ByteBuffer> pool;

    public BufferPool(int capacity, int bufferSize, boolean direct) {
        this.capacity = capacity;
        this.bufferSize = bufferSize;
        this.direct = direct;
        this.leftToAlloc = new AtomicInteger(this.capacity);
        if (!(this.capacity > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.bufferSize > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pool = ChannelKt.Channel$default(this.capacity, null, null, 6, null);
    }

    public /* synthetic */ BufferPool(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        this(n, n2, bl);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final boolean getDirect() {
        return this.direct;
    }

    @Nullable
    public final Object get(@NotNull Continuation<? super ByteBuffer> $completion) {
        Object $this$onSuccess$iv = this.pool.tryReceive-PtdJZtk();
        boolean bl = false;
        if (!($this$onSuccess$iv instanceof ChannelResult.Failed)) {
            ByteBuffer it = (ByteBuffer)$this$onSuccess$iv;
            boolean bl2 = false;
            return it;
        }
        if (this.leftToAlloc.decrementAndGet() >= 0) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2;
            if (this.getDirect()) {
                byteBuffer2 = ByteBuffer.allocateDirect(this.getBufferSize());
                Intrinsics.checkNotNullExpressionValue(byteBuffer2, "allocateDirect(bufferSize)");
                byteBuffer = byteBuffer2;
            } else {
                byteBuffer2 = ByteBuffer.allocate(this.getBufferSize());
                Intrinsics.checkNotNullExpressionValue(byteBuffer2, "allocate(bufferSize)");
                byteBuffer = byteBuffer2;
            }
            return byteBuffer;
        }
        return this.pool.receive($completion);
    }

    public final void put(@NotNull ByteBuffer b) {
        Intrinsics.checkNotNullParameter(b, "b");
        if (!(b.capacity() == this.bufferSize)) {
            boolean bl = false;
            String string = "wrong buffer returned";
            throw new IllegalArgumentException(string.toString());
        }
        b.clear();
        this.pool.trySend-JP2dKIU(b);
    }
}

