/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.rainbow.util;

import org.bouncycastle.pqc.legacy.crypto.rainbow.util.GF2Field;

public class ComputeInField {
    private short[][] A;
    short[] x;

    public short[] solveEquation(short[][] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            return null;
        }
        try {
            int n;
            this.A = new short[sArray.length][sArray.length + 1];
            this.x = new short[sArray.length];
            for (n = 0; n < sArray.length; ++n) {
                for (int k = 0; k < sArray[0].length; ++k) {
                    this.A[n][k] = sArray[n][k];
                }
            }
            for (n = 0; n < sArray2.length; ++n) {
                this.A[n][sArray2.length] = GF2Field.addElem(sArray2[n], this.A[n][sArray2.length]);
            }
            this.computeZerosUnder(false);
            this.substitute();
            return this.x;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public short[][] inverse(short[][] sArray) {
        try {
            int n;
            int n2;
            this.A = new short[sArray.length][2 * sArray.length];
            if (sArray.length != sArray[0].length) {
                throw new RuntimeException("The matrix is not invertible. Please choose another one!");
            }
            for (n2 = 0; n2 < sArray.length; ++n2) {
                for (n = 0; n < sArray.length; ++n) {
                    this.A[n2][n] = sArray[n2][n];
                }
                for (n = sArray.length; n < 2 * sArray.length; ++n) {
                    this.A[n2][n] = 0;
                }
                this.A[n2][n2 + this.A.length] = 1;
            }
            this.computeZerosUnder(true);
            for (n2 = 0; n2 < this.A.length; ++n2) {
                short s = GF2Field.invElem(this.A[n2][n2]);
                for (n = n2; n < 2 * this.A.length; ++n) {
                    this.A[n2][n] = GF2Field.multElem(this.A[n2][n], s);
                }
            }
            this.computeZerosAbove();
            short[][] sArray2 = new short[this.A.length][this.A.length];
            for (n2 = 0; n2 < this.A.length; ++n2) {
                for (n = this.A.length; n < 2 * this.A.length; ++n) {
                    sArray2[n2][n - this.A.length] = this.A[n2][n];
                }
            }
            return sArray2;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    private void computeZerosUnder(boolean bl) throws RuntimeException {
        short s = 0;
        int n = bl ? 2 * this.A.length : this.A.length + 1;
        for (int k = 0; k < this.A.length - 1; ++k) {
            for (int i2 = k + 1; i2 < this.A.length; ++i2) {
                short s2 = this.A[i2][k];
                short s3 = GF2Field.invElem(this.A[k][k]);
                if (s3 == 0) {
                    throw new IllegalStateException("Matrix not invertible! We have to choose another one!");
                }
                for (int i3 = k; i3 < n; ++i3) {
                    s = GF2Field.multElem(this.A[k][i3], s3);
                    s = GF2Field.multElem(s2, s);
                    this.A[i2][i3] = GF2Field.addElem(this.A[i2][i3], s);
                }
            }
        }
    }

    private void computeZerosAbove() throws RuntimeException {
        short s = 0;
        for (int k = this.A.length - 1; k > 0; --k) {
            for (int i2 = k - 1; i2 >= 0; --i2) {
                short s2 = this.A[i2][k];
                short s3 = GF2Field.invElem(this.A[k][k]);
                if (s3 == 0) {
                    throw new RuntimeException("The matrix is not invertible");
                }
                for (int i3 = k; i3 < 2 * this.A.length; ++i3) {
                    s = GF2Field.multElem(this.A[k][i3], s3);
                    s = GF2Field.multElem(s2, s);
                    this.A[i2][i3] = GF2Field.addElem(this.A[i2][i3], s);
                }
            }
        }
    }

    private void substitute() throws IllegalStateException {
        short s = GF2Field.invElem(this.A[this.A.length - 1][this.A.length - 1]);
        if (s == 0) {
            throw new IllegalStateException("The equation system is not solvable");
        }
        this.x[this.A.length - 1] = GF2Field.multElem(this.A[this.A.length - 1][this.A.length], s);
        for (int k = this.A.length - 2; k >= 0; --k) {
            short s2 = this.A[k][this.A.length];
            for (int i2 = this.A.length - 1; i2 > k; --i2) {
                s = GF2Field.multElem(this.A[k][i2], this.x[i2]);
                s2 = GF2Field.addElem(s2, s);
            }
            s = GF2Field.invElem(this.A[k][k]);
            if (s == 0) {
                throw new IllegalStateException("Not solvable equation system");
            }
            this.x[k] = GF2Field.multElem(s2, s);
        }
    }

    public short[][] multiplyMatrix(short[][] sArray, short[][] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s = 0;
        this.A = new short[sArray.length][sArray2[0].length];
        for (int k = 0; k < sArray.length; ++k) {
            for (int i2 = 0; i2 < sArray2.length; ++i2) {
                for (int i3 = 0; i3 < sArray2[0].length; ++i3) {
                    s = GF2Field.multElem(sArray[k][i2], sArray2[i2][i3]);
                    this.A[k][i3] = GF2Field.addElem(this.A[k][i3], s);
                }
            }
        }
        return this.A;
    }

    public short[] multiplyMatrix(short[][] sArray, short[] sArray2) throws RuntimeException {
        if (sArray[0].length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short s = 0;
        short[] sArray3 = new short[sArray.length];
        for (int k = 0; k < sArray.length; ++k) {
            for (int i2 = 0; i2 < sArray2.length; ++i2) {
                s = GF2Field.multElem(sArray[k][i2], sArray2[i2]);
                sArray3[k] = GF2Field.addElem(sArray3[k], s);
            }
        }
        return sArray3;
    }

    public short[] addVect(short[] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[] sArray3 = new short[sArray.length];
        for (int k = 0; k < sArray3.length; ++k) {
            sArray3[k] = GF2Field.addElem(sArray[k], sArray2[k]);
        }
        return sArray3;
    }

    public short[][] multVects(short[] sArray, short[] sArray2) {
        if (sArray.length != sArray2.length) {
            throw new RuntimeException("Multiplication is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray2.length];
        for (int k = 0; k < sArray.length; ++k) {
            for (int i2 = 0; i2 < sArray2.length; ++i2) {
                sArray3[k][i2] = GF2Field.multElem(sArray[k], sArray2[i2]);
            }
        }
        return sArray3;
    }

    public short[] multVect(short s, short[] sArray) {
        short[] sArray2 = new short[sArray.length];
        for (int k = 0; k < sArray2.length; ++k) {
            sArray2[k] = GF2Field.multElem(s, sArray[k]);
        }
        return sArray2;
    }

    public short[][] multMatrix(short s, short[][] sArray) {
        short[][] sArray2 = new short[sArray.length][sArray[0].length];
        for (int k = 0; k < sArray.length; ++k) {
            for (int i2 = 0; i2 < sArray[0].length; ++i2) {
                sArray2[k][i2] = GF2Field.multElem(s, sArray[k][i2]);
            }
        }
        return sArray2;
    }

    public short[][] addSquareMatrix(short[][] sArray, short[][] sArray2) {
        if (sArray.length != sArray2.length || sArray[0].length != sArray2[0].length) {
            throw new RuntimeException("Addition is not possible!");
        }
        short[][] sArray3 = new short[sArray.length][sArray.length];
        for (int k = 0; k < sArray.length; ++k) {
            for (int i2 = 0; i2 < sArray2.length; ++i2) {
                sArray3[k][i2] = GF2Field.addElem(sArray[k][i2], sArray2[k][i2]);
            }
        }
        return sArray3;
    }
}

