/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Function;
import com.sun.jna.InvocationMapper;
import com.sun.jna.NativeLibrary;
import com.sun.jna.internal.ReflectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public interface Library {
    public static final String OPTION_TYPE_MAPPER = "type-mapper";
    public static final String OPTION_FUNCTION_MAPPER = "function-mapper";
    public static final String OPTION_INVOCATION_MAPPER = "invocation-mapper";
    public static final String OPTION_STRUCTURE_ALIGNMENT = "structure-alignment";
    public static final String OPTION_STRING_ENCODING = "string-encoding";
    public static final String OPTION_ALLOW_OBJECTS = "allow-objects";
    public static final String OPTION_CALLING_CONVENTION = "calling-convention";
    public static final String OPTION_OPEN_FLAGS = "open-flags";
    public static final String OPTION_CLASSLOADER = "classloader";

    public static class Handler
    implements InvocationHandler {
        static final Method OBJECT_TOSTRING;
        static final Method OBJECT_HASHCODE;
        static final Method OBJECT_EQUALS;
        private final NativeLibrary nativeLibrary;
        private final Class<?> interfaceClass;
        private final Map<String, Object> options;
        private final InvocationMapper invocationMapper;
        private final Map<Method, FunctionInfo> functions = new WeakHashMap<Method, FunctionInfo>();

        public Handler(String libname, Class<?> interfaceClass, Map<String, ?> options) {
            int callingConvention;
            if (libname != null && "".equals(libname.trim())) {
                throw new IllegalArgumentException("Invalid library name \"" + libname + "\"");
            }
            if (!interfaceClass.isInterface()) {
                throw new IllegalArgumentException(libname + " does not implement an interface: " + interfaceClass.getName());
            }
            this.interfaceClass = interfaceClass;
            this.options = new HashMap(options);
            int n = callingConvention = AltCallingConvention.class.isAssignableFrom(interfaceClass) ? 63 : 0;
            if (this.options.get(Library.OPTION_CALLING_CONVENTION) == null) {
                this.options.put(Library.OPTION_CALLING_CONVENTION, callingConvention);
            }
            if (this.options.get(Library.OPTION_CLASSLOADER) == null) {
                this.options.put(Library.OPTION_CLASSLOADER, interfaceClass.getClassLoader());
            }
            this.nativeLibrary = NativeLibrary.getInstance(libname, this.options);
            this.invocationMapper = (InvocationMapper)this.options.get(Library.OPTION_INVOCATION_MAPPER);
        }

        public NativeLibrary getNativeLibrary() {
            return this.nativeLibrary;
        }

        public String getLibraryName() {
            return this.nativeLibrary.getName();
        }

        public Class<?> getInterfaceClass() {
            return this.interfaceClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method2, Object[] inArgs) throws Throwable {
            if (OBJECT_TOSTRING.equals(method2)) {
                return "Proxy interface to " + this.nativeLibrary;
            }
            if (OBJECT_HASHCODE.equals(method2)) {
                return this.hashCode();
            }
            if (OBJECT_EQUALS.equals(method2)) {
                Object o = inArgs[0];
                if (o != null && Proxy.isProxyClass(o.getClass())) {
                    return Function.valueOf(Proxy.getInvocationHandler(o) == this);
                }
                return Boolean.FALSE;
            }
            FunctionInfo f2 = this.functions.get(method2);
            if (f2 == null) {
                Map<Method, FunctionInfo> map2 = this.functions;
                synchronized (map2) {
                    f2 = this.functions.get(method2);
                    if (f2 == null) {
                        boolean isDefault = ReflectionUtils.isDefault(method2);
                        if (!isDefault) {
                            boolean isVarArgs = Function.isVarArgs(method2);
                            InvocationHandler handler = null;
                            if (this.invocationMapper != null) {
                                handler = this.invocationMapper.getInvocationHandler(this.nativeLibrary, method2);
                            }
                            Function function = null;
                            Class<?>[] parameterTypes = null;
                            HashMap<String, Object> options = null;
                            if (handler == null) {
                                function = this.nativeLibrary.getFunction(method2.getName(), method2);
                                parameterTypes = method2.getParameterTypes();
                                options = new HashMap<String, Object>(this.options);
                                options.put("invoking-method", method2);
                            }
                            f2 = new FunctionInfo(handler, function, parameterTypes, isVarArgs, options);
                        } else {
                            f2 = new FunctionInfo(ReflectionUtils.getMethodHandle(method2));
                        }
                        this.functions.put(method2, f2);
                    }
                }
            }
            if (f2.methodHandle != null) {
                return ReflectionUtils.invokeDefaultMethod(proxy, f2.methodHandle, inArgs);
            }
            if (f2.isVarArgs) {
                inArgs = Function.concatenateVarArgs(inArgs);
            }
            if (f2.handler != null) {
                return f2.handler.invoke(proxy, method2, inArgs);
            }
            return f2.function.invoke(method2, f2.parameterTypes, method2.getReturnType(), inArgs, f2.options);
        }

        static {
            try {
                OBJECT_TOSTRING = Object.class.getMethod("toString", new Class[0]);
                OBJECT_HASHCODE = Object.class.getMethod("hashCode", new Class[0]);
                OBJECT_EQUALS = Object.class.getMethod("equals", Object.class);
            }
            catch (Exception e2) {
                throw new Error("Error retrieving Object.toString() method");
            }
        }

        private static final class FunctionInfo {
            final InvocationHandler handler;
            final Function function;
            final boolean isVarArgs;
            final Object methodHandle;
            final Map<String, ?> options;
            final Class<?>[] parameterTypes;

            FunctionInfo(Object mh) {
                this.handler = null;
                this.function = null;
                this.isVarArgs = false;
                this.options = null;
                this.parameterTypes = null;
                this.methodHandle = mh;
            }

            FunctionInfo(InvocationHandler handler, Function function, Class<?>[] parameterTypes, boolean isVarArgs, Map<String, ?> options) {
                this.handler = handler;
                this.function = function;
                this.isVarArgs = isVarArgs;
                this.options = options;
                this.parameterTypes = parameterTypes;
                this.methodHandle = null;
            }
        }
    }
}

