/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.Poly;

class PolyVecK {
    Poly[] vec;
    private DilithiumEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumK;
    private int dilithiumL;

    public PolyVecK(DilithiumEngine dilithiumEngine) {
        this.engine = dilithiumEngine;
        this.mode = dilithiumEngine.getDilithiumMode();
        this.dilithiumK = dilithiumEngine.getDilithiumK();
        this.dilithiumL = dilithiumEngine.getDilithiumL();
        this.vec = new Poly[this.dilithiumK];
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.vec[k] = new Poly(dilithiumEngine);
        }
    }

    public PolyVecK() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    public void setVectorIndex(int n, Poly poly) {
        this.vec[n] = poly;
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        for (int k = 0; k < this.dilithiumK; ++k) {
            short s3 = s2;
            s2 = (short)(s2 + 1);
            this.getVectorIndex(k).uniformEta(byArray, s3);
        }
    }

    public void reduce() {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).reduce();
        }
    }

    public void invNttToMont() {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).invNttToMont();
        }
    }

    public void addPolyVecK(PolyVecK polyVecK) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).addPoly(polyVecK.getVectorIndex(k));
        }
    }

    public void conditionalAddQ() {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).conditionalAddQ();
        }
    }

    public void power2Round(PolyVecK polyVecK) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).power2Round(polyVecK.getVectorIndex(k));
        }
    }

    public void polyVecNtt() {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.vec[k].polyNtt();
        }
    }

    public void decompose(PolyVecK polyVecK) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).decompose(polyVecK.getVectorIndex(k));
        }
    }

    public byte[] packW1() {
        byte[] byArray = new byte[this.dilithiumK * this.engine.getDilithiumPolyW1PackedBytes()];
        for (int k = 0; k < this.dilithiumK; ++k) {
            System.arraycopy(this.getVectorIndex(k).w1Pack(), 0, byArray, k * this.engine.getDilithiumPolyW1PackedBytes(), this.engine.getDilithiumPolyW1PackedBytes());
        }
        return byArray;
    }

    public void pointwisePolyMontgomery(Poly poly, PolyVecK polyVecK) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).pointwiseMontgomery(poly, polyVecK.getVectorIndex(k));
        }
    }

    public void subtract(PolyVecK polyVecK) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).subtract(polyVecK.getVectorIndex(k));
        }
    }

    public boolean checkNorm(int n) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            if (!this.getVectorIndex(k).checkNorm(n)) continue;
            return true;
        }
        return false;
    }

    public int makeHint(PolyVecK polyVecK, PolyVecK polyVecK2) {
        int n = 0;
        for (int k = 0; k < this.dilithiumK; ++k) {
            n += this.getVectorIndex(k).polyMakeHint(polyVecK.getVectorIndex(k), polyVecK2.getVectorIndex(k));
        }
        return n;
    }

    public void useHint(PolyVecK polyVecK, PolyVecK polyVecK2) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).polyUseHint(polyVecK.getVectorIndex(k), polyVecK2.getVectorIndex(k));
        }
    }

    public void shiftLeft() {
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.getVectorIndex(k).shiftLeft();
        }
    }

    public String toString() {
        String string = "[";
        for (int k = 0; k < this.dilithiumK; ++k) {
            string = string + k + " " + this.getVectorIndex(k).toString();
            if (k == this.dilithiumK - 1) continue;
            string = string + ",\n";
        }
        string = string + "]";
        return string;
    }

    public String toString(String string) {
        return string + ": " + this.toString();
    }
}

