/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.Poly;

class PolyVecL {
    Poly[] vec;
    private DilithiumEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumL;
    private int dilithiumK;

    public PolyVecL(DilithiumEngine dilithiumEngine) {
        this.engine = dilithiumEngine;
        this.mode = dilithiumEngine.getDilithiumMode();
        this.dilithiumL = dilithiumEngine.getDilithiumL();
        this.dilithiumK = dilithiumEngine.getDilithiumK();
        this.vec = new Poly[this.dilithiumL];
        for (int k = 0; k < this.dilithiumL; ++k) {
            this.vec[k] = new Poly(dilithiumEngine);
        }
    }

    public PolyVecL() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    public void expandMatrix(byte[] byArray, int n) {
        for (int k = 0; k < this.dilithiumL; ++k) {
            this.vec[k].uniformBlocks(byArray, (short)((n << 8) + k));
        }
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        for (int k = 0; k < this.dilithiumL; ++k) {
            short s3 = s2;
            s2 = (short)(s2 + 1);
            this.getVectorIndex(k).uniformEta(byArray, s3);
        }
    }

    public void copyPolyVecL(PolyVecL polyVecL) {
        for (int k = 0; k < this.dilithiumL; ++k) {
            for (int i2 = 0; i2 < 256; ++i2) {
                polyVecL.getVectorIndex(k).setCoeffIndex(i2, this.getVectorIndex(k).getCoeffIndex(i2));
            }
        }
    }

    public void polyVecNtt() {
        for (int k = 0; k < this.dilithiumL; ++k) {
            this.vec[k].polyNtt();
        }
    }

    public void uniformGamma1(byte[] byArray, short s) {
        for (int k = 0; k < this.dilithiumL; ++k) {
            this.getVectorIndex(k).uniformGamma1(byArray, (short)(this.dilithiumL * s + k));
        }
    }

    public void pointwisePolyMontgomery(Poly poly, PolyVecL polyVecL) {
        for (int k = 0; k < this.dilithiumL; ++k) {
            this.getVectorIndex(k).pointwiseMontgomery(poly, polyVecL.getVectorIndex(k));
        }
    }

    public void invNttToMont() {
        for (int k = 0; k < this.dilithiumL; ++k) {
            this.getVectorIndex(k).invNttToMont();
        }
    }

    public void addPolyVecL(PolyVecL polyVecL) {
        for (int k = 0; k < this.dilithiumL; ++k) {
            this.getVectorIndex(k).addPoly(polyVecL.getVectorIndex(k));
        }
    }

    public void reduce() {
        for (int k = 0; k < this.dilithiumL; ++k) {
            this.getVectorIndex(k).reduce();
        }
    }

    public boolean checkNorm(int n) {
        for (int k = 0; k < this.dilithiumL; ++k) {
            if (!this.getVectorIndex(k).checkNorm(n)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "\n[";
        for (int k = 0; k < this.dilithiumL; ++k) {
            string = string + "Inner Matrix " + k + " " + this.getVectorIndex(k).toString();
            if (k == this.dilithiumL - 1) continue;
            string = string + ",\n";
        }
        string = string + "]";
        return string;
    }

    public String toString(String string) {
        return string + ": " + this.toString();
    }
}

