/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecK;
import org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecL;

class PolyVecMatrix {
    private final int dilithiumK;
    private final int dilithiumL;
    private final PolyVecL[] mat;

    public PolyVecMatrix(DilithiumEngine dilithiumEngine) {
        this.dilithiumK = dilithiumEngine.getDilithiumK();
        this.dilithiumL = dilithiumEngine.getDilithiumL();
        this.mat = new PolyVecL[this.dilithiumK];
        for (int k = 0; k < this.dilithiumK; ++k) {
            this.mat[k] = new PolyVecL(dilithiumEngine);
        }
    }

    public void pointwiseMontgomery(PolyVecK polyVecK, PolyVecL polyVecL) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            polyVecK.getVectorIndex(k).pointwiseAccountMontgomery(this.mat[k], polyVecL);
        }
    }

    public void expandMatrix(byte[] byArray) {
        for (int k = 0; k < this.dilithiumK; ++k) {
            for (int i2 = 0; i2 < this.dilithiumL; ++i2) {
                this.mat[k].getVectorIndex(i2).uniformBlocks(byArray, (short)((k << 8) + i2));
            }
        }
    }

    private String addString() {
        String string = "[";
        for (int k = 0; k < this.dilithiumK; ++k) {
            string = string + "Outer Matrix " + k + " [";
            string = string + this.mat[k].toString();
            string = k == this.dilithiumK - 1 ? string + "]\n" : string + "],\n";
        }
        string = string + "]\n";
        return string;
    }

    public String toString(String string) {
        return string.concat(": \n" + this.addString());
    }
}

