/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;

class Signature {
    byte[] challengeBits;
    byte[] salt = new byte[32];
    Proof[] proofs;

    Signature(PicnicEngine picnicEngine) {
        this.challengeBits = new byte[Utils.numBytes(picnicEngine.numMPCRounds * 2)];
        this.proofs = new Proof[picnicEngine.numMPCRounds];
        for (int k = 0; k < this.proofs.length; ++k) {
            this.proofs[k] = new Proof(picnicEngine);
        }
    }

    public static class Proof {
        byte[] seed1;
        byte[] seed2;
        int[] inputShare;
        byte[] communicatedBits;
        byte[] view3Commitment;
        byte[] view3UnruhG;

        Proof(PicnicEngine picnicEngine) {
            this.seed1 = new byte[picnicEngine.seedSizeBytes];
            this.seed2 = new byte[picnicEngine.seedSizeBytes];
            this.inputShare = new int[picnicEngine.stateSizeBytes];
            this.communicatedBits = new byte[picnicEngine.andSizeBytes];
            this.view3Commitment = new byte[picnicEngine.digestSizeBytes];
            this.view3UnruhG = (byte[])(picnicEngine.UnruhGWithInputBytes > 0 ? new byte[picnicEngine.UnruhGWithInputBytes] : null);
        }
    }
}

