/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.pqc.crypto.picnic.KMatricesWithPointer;
import org.bouncycastle.pqc.crypto.picnic.LowmcConstants;
import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

class Tape {
    byte[][] tapes;
    int pos;
    int nTapes;
    private PicnicEngine engine;

    public Tape(PicnicEngine picnicEngine) {
        this.engine = picnicEngine;
        this.tapes = new byte[picnicEngine.numMPCParties][2 * picnicEngine.andSizeBytes];
        this.pos = 0;
        this.nTapes = picnicEngine.numMPCParties;
    }

    protected void setAuxBits(byte[] byArray) {
        int n = this.engine.numMPCParties - 1;
        int n2 = 0;
        int n3 = this.engine.stateSizeBits;
        for (int k = 0; k < this.engine.numRounds; ++k) {
            for (int i2 = 0; i2 < n3; ++i2) {
                Utils.setBit(this.tapes[n], n3 + n3 * 2 * k + i2, Utils.getBit(byArray, n2++));
            }
        }
    }

    protected void computeAuxTape(byte[] byArray) {
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[16];
        int[] nArray5 = new int[16];
        nArray5[this.engine.stateSizeWords - 1] = 0;
        this.tapesToParityBits(nArray5, this.engine.stateSizeBits);
        KMatricesWithPointer kMatricesWithPointer = LowmcConstants.KMatrixInv(this.engine);
        this.engine.matrix_mul(nArray4, nArray5, kMatricesWithPointer.getData(), kMatricesWithPointer.getMatrixPointer());
        if (byArray != null) {
            Pack.intToLittleEndian(Arrays.copyOf(nArray4, this.engine.stateSizeWords), byArray, 0);
        }
        for (int k = this.engine.numRounds; k > 0; --k) {
            kMatricesWithPointer = LowmcConstants.KMatrix(this.engine, k);
            this.engine.matrix_mul(nArray, nArray4, kMatricesWithPointer.getData(), kMatricesWithPointer.getMatrixPointer());
            this.engine.xor_array(nArray2, nArray2, nArray, 0, this.engine.stateSizeWords);
            kMatricesWithPointer = LowmcConstants.LMatrixInv(this.engine, k - 1);
            this.engine.matrix_mul(nArray3, nArray2, kMatricesWithPointer.getData(), kMatricesWithPointer.getMatrixPointer());
            if (k == 1) {
                System.arraycopy(nArray5, 0, nArray2, 0, nArray5.length);
            } else {
                this.pos = this.engine.stateSizeBits * 2 * (k - 1);
                this.tapesToParityBits(nArray2, this.engine.stateSizeBits);
            }
            this.pos = this.engine.stateSizeBits * 2 * (k - 1) + this.engine.stateSizeBits;
            this.engine.aux_mpc_sbox(nArray2, nArray3, this);
        }
        this.pos = 0;
    }

    private void tapesToParityBits(int[] nArray, int n) {
        for (int k = 0; k < n; ++k) {
            Utils.setBitInWordArray(nArray, k, Utils.parity16(this.tapesToWord()));
        }
    }

    protected int tapesToWord() {
        byte[] byArray = new byte[4];
        for (int k = 0; k < 16; ++k) {
            byte by = Utils.getBit(this.tapes[k], this.pos);
            Utils.setBit(byArray, k, by);
        }
        ++this.pos;
        return Pack.littleEndianToInt(byArray, 0);
    }
}

