/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.util;

import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\u00110\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/openziti/util/PrivateKeySigner;", "Lorg/bouncycastle/operator/ContentSigner;", "key", "Ljava/security/PrivateKey;", "sigAlg", "", "(Ljava/security/PrivateKey;Ljava/lang/String;)V", "getKey", "()Ljava/security/PrivateKey;", "sig", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "getSig", "()Ljava/security/Signature;", "getSigAlg", "()Ljava/lang/String;", "getAlgorithmIdentifier", "Lorg/bouncycastle/asn1/x509/AlgorithmIdentifier;", "getOutputStream", "Ljava/io/OutputStream;", "getSignature", "", "ziti"})
public final class PrivateKeySigner
implements ContentSigner {
    @NotNull
    private final PrivateKey key;
    @NotNull
    private final String sigAlg;
    private final Signature sig;

    public PrivateKeySigner(@NotNull PrivateKey key, @NotNull String sigAlg) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(sigAlg, "sigAlg");
        this.key = key;
        this.sigAlg = sigAlg;
        this.sig = Signature.getInstance(this.sigAlg);
        this.sig.initSign(this.key);
    }

    @NotNull
    public final PrivateKey getKey() {
        return this.key;
    }

    @NotNull
    public final String getSigAlg() {
        return this.sigAlg;
    }

    public final Signature getSig() {
        return this.sig;
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return new DefaultSignatureAlgorithmIdentifierFinder().find(this.sigAlg);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return new OutputStream(this){
            final /* synthetic */ PrivateKeySigner this$0;
            {
                this.this$0 = $receiver;
            }

            public void write(int b) {
                this.this$0.getSig().update((byte)b);
            }

            public void write(@Nullable byte[] b) {
                this.this$0.getSig().update(b);
            }

            public void write(@Nullable byte[] b, int off, int len) {
                this.this$0.getSig().update(b, off, len);
            }
        };
    }

    @Override
    @NotNull
    public byte[] getSignature() {
        byte[] byArray = this.sig.sign();
        Intrinsics.checkNotNullExpressionValue(byArray, "sig.sign()");
        return byArray;
    }
}

