/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.internal.Sockets;
import org.openziti.util.Logged;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003JKLB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u001a\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001eH\u0014J\b\u0010#\u001a\u00020$H\u0014J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001eH\u0014J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u001eH\u0014J\u0018\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020(2\u0006\u0010\"\u001a\u00020\u001eH\u0014J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0014J\u0011\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u0010,\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u0011\u00100\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u0019\u00100\u001a\u00020$2\u0006\u0010-\u001a\u00020(2\u0006\u00101\u001a\u000202H\u0096\u0001J%\u00100\u001a\u00020$2\b\u00103\u001a\u0004\u0018\u0001022\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u001b\u00100\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\n\u00104\u001a\u0004\u0018\u00010!H\u0014J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u001eH\u0014J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\u001eH\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u001eH\u0014J\u0011\u0010>\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u0010>\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u0010\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001eH\u0014J\u0010\u0010A\u001a\u00020$2\u0006\u0010B\u001a\u00020\u001eH\u0014J\u001a\u0010C\u001a\u00020$2\u0006\u0010:\u001a\u00020\u001e2\b\u0010D\u001a\u0004\u0018\u000109H\u0016J\b\u0010E\u001a\u00020$H\u0014J\b\u0010F\u001a\u00020$H\u0014J\u0011\u00101\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u00101\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u0010\u0010G\u001a\u00020\u001b2\u0006\u00103\u001a\u000202H\u0002J\u0011\u0010H\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u0010H\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u0011\u0010I\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u0010I\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001R\u001a\u0010\t\u001a\u00020\u0004X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006M"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl;", "Ljava/net/SocketImpl;", "Lorg/openziti/util/Logged;", "ch", "Ljava/nio/channels/AsynchronousSocketChannel;", "(Ljava/nio/channels/AsynchronousSocketChannel;)V", "connector", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "(Lorg/openziti/net/nio/AsyncSocketImpl$Connector;)V", "channel", "getChannel$ziti", "()Ljava/nio/channels/AsynchronousSocketChannel;", "setChannel$ziti", "input", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "getInput$ziti", "()Ljava/nio/ByteBuffer;", "inputLock", "Ljava/util/concurrent/Semaphore;", "getInputLock$ziti", "()Ljava/util/concurrent/Semaphore;", "timeout", "Ljava/util/concurrent/atomic/AtomicInteger;", "getTimeout$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "accept", "", "s", "available", "", "bind", "host", "Ljava/net/InetAddress;", "port", "close", "", "connect", "address", "Ljava/net/SocketAddress;", "", "create", "stream", "", "d", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "getInetAddress", "getInputStream", "Ljava/io/InputStream;", "getLocalPort", "getOption", "", "optID", "getOutputStream", "Ljava/io/OutputStream;", "getPort", "i", "listen", "backlog", "sendUrgentData", "data", "setOption", "value", "shutdownInput", "shutdownOutput", "throwIOException", "v", "w", "Connector", "DefaultConnector", "channelConnector", "ziti"})
public final class AsyncSocketImpl
extends SocketImpl
implements Logged {
    @NotNull
    private final Connector connector;
    private final /* synthetic */ ZitiLog $$delegate_0;
    public AsynchronousSocketChannel channel;
    @NotNull
    private final Semaphore inputLock;
    private final ByteBuffer input;
    @NotNull
    private final AtomicInteger timeout;

    /*
     * WARNING - void declaration
     */
    public AsyncSocketImpl(@NotNull Connector connector) {
        void $this$input_u24lambda_u240;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        this.connector = connector;
        this.$$delegate_0 = new ZitiLog();
        this.inputLock = new Semaphore(1);
        ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocate(32768);
        AsyncSocketImpl asyncSocketImpl = this;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$input_u24lambda_u240, (String)"null cannot be cast to non-null type java.nio.Buffer");
        ((Buffer)$this$input_u24lambda_u240).flip();
        asyncSocketImpl.input = byteBuffer;
        this.timeout = new AtomicInteger(Sockets.INSTANCE.getDefaultSoTimeout());
    }

    public /* synthetic */ AsyncSocketImpl(Connector connector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            connector = DefaultConnector.INSTANCE;
        }
        this(connector);
    }

    @Override
    public void d(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void d(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void e(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void e(@NotNull String msg2, @NotNull Throwable t2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        this.$$delegate_0.e(msg2, t2);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.e(ex, msg2);
    }

    @Override
    public void e(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void i(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void i(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void t(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void t(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void v(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void v(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void w(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.w(msg2);
    }

    @Override
    public void w(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.w(msg2);
    }

    public AsyncSocketImpl(@NotNull AsynchronousSocketChannel ch2) {
        Intrinsics.checkNotNullParameter((Object)ch2, (String)"ch");
        this(new channelConnector(ch2));
        this.setChannel$ziti(ch2);
    }

    @NotNull
    public final AsynchronousSocketChannel getChannel$ziti() {
        AsynchronousSocketChannel asynchronousSocketChannel = this.channel;
        if (asynchronousSocketChannel != null) {
            return asynchronousSocketChannel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        return null;
    }

    public final void setChannel$ziti(@NotNull AsynchronousSocketChannel asynchronousSocketChannel) {
        Intrinsics.checkNotNullParameter((Object)asynchronousSocketChannel, (String)"<set-?>");
        this.channel = asynchronousSocketChannel;
    }

    @NotNull
    public final Semaphore getInputLock$ziti() {
        return this.inputLock;
    }

    public final ByteBuffer getInput$ziti() {
        return this.input;
    }

    @NotNull
    public final AtomicInteger getTimeout$ziti() {
        return this.timeout;
    }

    @NotNull
    protected Void bind(@Nullable InetAddress host, int port) {
        throw new IllegalStateException("only client sockets are supported".toString());
    }

    @NotNull
    protected Void accept(@Nullable SocketImpl s) {
        throw new IllegalStateException("only client sockets are supported".toString());
    }

    @NotNull
    protected Void listen(int backlog) {
        throw new IllegalStateException("only client sockets are supported".toString());
    }

    @Override
    @Nullable
    protected InetAddress getInetAddress() {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.getChannel$ziti().getRemoteAddress();
        return inetSocketAddress != null ? inetSocketAddress.getAddress() : null;
    }

    @Override
    protected int getPort() {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.getChannel$ziti().getRemoteAddress();
        return inetSocketAddress != null ? inetSocketAddress.getPort() : 0;
    }

    @Override
    protected int getLocalPort() {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.getChannel$ziti().getLocalAddress();
        return inetSocketAddress != null ? inetSocketAddress.getPort() : 0;
    }

    @Override
    protected void shutdownInput() {
        this.getChannel$ziti().shutdownInput();
    }

    @Override
    protected void shutdownOutput() {
        this.getChannel$ziti().shutdownOutput();
    }

    @Override
    protected void create(boolean stream) {
        if (!stream) {
            boolean bl = false;
            String string = "only stream sockets are supported";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    protected void connect(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.connect(new InetSocketAddress(host, port), 0);
    }

    @Override
    protected void connect(@NotNull InetAddress address, int port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.connect(new InetSocketAddress(address, port), 0);
    }

    @Override
    protected void connect(@NotNull SocketAddress address, int timeout) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (this.channel == null) {
            try {
                this.setChannel$ziti(this.connector.connect(address, timeout));
            }
            catch (IOException cex) {
                if (!Intrinsics.areEqual((Object)this.connector, (Object)DefaultConnector.INSTANCE)) {
                    this.setChannel$ziti(DefaultConnector.INSTANCE.connect(address, timeout));
                }
                throw cex;
            }
        } else {
            Object object;
            long longTO = timeout > 0 ? (long)timeout : Long.MAX_VALUE;
            Object object2 = this.getChannel$ziti().connect(address);
            try {
                Future<Void> $this$connect_u24lambda_u242 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)$this$connect_u24lambda_u242.get(longTO, TimeUnit.MILLISECONDS));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                this.throwIOException((Throwable)it);
                throw new KotlinNothingValueException();
            }
        }
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new InputStream(this){
            final /* synthetic */ AsyncSocketImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public int read() {
                byte[] oneByte = new byte[1];
                int rc = this.read(oneByte, 0, 1);
                if (rc < 0) {
                    return -1;
                }
                return oneByte[0];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(@NotNull byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                ByteBuffer byteBuffer = this.this$0.getInput$ziti();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"input");
                ByteBuffer byteBuffer2 = byteBuffer;
                AsyncSocketImpl asyncSocketImpl = this.this$0;
                ByteBuffer byteBuffer3 = byteBuffer2;
                synchronized (byteBuffer3) {
                    Object result;
                    Object $this$read_u24lambda_u242_u24lambda_u240;
                    block9: {
                        boolean bl = false;
                        asyncSocketImpl.getInputLock$ziti().acquire();
                        int count = Math.min(len, asyncSocketImpl.getInput$ziti().remaining());
                        if (count <= 0) break block9;
                        asyncSocketImpl.getInput$ziti().get(b, off, count);
                        asyncSocketImpl.getInputLock$ziti().release();
                        int n = count;
                        return n;
                    }
                    asyncSocketImpl.getInput$ziti().compact();
                    CompletableFuture<T> rf = new CompletableFuture<T>();
                    Object object = asyncSocketImpl.getOption(4102);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
                    long to = ((Number)object).longValue();
                    asyncSocketImpl.getChannel$ziti().read(asyncSocketImpl.getInput$ziti(), 0L, TimeUnit.MILLISECONDS, rf, (CompletionHandler)new CompletionHandler<Integer, CompletableFuture<Integer>>(asyncSocketImpl){
                        final /* synthetic */ AsyncSocketImpl this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void completed(int result, @NotNull CompletableFuture<Integer> f2) {
                            Intrinsics.checkNotNullParameter(f2, (String)"f");
                            if (!f2.isDone()) {
                                f2.complete(result);
                            }
                            this.this$0.getInput$ziti().flip();
                            this.this$0.getInputLock$ziti().release();
                        }

                        public void failed(@NotNull Throwable exc, @NotNull CompletableFuture<Integer> f2) {
                            Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
                            Intrinsics.checkNotNullParameter(f2, (String)"f");
                            if (!f2.isDone()) {
                                f2.completeExceptionally(exc);
                            }
                            this.this$0.getInputLock$ziti().release();
                        }
                    });
                    Object object2 = this;
                    try {
                        int n;
                        Integer read2;
                        $this$read_u24lambda_u242_u24lambda_u240 = object2;
                        boolean bl = false;
                        Integer n2 = read2 = to > 0L ? (Integer)rf.get(to, TimeUnit.MILLISECONDS) : (Integer)rf.get();
                        int n3 = -1;
                        if (n2 != null && n2 == n3) {
                            n = -1;
                        } else {
                            asyncSocketImpl.getInputLock$ziti().acquire();
                            int count1 = Math.min(len, asyncSocketImpl.getInput$ziti().remaining());
                            asyncSocketImpl.getInput$ziti().get(b, off, count1);
                            asyncSocketImpl.getInputLock$ziti().release();
                            n = count1;
                        }
                        $this$read_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)n);
                    }
                    catch (Throwable bl) {
                        $this$read_u24lambda_u242_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object2 = result = $this$read_u24lambda_u242_u24lambda_u240;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable != null) {
                        Throwable ex = throwable;
                        boolean bl = false;
                        AsyncSocketImpl.access$throwIOException(asyncSocketImpl, ex);
                        throw new KotlinNothingValueException();
                    }
                    int n = ((Number)object2).intValue();
                    return n;
                }
            }

            public int available() {
                return this.this$0.getInput$ziti().remaining();
            }
        };
    }

    @Override
    protected void close() {
        if (this.channel != null) {
            this.getChannel$ziti().close();
        }
    }

    @Override
    @Nullable
    public Object getOption(int optID) {
        if (optID == 4102) {
            return this.timeout.get();
        }
        if (optID == 4099) {
            return false;
        }
        return null;
    }

    @Override
    public void setOption(int optID, @Nullable Object value) {
        if (optID == 4102) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Number");
            this.timeout.set(((Number)value).intValue());
        }
        if (optID == 4099) {
            throw new SocketException("SO_OOBINLINE is not supported");
        }
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return new OutputStream(this){
            final /* synthetic */ AsyncSocketImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void write(int b) {
                byte[] byArray = new byte[]{(byte)b};
                this.write(byArray);
            }

            public void write(@NotNull byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                ByteBuffer buf = ByteBuffer.wrap(b, off, len);
                while (buf.hasRemaining()) {
                    Object object;
                    Object object2 = this.this$0.getChannel$ziti().write(buf);
                    AsyncSocketImpl asyncSocketImpl = this.this$0;
                    try {
                        Future<Integer> $this$write_u24lambda_u240 = object2;
                        boolean bl = false;
                        object = Result.constructor-impl((Object)(asyncSocketImpl.getTimeout$ziti().longValue() > 0L ? $this$write_u24lambda_u240.get(asyncSocketImpl.getTimeout$ziti().longValue(), TimeUnit.MILLISECONDS) : $this$write_u24lambda_u240.get()));
                    }
                    catch (Throwable bl) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object2 = object;
                    asyncSocketImpl = this.this$0;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable == null) continue;
                    Object ex = object = throwable;
                    boolean bl = false;
                    asyncSocketImpl.w((Function0<String>)((Function0)new Function0<String>((Throwable)ex, b, off, len){
                        final /* synthetic */ Throwable $ex;
                        final /* synthetic */ byte[] $b;
                        final /* synthetic */ int $off;
                        final /* synthetic */ int $len;
                        {
                            this.$ex = $ex;
                            this.$b = $b;
                            this.$off = $off;
                            this.$len = $len;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "unexpected exception[" + this.$ex.getMessage() + "] during write[buf.len=" + this.$b.length + ", off=" + this.$off + ", len=" + this.$len + ']';
                        }
                    }));
                    AsyncSocketImpl.access$throwIOException(asyncSocketImpl, (Throwable)ex);
                    throw new KotlinNothingValueException();
                }
            }
        };
    }

    @Override
    protected int available() {
        return this.input.remaining();
    }

    @Override
    protected void sendUrgentData(int data) {
        this.getOutputStream().write(data);
    }

    private final Void throwIOException(Throwable ex) {
        if (ex instanceof IOException) {
            throw ex;
        }
        if (ex instanceof TimeoutException) {
            throw new SocketTimeoutException(ex.getMessage());
        }
        Throwable cause = ex.getCause();
        if (cause instanceof IOException) {
            throw cause;
        }
        throw new IOException("unexpected exception", ex);
    }

    public AsyncSocketImpl() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Void access$throwIOException(AsyncSocketImpl $this, Throwable ex) {
        return $this.throwIOException(ex);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "", "connect", "Ljava/nio/channels/AsynchronousSocketChannel;", "addr", "Ljava/net/SocketAddress;", "timeout", "", "doConnect", "ch", "ziti"})
    public static interface Connector {
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress var1, int var2);

        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel var1, @NotNull SocketAddress var2, int var3);

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static AsynchronousSocketChannel doConnect(@NotNull Connector $this, @NotNull AsynchronousSocketChannel ch2, @NotNull SocketAddress addr, int timeout) {
                Intrinsics.checkNotNullParameter((Object)ch2, (String)"ch");
                Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
                try {
                    Future<Void> connOp = ch2.connect(addr);
                    if (timeout > 0) {
                        connOp.get(timeout, TimeUnit.MILLISECONDS);
                    } else {
                        connOp.get();
                    }
                }
                catch (TimeoutException tox) {
                    throw new SocketTimeoutException(tox.getLocalizedMessage());
                }
                catch (ExecutionException xex) {
                    throw new IOException(xex.getCause());
                }
                return ch2;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$DefaultConnector;", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "()V", "connect", "Ljava/nio/channels/AsynchronousSocketChannel;", "addr", "Ljava/net/SocketAddress;", "timeout", "", "ziti"})
    public static final class DefaultConnector
    implements Connector {
        @NotNull
        public static final DefaultConnector INSTANCE = new DefaultConnector();

        private DefaultConnector() {
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress addr, int timeout) {
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            AsynchronousSocketChannel asynchronousSocketChannel = AsynchronousSocketChannel.open();
            Intrinsics.checkNotNullExpressionValue((Object)asynchronousSocketChannel, (String)"open()");
            return this.doConnect(asynchronousSocketChannel, addr, timeout);
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel ch2, @NotNull SocketAddress addr, int timeout) {
            return Connector.DefaultImpls.doConnect(this, ch2, addr, timeout);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$channelConnector;", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "ch", "Ljava/nio/channels/AsynchronousSocketChannel;", "(Ljava/nio/channels/AsynchronousSocketChannel;)V", "getCh", "()Ljava/nio/channels/AsynchronousSocketChannel;", "connect", "addr", "Ljava/net/SocketAddress;", "timeout", "", "ziti"})
    public static final class channelConnector
    implements Connector {
        @NotNull
        private final AsynchronousSocketChannel ch;

        public channelConnector(@NotNull AsynchronousSocketChannel ch2) {
            Intrinsics.checkNotNullParameter((Object)ch2, (String)"ch");
            this.ch = ch2;
        }

        @NotNull
        public final AsynchronousSocketChannel getCh() {
            return this.ch;
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress addr, int timeout) {
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            return this.doConnect(this.ch, addr, timeout);
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel ch2, @NotNull SocketAddress addr, int timeout) {
            return Connector.DefaultImpls.doConnect(this, ch2, addr, timeout);
        }
    }
}

