/*
 * Decompiled with CFR 0.152.
 */
package com.goterl.lazysodium;

import com.goterl.lazysodium.LazySodium;
import com.goterl.lazysodium.SodiumJava;
import com.goterl.lazysodium.exceptions.SodiumException;
import com.goterl.lazysodium.interfaces.MessageEncoder;
import com.goterl.lazysodium.interfaces.Scrypt;
import com.goterl.lazysodium.interfaces.StreamJava;
import com.goterl.lazysodium.utils.Key;
import java.nio.charset.Charset;

public class LazySodiumJava
extends LazySodium
implements Scrypt.Native,
Scrypt.Lazy,
StreamJava.Native,
StreamJava.Lazy {
    private final SodiumJava sodium;

    public LazySodiumJava(SodiumJava sodium) {
        this.sodium = sodium;
    }

    public LazySodiumJava(SodiumJava sodium, Charset charset) {
        super(charset);
        this.sodium = sodium;
    }

    public LazySodiumJava(SodiumJava sodium, MessageEncoder messageEncoder) {
        super(messageEncoder);
        this.sodium = sodium;
    }

    public LazySodiumJava(SodiumJava sodium, Charset charset, MessageEncoder messageEncoder) {
        super(charset, messageEncoder);
        this.sodium = sodium;
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256(byte[] out, long outLen, byte[] password, long passwordLen, byte[] salt, long opsLimit, long memLimit) {
        return this.successful(this.getSodium().crypto_pwhash_scryptsalsa208sha256(out, outLen, password, passwordLen, salt, opsLimit, memLimit));
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256Str(byte[] out, byte[] password, long passwordLen, long opsLimit, long memLimit) {
        return this.successful(this.getSodium().crypto_pwhash_scryptsalsa208sha256_str(out, password, passwordLen, opsLimit, memLimit));
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256StrVerify(byte[] str, byte[] password, long passwordLen) {
        return this.successful(this.getSodium().crypto_pwhash_scryptsalsa208sha256_str_verify(str, password, passwordLen));
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256Ll(byte[] password, int passwordLen, byte[] salt, int saltLen, long N, long r, long p, byte[] buf, int bufLen) {
        return this.successful(this.getSodium().crypto_pwhash_scryptsalsa208sha256_ll(password, passwordLen, salt, saltLen, N, r, p, buf, bufLen));
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256StrNeedsRehash(byte[] hash, long opsLimit, long memLimit) {
        return this.successful(this.getSodium().crypto_pwhash_scryptsalsa208sha256_str_needs_rehash(hash, opsLimit, memLimit));
    }

    @Override
    public String cryptoPwHashScryptSalsa208Sha256(String password, long hashLen, byte[] salt, long opsLimit, long memLimit) throws SodiumException {
        byte[] passwordBytes = this.bytes(password);
        Scrypt.Checker.checkAllScrypt(passwordBytes.length, salt.length, hashLen, opsLimit, memLimit);
        byte[] hash = new byte[LazySodiumJava.longToInt(hashLen).intValue()];
        boolean res = this.cryptoPwHashScryptSalsa208Sha256(hash, hash.length, passwordBytes, passwordBytes.length, salt, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Could not Scrypt hash your password.");
        }
        return this.messageEncoder.encode(hash);
    }

    @Override
    public String cryptoPwHashScryptSalsa208Sha256Str(String password, long opsLimit, long memLimit) throws SodiumException {
        byte[] passwordBytes = this.bytes(password);
        if (!Scrypt.Checker.checkOpsLimitScrypt(opsLimit)) {
            throw new SodiumException("The ops limit provided is not between the correct values.");
        }
        if (!Scrypt.Checker.checkMemLimitScrypt(memLimit)) {
            throw new SodiumException("The mem limit provided is not between the correct values.");
        }
        byte[] hash = new byte[LazySodiumJava.longToInt(102L).intValue()];
        boolean res = this.cryptoPwHashScryptSalsa208Sha256Str(hash, passwordBytes, passwordBytes.length, opsLimit, memLimit);
        if (!res) {
            throw new SodiumException("Could not string Scrypt hash your password.");
        }
        return this.messageEncoder.encode(hash);
    }

    @Override
    public boolean cryptoPwHashScryptSalsa208Sha256StrVerify(String hash, String password) {
        byte[] hashBytes = this.messageEncoder.decode(hash);
        byte[] passwordBytes = this.bytes(password);
        byte endOfHash = hashBytes[hashBytes.length - 1];
        if (endOfHash != 0) {
            byte[] hashWithNullByte = new byte[hashBytes.length + 1];
            System.arraycopy(hashBytes, 0, hashWithNullByte, 0, hashBytes.length);
            hashBytes = hashWithNullByte;
        }
        return this.cryptoPwHashScryptSalsa208Sha256StrVerify(hashBytes, passwordBytes, passwordBytes.length);
    }

    @Override
    public void cryptoStreamSalsa2012Keygen(byte[] key) {
        this.getSodium().crypto_stream_salsa2012_keygen(key);
    }

    @Override
    public boolean cryptoStreamSalsa2012(byte[] c, long cLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_salsa2012(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamSalsa2012Xor(byte[] cipher, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_salsa2012_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public void cryptoStreamSalsa208Keygen(byte[] key) {
        this.getSodium().crypto_stream_salsa208_keygen(key);
    }

    @Override
    public boolean cryptoStreamSalsa208(byte[] c, long cLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_salsa208(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamSalsa208Xor(byte[] cipher, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_salsa208_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public void cryptoStreamXChaCha20Keygen(byte[] key) {
        this.getSodium().crypto_stream_xchacha20_keygen(key);
    }

    @Override
    public boolean cryptoStreamXChaCha20(byte[] c, long cLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_xchacha20(c, cLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamXChaCha20Xor(byte[] cipher, byte[] message, long messageLen, byte[] nonce, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_xchacha20_xor(cipher, message, messageLen, nonce, key));
    }

    @Override
    public boolean cryptoStreamXChaCha20Ic(byte[] cipher, byte[] message, long messageLen, byte[] nonce, long ic, byte[] key) {
        return this.successful(this.getSodium().crypto_stream_xchacha20_xor_ic(cipher, message, messageLen, nonce, ic, key));
    }

    @Override
    public Key cryptoStreamKeygen(StreamJava.Method method2) {
        byte[] k;
        if (method2.equals((Object)StreamJava.Method.SALSA20_8)) {
            k = new byte[32];
            this.getSodium().crypto_stream_salsa208_keygen(k);
        } else if (method2.equals((Object)StreamJava.Method.SALSA20_12)) {
            k = new byte[32];
            this.getSodium().crypto_stream_salsa2012_keygen(k);
        } else {
            k = new byte[32];
            this.getSodium().crypto_stream_xchacha20_keygen(k);
        }
        return Key.fromBytes(k);
    }

    @Override
    public byte[] cryptoStream(byte[] nonce, Key key, StreamJava.Method method2) {
        byte[] c = new byte[20];
        int cLen = c.length;
        if (method2.equals((Object)StreamJava.Method.SALSA20_8)) {
            this.getSodium().crypto_stream_salsa208(c, cLen, nonce, key.getAsBytes());
        } else if (method2.equals((Object)StreamJava.Method.SALSA20_12)) {
            this.getSodium().crypto_stream_salsa2012(c, cLen, nonce, key.getAsBytes());
        } else {
            this.getSodium().crypto_stream_xchacha20(c, cLen, nonce, key.getAsBytes());
        }
        return c;
    }

    @Override
    public String cryptoStreamXor(String message, byte[] nonce, Key key, StreamJava.Method method2) {
        byte[] mBytes = this.bytes(message);
        return this.messageEncoder.encode(this.cryptoStreamDefaultXor(mBytes, nonce, key, method2));
    }

    @Override
    public String cryptoStreamXorDecrypt(String cipher, byte[] nonce, Key key, StreamJava.Method method2) {
        return this.str(this.cryptoStreamDefaultXor(this.messageEncoder.decode(cipher), nonce, key, method2));
    }

    @Override
    public String cryptoStreamXorIc(String message, byte[] nonce, long ic, Key key, StreamJava.Method method2) {
        byte[] mBytes = this.bytes(message);
        return this.messageEncoder.encode(this.cryptoStreamDefaultXorIc(mBytes, nonce, ic, key, method2));
    }

    @Override
    public String cryptoStreamXorIcDecrypt(String cipher, byte[] nonce, long ic, Key key, StreamJava.Method method2) {
        return this.str(this.cryptoStreamDefaultXorIc(this.messageEncoder.decode(cipher), nonce, ic, key, method2));
    }

    private byte[] cryptoStreamDefaultXor(byte[] messageBytes, byte[] nonce, Key key, StreamJava.Method method2) {
        int mLen = messageBytes.length;
        byte[] cipher = new byte[mLen];
        if (method2.equals((Object)StreamJava.Method.SALSA20_8)) {
            this.cryptoStreamSalsa208Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        } else if (method2.equals((Object)StreamJava.Method.SALSA20_12)) {
            this.cryptoStreamSalsa2012Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        } else {
            this.cryptoStreamXChaCha20Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        }
        return cipher;
    }

    private byte[] cryptoStreamDefaultXorIc(byte[] messageBytes, byte[] nonce, long ic, Key key, StreamJava.Method method2) {
        int mLen = messageBytes.length;
        byte[] cipher = new byte[mLen];
        if (method2.equals((Object)StreamJava.Method.SALSA20_8)) {
            this.cryptoStreamSalsa208Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        } else if (method2.equals((Object)StreamJava.Method.SALSA20_12)) {
            this.cryptoStreamSalsa2012Xor(cipher, messageBytes, mLen, nonce, key.getAsBytes());
        } else {
            this.cryptoStreamXChaCha20Ic(cipher, messageBytes, mLen, nonce, ic, key.getAsBytes());
        }
        return cipher;
    }

    @Override
    public SodiumJava getSodium() {
        return this.sodium;
    }
}

