/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.raw;

import java.math.BigInteger;
import org.bouncycastle.util.Pack;

public abstract class Nat576 {
    public static void copy64(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0];
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
        lArray2[3] = lArray[3];
        lArray2[4] = lArray[4];
        lArray2[5] = lArray[5];
        lArray2[6] = lArray[6];
        lArray2[7] = lArray[7];
        lArray2[8] = lArray[8];
    }

    public static void copy64(long[] lArray, int n, long[] lArray2, int n2) {
        lArray2[n2 + 0] = lArray[n + 0];
        lArray2[n2 + 1] = lArray[n + 1];
        lArray2[n2 + 2] = lArray[n + 2];
        lArray2[n2 + 3] = lArray[n + 3];
        lArray2[n2 + 4] = lArray[n + 4];
        lArray2[n2 + 5] = lArray[n + 5];
        lArray2[n2 + 6] = lArray[n + 6];
        lArray2[n2 + 7] = lArray[n + 7];
        lArray2[n2 + 8] = lArray[n + 8];
    }

    public static long[] create64() {
        return new long[9];
    }

    public static long[] createExt64() {
        return new long[18];
    }

    public static boolean eq64(long[] lArray, long[] lArray2) {
        for (int k = 8; k >= 0; --k) {
            if (lArray[k] == lArray2[k]) continue;
            return false;
        }
        return true;
    }

    public static long[] fromBigInteger64(BigInteger bigInteger) {
        if (bigInteger.signum() < 0 || bigInteger.bitLength() > 576) {
            throw new IllegalArgumentException();
        }
        long[] lArray = Nat576.create64();
        for (int k = 0; k < 9; ++k) {
            lArray[k] = bigInteger.longValue();
            bigInteger = bigInteger.shiftRight(64);
        }
        return lArray;
    }

    public static boolean isOne64(long[] lArray) {
        if (lArray[0] != 1L) {
            return false;
        }
        for (int k = 1; k < 9; ++k) {
            if (lArray[k] == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isZero64(long[] lArray) {
        for (int k = 0; k < 9; ++k) {
            if (lArray[k] == 0L) continue;
            return false;
        }
        return true;
    }

    public static BigInteger toBigInteger64(long[] lArray) {
        byte[] byArray = new byte[72];
        for (int k = 0; k < 9; ++k) {
            long l = lArray[k];
            if (l == 0L) continue;
            Pack.longToBigEndian(l, byArray, 8 - k << 3);
        }
        return new BigInteger(1, byArray);
    }
}

