/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.internal.Sockets;
import org.openziti.net.nio.AsyncSocketImpl;
import org.openziti.net.nio.NetUtilsKt;
import org.openziti.util.Logged;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003JKLB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u001a\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u001eH\u0014J\b\u0010#\u001a\u00020$H\u0014J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001eH\u0014J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020\u001eH\u0014J\u0018\u0010%\u001a\u00020$2\u0006\u0010 \u001a\u00020(2\u0006\u0010\"\u001a\u00020\u001eH\u0014J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0014J\u0011\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u0010,\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u0011\u00100\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u0019\u00100\u001a\u00020$2\u0006\u0010-\u001a\u00020(2\u0006\u00101\u001a\u000202H\u0096\u0001J%\u00100\u001a\u00020$2\b\u00103\u001a\u0004\u0018\u0001022\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u001b\u00100\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\n\u00104\u001a\u0004\u0018\u00010!H\u0014J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020\u001eH\u0014J\u0012\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020\u001eH\u0016J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u001eH\u0014J\u0011\u0010>\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u0010>\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u0010\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u00020\u001eH\u0014J\u0010\u0010A\u001a\u00020$2\u0006\u0010B\u001a\u00020\u001eH\u0014J\u001a\u0010C\u001a\u00020$2\u0006\u0010:\u001a\u00020\u001e2\b\u0010D\u001a\u0004\u0018\u000109H\u0016J\b\u0010E\u001a\u00020$H\u0014J\b\u0010F\u001a\u00020$H\u0014J\u0011\u00101\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u00101\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u0010\u0010G\u001a\u00020\u001b2\u0006\u00103\u001a\u000202H\u0002J\u0011\u0010H\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u0010H\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001J\u0011\u0010I\u001a\u00020$2\u0006\u0010-\u001a\u00020(H\u0096\u0001J\u001b\u0010I\u001a\u00020$2\u0010\u0010-\u001a\f\u0012\u0004\u0012\u00020(0.j\u0002`/H\u0096\u0001R\u001a\u0010\t\u001a\u00020\u0004X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006M"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl;", "Ljava/net/SocketImpl;", "Lorg/openziti/util/Logged;", "ch", "Ljava/nio/channels/AsynchronousSocketChannel;", "(Ljava/nio/channels/AsynchronousSocketChannel;)V", "connector", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "(Lorg/openziti/net/nio/AsyncSocketImpl$Connector;)V", "channel", "getChannel$ziti", "()Ljava/nio/channels/AsynchronousSocketChannel;", "setChannel$ziti", "input", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "getInput$ziti", "()Ljava/nio/ByteBuffer;", "inputLock", "Ljava/util/concurrent/Semaphore;", "getInputLock$ziti", "()Ljava/util/concurrent/Semaphore;", "timeout", "Ljava/util/concurrent/atomic/AtomicInteger;", "getTimeout$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "accept", "", "s", "available", "", "bind", "host", "Ljava/net/InetAddress;", "port", "close", "", "connect", "address", "Ljava/net/SocketAddress;", "", "create", "stream", "", "d", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "getInetAddress", "getInputStream", "Ljava/io/InputStream;", "getLocalPort", "getOption", "", "optID", "getOutputStream", "Ljava/io/OutputStream;", "getPort", "i", "listen", "backlog", "sendUrgentData", "data", "setOption", "value", "shutdownInput", "shutdownOutput", "throwIOException", "v", "w", "Connector", "DefaultConnector", "channelConnector", "ziti"})
public final class AsyncSocketImpl
extends SocketImpl
implements Logged {
    @NotNull
    private final Connector connector;
    private final /* synthetic */ ZitiLog $$delegate_0;
    public AsynchronousSocketChannel channel;
    @NotNull
    private final Semaphore inputLock;
    private final ByteBuffer input;
    @NotNull
    private final AtomicInteger timeout;

    /*
     * WARNING - void declaration
     */
    public AsyncSocketImpl(@NotNull Connector connector) {
        void $this$input_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter(connector, "connector");
        this.connector = connector;
        this.$$delegate_0 = new ZitiLog();
        this.inputLock = new Semaphore(1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer byteBuffer2 = byteBuffer;
        AsyncSocketImpl asyncSocketImpl = this;
        boolean bl3 = false;
        if ($this$input_u24lambda_u2d0 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.Buffer");
        }
        ((Buffer)$this$input_u24lambda_u2d0).flip();
        Unit unit = Unit.INSTANCE;
        asyncSocketImpl.input = byteBuffer;
        this.timeout = new AtomicInteger(Sockets.INSTANCE.getDefaultSoTimeout());
    }

    public /* synthetic */ AsyncSocketImpl(Connector connector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            connector = DefaultConnector.INSTANCE;
        }
        this(connector);
    }

    @Override
    public void d(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void d(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.e(ex, msg2);
    }

    @Override
    public void e(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void e(@NotNull String msg2, @NotNull Throwable t2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        Intrinsics.checkNotNullParameter(t2, "t");
        this.$$delegate_0.e(msg2, t2);
    }

    @Override
    public void e(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void i(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void i(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void t(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void t(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void v(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void v(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void w(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.w(msg2);
    }

    @Override
    public void w(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, "msg");
        this.$$delegate_0.w(msg2);
    }

    public AsyncSocketImpl(@NotNull AsynchronousSocketChannel ch) {
        Intrinsics.checkNotNullParameter(ch, "ch");
        this(new channelConnector(ch));
        this.setChannel$ziti(ch);
    }

    @NotNull
    public final AsynchronousSocketChannel getChannel$ziti() {
        AsynchronousSocketChannel asynchronousSocketChannel = this.channel;
        if (asynchronousSocketChannel != null) {
            return asynchronousSocketChannel;
        }
        Intrinsics.throwUninitializedPropertyAccessException("channel");
        return null;
    }

    public final void setChannel$ziti(@NotNull AsynchronousSocketChannel asynchronousSocketChannel) {
        Intrinsics.checkNotNullParameter(asynchronousSocketChannel, "<set-?>");
        this.channel = asynchronousSocketChannel;
    }

    @NotNull
    public final Semaphore getInputLock$ziti() {
        return this.inputLock;
    }

    public final ByteBuffer getInput$ziti() {
        return this.input;
    }

    @NotNull
    public final AtomicInteger getTimeout$ziti() {
        return this.timeout;
    }

    @NotNull
    protected Void bind(@Nullable InetAddress host, int port) {
        String string = "only client sockets are supported";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    protected Void accept(@Nullable SocketImpl s) {
        String string = "only client sockets are supported";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @NotNull
    protected Void listen(int backlog) {
        String string = "only client sockets are supported";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @Nullable
    protected InetAddress getInetAddress() {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.getChannel$ziti().getRemoteAddress();
        return inetSocketAddress == null ? null : inetSocketAddress.getAddress();
    }

    @Override
    protected int getPort() {
        int n;
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.getChannel$ziti().getRemoteAddress();
        return inetSocketAddress == null ? 0 : (n = inetSocketAddress.getPort());
    }

    @Override
    protected int getLocalPort() {
        int n;
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.getChannel$ziti().getLocalAddress();
        return inetSocketAddress == null ? 0 : (n = inetSocketAddress.getPort());
    }

    @Override
    protected void shutdownInput() {
        this.getChannel$ziti().shutdownInput();
    }

    @Override
    protected void shutdownOutput() {
        this.getChannel$ziti().shutdownOutput();
    }

    @Override
    protected void create(boolean stream) {
        boolean bl = false;
        boolean bl2 = false;
        if (!stream) {
            boolean bl3 = false;
            String string = "only stream sockets are supported";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    protected void connect(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter(host, "host");
        this.connect(new InetSocketAddress(host, port), 0);
    }

    @Override
    protected void connect(@NotNull InetAddress address, int port) {
        Intrinsics.checkNotNullParameter(address, "address");
        this.connect(new InetSocketAddress(address, port), 0);
    }

    @Override
    protected void connect(@NotNull SocketAddress address, int timeout) {
        Intrinsics.checkNotNullParameter(address, "address");
        if (this.channel == null) {
            try {
                this.setChannel$ziti(this.connector.connect(address, timeout));
            }
            catch (IOException cex) {
                if (!Intrinsics.areEqual(this.connector, DefaultConnector.INSTANCE)) {
                    this.setChannel$ziti(DefaultConnector.INSTANCE.connect(address, timeout));
                }
                throw cex;
            }
        } else {
            long longTO = timeout > 0 ? (long)timeout : Long.MAX_VALUE;
            BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, address, longTO, null){
                int label;
                final /* synthetic */ AsyncSocketImpl this$0;
                final /* synthetic */ SocketAddress $address;
                final /* synthetic */ long $longTO;
                {
                    this.this$0 = $receiver;
                    this.$address = $address;
                    this.$longTO = $longTO;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = NetUtilsKt.connectSuspend(this.this$0.getChannel$ziti(), this.$address, this.$longTO, this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new InputStream(this){
            final /* synthetic */ AsyncSocketImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public int read() {
                byte[] oneByte = new byte[1];
                int rc = this.read(oneByte, 0, 1);
                if (rc < 0) {
                    return -1;
                }
                return oneByte[0];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int read(@NotNull byte[] b, int off, int len) {
                Intrinsics.checkNotNullParameter(b, "b");
                ByteBuffer byteBuffer = this.this$0.getInput$ziti();
                Intrinsics.checkNotNullExpressionValue(byteBuffer, "input");
                AsyncSocketImpl asyncSocketImpl = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (byteBuffer) {
                    Object result2;
                    Object object;
                    block10: {
                        boolean bl3 = false;
                        asyncSocketImpl.getInputLock$ziti().acquire();
                        int n = asyncSocketImpl.getInput$ziti().remaining();
                        boolean bl4 = false;
                        int count2 = Math.min(len, n);
                        if (count2 <= 0) break block10;
                        asyncSocketImpl.getInput$ziti().get(b, off, count2);
                        asyncSocketImpl.getInputLock$ziti().release();
                        int n2 = count2;
                        return n2;
                    }
                    asyncSocketImpl.getInput$ziti().compact();
                    CompletableFuture<T> rf = new CompletableFuture<T>();
                    Object object2 = asyncSocketImpl.getOption(4102);
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                    }
                    long to = ((Number)object2).longValue();
                    asyncSocketImpl.getChannel$ziti().read(asyncSocketImpl.getInput$ziti(), 0L, TimeUnit.MILLISECONDS, rf, (CompletionHandler)new CompletionHandler<Integer, CompletableFuture<Integer>>(asyncSocketImpl){
                        final /* synthetic */ AsyncSocketImpl this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void completed(int result2, @NotNull CompletableFuture<Integer> f) {
                            Intrinsics.checkNotNullParameter(f, "f");
                            if (!f.isDone()) {
                                f.complete(result2);
                            }
                            this.this$0.getInput$ziti().flip();
                            this.this$0.getInputLock$ziti().release();
                        }

                        public void failed(@NotNull Throwable exc, @NotNull CompletableFuture<Integer> f) {
                            Intrinsics.checkNotNullParameter(exc, "exc");
                            Intrinsics.checkNotNullParameter(f, "f");
                            if (!f.isDone()) {
                                f.completeExceptionally(exc);
                            }
                            this.this$0.getInputLock$ziti().release();
                        }
                    });
                    Object object3 = this;
                    boolean bl5 = false;
                    try {
                        int n;
                        Integer read2;
                        object = Result.Companion;
                        Object $this$read_u24lambda_u2d2_u24lambda_u2d0 = object3;
                        boolean bl6 = false;
                        Integer n3 = read2 = to > 0L ? (Integer)rf.get(to, TimeUnit.MILLISECONDS) : (Integer)rf.get();
                        int n4 = -1;
                        if (n3 != null && n3 == n4) {
                            n = -1;
                        } else {
                            asyncSocketImpl.getInputLock$ziti().acquire();
                            int n5 = asyncSocketImpl.getInput$ziti().remaining();
                            boolean bl7 = false;
                            int count1 = Math.min(len, n5);
                            asyncSocketImpl.getInput$ziti().get(b, off, count1);
                            asyncSocketImpl.getInputLock$ziti().release();
                            n = count1;
                        }
                        $this$read_u24lambda_u2d2_u24lambda_u2d0 = n;
                        bl6 = false;
                        object = Result.constructor-impl($this$read_u24lambda_u2d2_u24lambda_u2d0);
                    }
                    catch (Throwable $this$read_u24lambda_u2d2_u24lambda_u2d0) {
                        Result.Companion bl6 = Result.Companion;
                        boolean bl8 = false;
                        object = Result.constructor-impl(ResultKt.createFailure($this$read_u24lambda_u2d2_u24lambda_u2d0));
                    }
                    object3 = result2 = object;
                    bl5 = false;
                    boolean bl9 = false;
                    Throwable throwable = Result.exceptionOrNull-impl(object3);
                    if (throwable != null) {
                        Throwable ex = throwable;
                        boolean bl10 = false;
                        AsyncSocketImpl.access$throwIOException(asyncSocketImpl, ex);
                        throw new KotlinNothingValueException();
                    }
                    int n = ((Number)object3).intValue();
                    return n;
                }
            }

            public int available() {
                return this.this$0.getInput$ziti().remaining();
            }
        };
    }

    @Override
    protected void close() {
        if (this.channel != null) {
            this.getChannel$ziti().close();
        }
    }

    @Override
    @Nullable
    public Object getOption(int optID) {
        if (optID == 4102) {
            return this.timeout.get();
        }
        if (optID == 4099) {
            return false;
        }
        return null;
    }

    @Override
    public void setOption(int optID, @Nullable Object value) {
        if (optID == 4102) {
            if (value == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
            }
            this.timeout.set(((Number)value).intValue());
        }
        if (optID == 4099) {
            throw new SocketException("SO_OOBINLINE is not supported");
        }
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return new OutputStream(this){
            final /* synthetic */ AsyncSocketImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void write(int b) {
                byte[] byArray = new byte[]{(byte)b};
                this.write(byArray);
            }

            public void write(@NotNull byte[] b, int off, int len) {
                Object object;
                Intrinsics.checkNotNullParameter(b, "b");
                Object object2 = this;
                AsyncSocketImpl asyncSocketImpl = this.this$0;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    getOutputStream.1 $this$write_u24lambda_u2d0 = object2;
                    boolean bl2 = false;
                    Integer n = ((Number)BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Integer>, Object>(asyncSocketImpl, b, off, len, null){
                        int label;
                        final /* synthetic */ AsyncSocketImpl this$0;
                        final /* synthetic */ byte[] $b;
                        final /* synthetic */ int $off;
                        final /* synthetic */ int $len;
                        {
                            this.this$0 = $receiver;
                            this.$b = $b;
                            this.$off = $off;
                            this.$len = $len;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    AsynchronousSocketChannel asynchronousSocketChannel = this.this$0.getChannel$ziti();
                                    ByteBuffer byteBuffer = ByteBuffer.wrap(this.$b, this.$off, this.$len);
                                    Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(b, off, len)");
                                    this.label = 1;
                                    Object object3 = NetUtilsKt.writeCompletely(asynchronousSocketChannel, byteBuffer, this);
                                    if (object3 != object2) return object3;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure($result);
                                    Object object3 = $result;
                                    return object3;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Integer> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null)).intValue();
                    boolean bl3 = false;
                    object = Result.constructor-impl(n);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl4 = false;
                    object = Result.constructor-impl(ResultKt.createFailure(throwable));
                }
                object2 = object;
                asyncSocketImpl = this.this$0;
                bl = false;
                boolean bl5 = false;
                Throwable throwable = Result.exceptionOrNull-impl(object2);
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Throwable throwable3 = throwable2;
                    boolean bl8 = false;
                    Throwable ex = throwable3;
                    boolean bl9 = false;
                    asyncSocketImpl.w(new Function0<String>(ex, b, off, len){
                        final /* synthetic */ Throwable $ex;
                        final /* synthetic */ byte[] $b;
                        final /* synthetic */ int $off;
                        final /* synthetic */ int $len;
                        {
                            this.$ex = $ex;
                            this.$b = $b;
                            this.$off = $off;
                            this.$len = $len;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "unexpected exception[" + this.$ex.getMessage() + "] during write[buf.len=" + this.$b.length + ", off=" + this.$off + ", len=" + this.$len + ']';
                        }
                    });
                    AsyncSocketImpl.access$throwIOException(asyncSocketImpl, ex);
                    throw new KotlinNothingValueException();
                }
            }
        };
    }

    @Override
    protected int available() {
        return this.input.remaining();
    }

    @Override
    protected void sendUrgentData(int data) {
        this.getOutputStream().write(data);
    }

    private final Void throwIOException(Throwable ex) {
        if (ex instanceof IOException) {
            throw ex;
        }
        if (ex instanceof TimeoutException) {
            throw new SocketTimeoutException(ex.getMessage());
        }
        Throwable cause = ex.getCause();
        if (cause instanceof IOException) {
            throw cause;
        }
        throw new IOException("unexpected exception", ex);
    }

    public AsyncSocketImpl() {
        this(null, 1, null);
    }

    public static final /* synthetic */ Void access$throwIOException(AsyncSocketImpl $this, Throwable ex) {
        return $this.throwIOException(ex);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "", "connect", "Ljava/nio/channels/AsynchronousSocketChannel;", "addr", "Ljava/net/SocketAddress;", "timeout", "", "doConnect", "ch", "ziti"})
    public static interface Connector {
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress var1, int var2);

        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel var1, @NotNull SocketAddress var2, int var3);

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public static final class DefaultImpls {
            @NotNull
            public static AsynchronousSocketChannel doConnect(@NotNull Connector this_, @NotNull AsynchronousSocketChannel ch, @NotNull SocketAddress addr, int timeout) {
                Intrinsics.checkNotNullParameter(this_, "this");
                Intrinsics.checkNotNullParameter(ch, "ch");
                Intrinsics.checkNotNullParameter(addr, "addr");
                try {
                    BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(timeout, ch, addr, null){
                        int label;
                        final /* synthetic */ int $timeout;
                        final /* synthetic */ AsynchronousSocketChannel $ch;
                        final /* synthetic */ SocketAddress $addr;
                        {
                            this.$timeout = $timeout;
                            this.$ch = $ch;
                            this.$addr = $addr;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            void $result;
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    if (this.$timeout <= 0) break;
                                    this.label = 1;
                                    Object object3 = NetUtilsKt.connectSuspend(this.$ch, this.$addr, this.$timeout, this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure($result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            this.label = 2;
                            Object object4 = NetUtilsKt.connectSuspend(this.$ch, this.$addr, this);
                            if (object4 != object2) return Unit.INSTANCE;
                            return object2;
                            {
                                case 2: {
                                    ResultKt.throwOnFailure($result);
                                    object4 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
                catch (TimeoutException tox) {
                    throw new SocketTimeoutException(tox.getLocalizedMessage());
                }
                return ch;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$DefaultConnector;", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "()V", "connect", "Ljava/nio/channels/AsynchronousSocketChannel;", "addr", "Ljava/net/SocketAddress;", "timeout", "", "ziti"})
    public static final class DefaultConnector
    implements Connector {
        @NotNull
        public static final DefaultConnector INSTANCE = new DefaultConnector();

        private DefaultConnector() {
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress addr, int timeout) {
            Intrinsics.checkNotNullParameter(addr, "addr");
            AsynchronousSocketChannel asynchronousSocketChannel = AsynchronousSocketChannel.open();
            Intrinsics.checkNotNullExpressionValue(asynchronousSocketChannel, "open()");
            return this.doConnect(asynchronousSocketChannel, addr, timeout);
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel ch, @NotNull SocketAddress addr, int timeout) {
            return Connector.DefaultImpls.doConnect(this, ch, addr, timeout);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/openziti/net/nio/AsyncSocketImpl$channelConnector;", "Lorg/openziti/net/nio/AsyncSocketImpl$Connector;", "ch", "Ljava/nio/channels/AsynchronousSocketChannel;", "(Ljava/nio/channels/AsynchronousSocketChannel;)V", "getCh", "()Ljava/nio/channels/AsynchronousSocketChannel;", "connect", "addr", "Ljava/net/SocketAddress;", "timeout", "", "ziti"})
    public static final class channelConnector
    implements Connector {
        @NotNull
        private final AsynchronousSocketChannel ch;

        public channelConnector(@NotNull AsynchronousSocketChannel ch) {
            Intrinsics.checkNotNullParameter(ch, "ch");
            this.ch = ch;
        }

        @NotNull
        public final AsynchronousSocketChannel getCh() {
            return this.ch;
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel connect(@NotNull SocketAddress addr, int timeout) {
            Intrinsics.checkNotNullParameter(addr, "addr");
            return this.doConnect(this.ch, addr, timeout);
        }

        @Override
        @NotNull
        public AsynchronousSocketChannel doConnect(@NotNull AsynchronousSocketChannel ch, @NotNull SocketAddress addr, int timeout) {
            return Connector.DefaultImpls.doConnect(this, ch, addr, timeout);
        }
    }
}

