/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.identity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.identity.IdentityConfig;
import org.openziti.util.CertsKt;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a8\u0006\u0012"}, d2={"findIdentityAlias", "", "ks", "Ljava/security/KeyStore;", "keystoreFromConfig", "id", "Lorg/openziti/identity/IdentityConfig;", "loadKeystore", "f", "Ljava/io/File;", "pwd", "", "stream", "Ljava/io/InputStream;", "log", "Lorg/openziti/util/ZitiLog;", "i", "", "ziti"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\norg/openziti/identity/UtilKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,127:1\n37#2,2:128\n*S KotlinDebug\n*F\n+ 1 util.kt\norg/openziti/identity/UtilKt\n*L\n52#1:128,2\n*E\n"})
public final class UtilKt {
    @NotNull
    public static final String findIdentityAlias(@NotNull KeyStore ks) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Enumeration<String> enumeration = ks.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"aliases(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            String a = (String)iterator.next();
            if (!ks.isKeyEntry(a)) continue;
            Intrinsics.checkNotNull((Object)a);
            return a;
        }
        throw new IllegalStateException("no suitable key entry".toString());
    }

    @NotNull
    public static final KeyStore keystoreFromConfig(@NotNull IdentityConfig id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(null);
        List<X509Certificate> certs = CertsKt.readCerts(StringsKt.replace$default((String)id.getId().getCert(), (String)"pem:", (String)"", (boolean)false, (int)4, null));
        URI ztAPI = URI.create(id.getZtAPI());
        String name = new X500Name(certs.get(0).getSubjectDN().getName()).getRDNs(BCStyle.CN)[0].getFirst().getValue().toASN1Primitive().toString();
        String alias = "ziti://" + ztAPI.getHost() + ':' + ztAPI.getPort() + '/' + name;
        PrivateKey key = CertsKt.readKey(new StringReader(StringsKt.replace$default((String)id.getId().getKey(), (String)"pem:", (String)"", (boolean)false, (int)4, null)));
        Collection $this$toTypedArray$iv = certs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KeyStore.PrivateKeyEntry keyEntry = new KeyStore.PrivateKeyEntry(key, thisCollection$iv.toArray(new X509Certificate[0]));
        ks.setEntry(alias, keyEntry, new KeyStore.PasswordProtection(new char[0]));
        String string = id.getId().getCa();
        if (string != null) {
            String it = string;
            boolean bl = false;
            List<X509Certificate> cacerts = CertsKt.readCerts(StringsKt.replace$default((String)it, (String)"pem:", (String)"", (boolean)false, (int)4, null));
            for (X509Certificate ca : cacerts) {
                String caAlias = alias + "-ca-" + ca.getSerialNumber();
                ks.setCertificateEntry(caAlias, ca);
            }
        }
        Intrinsics.checkNotNull((Object)ks);
        return ks;
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull byte[] i2) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        ZitiLog log = new ZitiLog();
        try {
            InputStream inputStream = new ByteArrayInputStream(i2);
            Charset charset = Charsets.UTF_8;
            IdentityConfig id = IdentityConfig.Companion.load(new InputStreamReader(inputStream, charset));
            return UtilKt.keystoreFromConfig(id);
        }
        catch (Exception ex) {
            log.w("failed to load identity config: " + ex.getLocalizedMessage());
            throw new IllegalArgumentException("unsupported format");
        }
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull File f2, @NotNull char[] pwd) {
        Intrinsics.checkNotNullParameter((Object)f2, (String)"f");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        ZitiLog log = new ZitiLog();
        if (!f2.exists() || !f2.canRead()) {
            throw new IllegalArgumentException("Failed to parse keystore.  " + f2.getAbsolutePath() + " does not exist or can not be read");
        }
        KeyStore ks = UtilKt.loadKeystore(new FileInputStream(f2), pwd, log);
        if (ks != null) {
            return ks;
        }
        log.t("Trying to load it as a plain identity config");
        try {
            IdentityConfig id = IdentityConfig.Companion.load(f2);
            return UtilKt.keystoreFromConfig(id);
        }
        catch (Exception ex) {
            log.w("failed to load identity config: " + ex.getLocalizedMessage());
            throw new IllegalArgumentException("unsupported format");
        }
    }

    @NotNull
    public static final KeyStore loadKeystore(@NotNull InputStream stream, @NotNull char[] pwd) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        ZitiLog log = new ZitiLog();
        KeyStore ks = UtilKt.loadKeystore(stream, pwd, log);
        if (ks != null) {
            return ks;
        }
        throw new IllegalArgumentException("unsupported format");
    }

    @Nullable
    public static final KeyStore loadKeystore(@NotNull InputStream stream, @NotNull char[] pwd, @NotNull ZitiLog log) {
        KeyStore keyStore;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        try {
            ks.load(stream, pwd);
            keyStore = ks;
        }
        catch (Exception ex) {
            log.t("Failed to parse identity file as a keystore: " + ex.getLocalizedMessage());
            keyStore = null;
        }
        return keyStore;
    }
}

