/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.dns;

import java.io.Writer;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.dns.DNSResolver;
import org.openziti.util.IPUtil;
import org.openziti.util.Logged;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u001a\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002<=B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0096\u0001J\u001b\u0010\u001a\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\n0\u001dj\u0002`\u001eH\u0096\u0001J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\u0011\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0096\u0001J\u0019\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0096\u0001J%\u0010\"\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010$2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\n0\u001dj\u0002`\u001eH\u0096\u0001J\u001b\u0010\"\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\n0\u001dj\u0002`\u001eH\u0096\u0001J\u0011\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0096\u0001J\u001b\u0010&\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\n0\u001dj\u0002`\u001eH\u0096\u0001J\u0012\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020\u0012H\u0016J\u001c\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\n2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u000bH\u0002J\u0015\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b1J\r\u00102\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b3J\u0012\u00104\u001a\u0004\u0018\u00010\u00122\u0006\u00100\u001a\u00020\nH\u0016J\u0012\u00105\u001a\u0004\u0018\u00010\u00122\u0006\u00100\u001a\u00020\nH\u0002J\u0011\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0096\u0001J\u001b\u0010#\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\n0\u001dj\u0002`\u001eH\u0096\u0001J\u0015\u00106\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b9J\u0011\u0010:\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0096\u0001J\u001b\u0010:\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\n0\u001dj\u0002`\u001eH\u0096\u0001J\u0011\u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nH\u0096\u0001J\u001b\u0010;\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\n0\u001dj\u0002`\u001eH\u0096\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager;", "Lorg/openziti/net/dns/DNSResolver;", "Lorg/openziti/util/Logged;", "()V", "PREFIX", "", "getPREFIX$ziti", "()[B", "domains", "", "", "Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "getDomains$ziti", "()Ljava/util/Map;", "host2Ip", "Lorg/openziti/net/dns/ZitiDNSManager$Entry;", "getHost2Ip$ziti", "ip2host", "Ljava/net/InetAddress;", "getIp2host$ziti", "postfix", "Ljava/util/concurrent/atomic/AtomicInteger;", "getPostfix$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "startPostfix", "", "d", "", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "dump", "writer", "Ljava/io/Writer;", "e", "t", "", "ex", "i", "lookup", "addr", "nextAddr", "dnsname", "domain", "registerDomain", "domainName", "registerDomain$ziti", "registerHostname", "hostname", "registerHostname$ziti", "reset", "reset$ziti", "resolve", "resolveOrAssign", "unregisterDomain", "unregisterDomain$ziti", "unregisterHostname", "unregisterHostname$ziti", "v", "w", "Domain", "Entry", "ziti"})
@SourceDebugExtension(value={"SMAP\nZitiDNSManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZitiDNSManager.kt\norg/openziti/net/dns/ZitiDNSManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n372#2,7:161\n766#3:168\n857#3,2:169\n1855#3,2:171\n1#4:173\n*S KotlinDebug\n*F\n+ 1 ZitiDNSManager.kt\norg/openziti/net/dns/ZitiDNSManager\n*L\n55#1:161,7\n98#1:168\n98#1:169,2\n99#1:171,2\n*E\n"})
public final class ZitiDNSManager
implements DNSResolver,
Logged {
    @NotNull
    public static final ZitiDNSManager INSTANCE = new ZitiDNSManager();
    private final /* synthetic */ ZitiLog $$delegate_0;
    @NotNull
    private static final byte[] PREFIX;
    public static final int startPostfix = 257;
    @NotNull
    private static final AtomicInteger postfix;
    @NotNull
    private static final Map<String, Entry> host2Ip;
    @NotNull
    private static final Map<InetAddress, Entry> ip2host;
    @NotNull
    private static final Map<String, Domain> domains;

    private ZitiDNSManager() {
        this.$$delegate_0 = new ZitiLog();
    }

    @Override
    public void d(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void d(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void e(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void e(@NotNull String msg2, @NotNull Throwable t2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        this.$$delegate_0.e(msg2, t2);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.e(ex, msg2);
    }

    @Override
    public void e(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void i(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void i(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void t(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void t(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void v(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void v(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void w(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.w(msg2);
    }

    @Override
    public void w(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.w(msg2);
    }

    @NotNull
    public final byte[] getPREFIX$ziti() {
        return PREFIX;
    }

    @NotNull
    public final AtomicInteger getPostfix$ziti() {
        return postfix;
    }

    @NotNull
    public final Map<String, Entry> getHost2Ip$ziti() {
        return host2Ip;
    }

    @NotNull
    public final Map<InetAddress, Entry> getIp2host$ziti() {
        return ip2host;
    }

    @NotNull
    public final Map<String, Domain> getDomains$ziti() {
        return domains;
    }

    @NotNull
    public final InetAddress registerHostname$ziti(@NotNull String hostname) {
        InetAddress inetAddress;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (IPUtil.isValidIPv4(hostname)) {
            inetAddress = Inet4Address.getByName(hostname);
        } else if (IPUtil.isValidIPv6(hostname)) {
            inetAddress = Inet6Address.getByName(hostname);
        } else {
            Entry entry;
            String string = hostname.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String dnsName = string;
            Map<String, Entry> $this$getOrPut$iv = host2Ip;
            boolean $i$f$getOrPut = false;
            Entry value$iv = $this$getOrPut$iv.get(dnsName);
            if (value$iv == null) {
                boolean bl = false;
                Entry e2 = ZitiDNSManager.nextAddr$default(INSTANCE, dnsName, null, 2, null);
                ip2host.put(e2.getAddr(), e2);
                Entry answer$iv = e2;
                $this$getOrPut$iv.put(dnsName, answer$iv);
                entry = answer$iv;
            } else {
                entry = value$iv;
            }
            Entry entry2 = entry;
            this.i((Function0<String>)((Function0)new Function0<String>(hostname, entry2){
                final /* synthetic */ String $hostname;
                final /* synthetic */ Entry $entry;
                {
                    this.$hostname = $hostname;
                    this.$entry = $entry;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "registered: " + this.$hostname + " => " + this.$entry;
                }
            }));
            inetAddress = entry2.getAddr();
        }
        InetAddress ip2 = inetAddress;
        Intrinsics.checkNotNull((Object)ip2);
        return ip2;
    }

    public final void unregisterHostname$ziti(@NotNull String hostname) {
        block0: {
            Entry e2;
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            String string = hostname.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            Entry entry = e2 = host2Ip.remove(string);
            if (entry == null) break block0;
            Entry it = entry;
            boolean bl = false;
            INSTANCE.i((Function0<String>)((Function0)new Function0<String>(it){
                final /* synthetic */ Entry $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "removed entry=" + this.$it;
                }
            }));
            ip2host.remove(e2.getAddr());
        }
    }

    public final void registerDomain$ziti(@NotNull String domainName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        if (StringsKt.startsWith$default((String)domainName, (String)"*.", (boolean)false, (int)2, null)) {
            String string2 = domainName.substring(2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)domainName, (String)".", (boolean)false, (int)2, null)) {
            String string3 = domainName.substring(1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = domainName;
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String key = string4;
        Domain domain = new Domain("*." + key);
        if (domains.putIfAbsent(key, domain) == null) {
            this.i((Function0<String>)((Function0)new Function0<String>(domain){
                final /* synthetic */ Domain $domain;
                {
                    this.$domain = $domain;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "registered " + this.$domain;
                }
            }));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unregisterDomain$ziti(@NotNull String domainName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        if (StringsKt.startsWith$default((String)domainName, (String)"*.", (boolean)false, (int)2, null)) {
            String string2 = domainName.substring(2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else if (StringsKt.startsWith$default((String)domainName, (String)".", (boolean)false, (int)2, null)) {
            String string3 = domainName.substring(1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = domainName;
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String key = string4;
        Domain domain = domains.remove(key);
        if (domain != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = host2Ip.values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entry it = (Entry)element$iv$iv;
                boolean bl = false;
                if (!(it.getDomain() == domain)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List entries = (List)destination$iv$iv;
            Iterable $this$forEach$iv = entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry it = (Entry)element$iv;
                boolean bl = false;
                INSTANCE.unregisterHostname$ziti(it.getName());
            }
            this.i((Function0<String>)((Function0)new Function0<String>(domain){
                final /* synthetic */ Domain $domain;
                {
                    this.$domain = $domain;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "domain[" + this.$domain.getName() + "] removed";
                }
            }));
        }
    }

    @Override
    @Nullable
    public InetAddress resolve(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String string = hostname.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return this.resolveOrAssign(string);
    }

    private final InetAddress resolveOrAssign(String hostname) {
        String string = hostname.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String name = string;
        Object object = host2Ip.get(name);
        if (object != null) {
            Entry it = object;
            boolean bl = false;
            return it.getAddr();
        }
        do {
            if ((object = domains.get(name)) == null) continue;
            Object it = object;
            boolean bl = false;
            Entry entry = INSTANCE.nextAddr(hostname, (Domain)it);
            ip2host.put(entry.getAddr(), entry);
            host2Ip.put(hostname, entry);
            return entry.getAddr();
        } while (((CharSequence)(name = StringsKt.substringAfter((String)name, (char)'.', (String)""))).length() > 0);
        return null;
    }

    @Override
    @Nullable
    public String lookup(@NotNull InetAddress addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        Entry entry = ip2host.get(addr);
        return entry != null ? entry.getName() : null;
    }

    private final Entry nextAddr(String dnsname, Domain domain) {
        int nextPostfix = postfix.incrementAndGet();
        if ((nextPostfix & 0xFF) == 0) {
            nextPostfix = postfix.incrementAndGet();
        }
        byte[] byArray = new byte[]{(byte)(nextPostfix >> 8 & 0xFF), (byte)(nextPostfix & 0xFF)};
        byte[] ip2 = ArraysKt.plus((byte[])PREFIX, (byte[])byArray);
        InetAddress addr = InetAddress.getByAddress(dnsname, ip2);
        this.i((Function0<String>)((Function0)new Function0<String>(dnsname, addr, domain){
            final /* synthetic */ String $dnsname;
            final /* synthetic */ InetAddress $addr;
            final /* synthetic */ Domain $domain;
            {
                this.$dnsname = $dnsname;
                this.$addr = $addr;
                this.$domain = $domain;
                super(0);
            }

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder().append("assigned ").append(this.$dnsname).append(" => ").append(this.$addr).append(" [");
                Object object = this.$domain;
                if (object == null || (object = ((Domain)object).getName()) == null) {
                    object = "";
                }
                return stringBuilder.append((String)object).append(']').toString();
            }
        }));
        Intrinsics.checkNotNull((Object)addr);
        return new Entry(dnsname, addr, domain);
    }

    static /* synthetic */ Entry nextAddr$default(ZitiDNSManager zitiDNSManager, String string, Domain domain, int n, Object object) {
        if ((n & 2) != 0) {
            domain = null;
        }
        return zitiDNSManager.nextAddr(string, domain);
    }

    public final void reset$ziti() {
        host2Ip.clear();
        ip2host.clear();
        postfix.set(257);
    }

    @Override
    public void dump(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        for (Map.Entry<String, Entry> entry : host2Ip.entrySet()) {
            String h = entry.getKey();
            Entry ip2 = entry.getValue();
            Appendable appendable = ((Appendable)writer).append(h + " -> " + ip2);
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)writer).append('\n'), (String)"append('\\n')");
        Appendable appendable = ((Appendable)writer).append("== Wildcard Domains ==");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
        domains.forEach((arg_0, arg_1) -> ZitiDNSManager.dump$lambda$6((Function2)new Function2<String, Domain, Unit>(writer){
            final /* synthetic */ Writer $writer;
            {
                this.$writer = $writer;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull Domain domain) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
                Appendable appendable = ((Appendable)this.$writer).append(domain.getName());
                Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
            }
        }, arg_0, arg_1));
    }

    private static final void dump$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    static {
        byte[] byArray = new byte[]{100, 64};
        PREFIX = byArray;
        postfix = new AtomicInteger(257);
        host2Ip = new LinkedHashMap();
        ip2host = new LinkedHashMap();
        domains = new LinkedHashMap();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "ziti"})
    public static final class Domain {
        @NotNull
        private final String name;

        public Domain(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Domain copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Domain(name);
        }

        public static /* synthetic */ Domain copy$default(Domain domain, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = domain.name;
            }
            return domain.copy(string);
        }

        @NotNull
        public String toString() {
            return "Domain(name=" + this.name + ')';
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Domain)) {
                return false;
            }
            Domain domain = (Domain)other;
            return Intrinsics.areEqual((Object)this.name, (Object)domain.name);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager$Entry;", "", "name", "", "addr", "Ljava/net/InetAddress;", "domain", "Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "(Ljava/lang/String;Ljava/net/InetAddress;Lorg/openziti/net/dns/ZitiDNSManager$Domain;)V", "getAddr", "()Ljava/net/InetAddress;", "getDomain", "()Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "getName", "()Ljava/lang/String;", "repr", "getRepr", "repr$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "ziti"})
    public static final class Entry {
        @NotNull
        private final String name;
        @NotNull
        private final InetAddress addr;
        @Nullable
        private final Domain domain;
        @NotNull
        private final Lazy repr$delegate;

        public Entry(@NotNull String name, @NotNull InetAddress addr, @Nullable Domain domain) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            this.name = name;
            this.addr = addr;
            this.domain = domain;
            this.repr$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Entry this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    Object object;
                    block3: {
                        block2: {
                            object = this.this$0.getDomain();
                            if (object == null) break block2;
                            Domain domain = object;
                            Entry entry = this.this$0;
                            Domain it = domain;
                            boolean bl = false;
                            String string = entry.getAddr() + " [" + it.getName() + ']';
                            object = string;
                            if (string != null) break block3;
                        }
                        String string = this.this$0.getAddr().toString();
                        object = string;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    }
                    return object;
                }
            }));
        }

        public /* synthetic */ Entry(String string, InetAddress inetAddress, Domain domain, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                domain = null;
            }
            this(string, inetAddress, domain);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final InetAddress getAddr() {
            return this.addr;
        }

        @Nullable
        public final Domain getDomain() {
            return this.domain;
        }

        private final String getRepr() {
            Lazy lazy = this.repr$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public String toString() {
            return this.getRepr();
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final InetAddress component2() {
            return this.addr;
        }

        @Nullable
        public final Domain component3() {
            return this.domain;
        }

        @NotNull
        public final Entry copy(@NotNull String name, @NotNull InetAddress addr, @Nullable Domain domain) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            return new Entry(name, addr, domain);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, String string, InetAddress inetAddress, Domain domain, int n, Object object) {
            if ((n & 1) != 0) {
                string = entry.name;
            }
            if ((n & 2) != 0) {
                inetAddress = entry.addr;
            }
            if ((n & 4) != 0) {
                domain = entry.domain;
            }
            return entry.copy(string, inetAddress, domain);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.addr.hashCode();
            result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)entry.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.addr, (Object)entry.addr)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.domain, (Object)entry.domain);
        }
    }
}

