/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.api;

import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.api.InterceptAddress;
import org.openziti.util.IPUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/openziti/api/CIDRBlock;", "Lorg/openziti/api/InterceptAddress;", "ip", "Ljava/net/InetAddress;", "bits", "", "(Ljava/net/InetAddress;I)V", "getBits", "()I", "cidrAddress", "getCidrAddress", "()Ljava/net/InetAddress;", "getIp", "mask", "", "getMask", "()[B", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "includes", "matches", "addr", "toString", "", "ziti"})
public final class CIDRBlock
extends InterceptAddress {
    @NotNull
    private final InetAddress ip;
    private final int bits;
    @NotNull
    private final InetAddress cidrAddress;
    @NotNull
    private final byte[] mask;

    public CIDRBlock(@NotNull InetAddress ip2, int bits) {
        Intrinsics.checkNotNullParameter((Object)ip2, (String)"ip");
        super(null);
        this.ip = ip2;
        this.bits = bits;
        this.cidrAddress = IPUtil.toCanonicalCIDR(this.ip, this.bits);
        this.mask = IPUtil.maskForPrefix(this.ip.getAddress().length, this.bits);
    }

    @NotNull
    public final InetAddress getIp() {
        return this.ip;
    }

    public final int getBits() {
        return this.bits;
    }

    @NotNull
    public final InetAddress getCidrAddress() {
        return this.cidrAddress;
    }

    @NotNull
    public final byte[] getMask() {
        return this.mask;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(@NotNull Object addr) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        if (addr instanceof InetAddress) {
            byArray = ((InetAddress)addr).getAddress();
        } else {
            if (!(addr instanceof String)) return false;
            if (!IPUtil.isValidIPv4((String)addr)) return false;
            byArray = IPUtil.toIPv4((String)addr);
        }
        byte[] addrBytes = byArray;
        if (addrBytes.length != this.mask.length) {
            return false;
        }
        int n = this.mask.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if ((this.mask[i2] & addrBytes[i2]) == this.cidrAddress.getAddress()[i2]) continue;
            return false;
        }
        return true;
    }

    public final boolean includes(@NotNull CIDRBlock other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.bits <= other.bits && this.matches(other.ip);
    }

    @NotNull
    public final InetAddress component1() {
        return this.ip;
    }

    public final int component2() {
        return this.bits;
    }

    @NotNull
    public final CIDRBlock copy(@NotNull InetAddress ip2, int bits) {
        Intrinsics.checkNotNullParameter((Object)ip2, (String)"ip");
        return new CIDRBlock(ip2, bits);
    }

    public static /* synthetic */ CIDRBlock copy$default(CIDRBlock cIDRBlock, InetAddress inetAddress, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            inetAddress = cIDRBlock.ip;
        }
        if ((n2 & 2) != 0) {
            n = cIDRBlock.bits;
        }
        return cIDRBlock.copy(inetAddress, n);
    }

    @NotNull
    public String toString() {
        return "CIDRBlock(ip=" + this.ip + ", bits=" + this.bits + ")";
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = result * 31 + Integer.hashCode(this.bits);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CIDRBlock)) {
            return false;
        }
        CIDRBlock cIDRBlock = (CIDRBlock)other;
        if (!Intrinsics.areEqual((Object)this.ip, (Object)cIDRBlock.ip)) {
            return false;
        }
        return this.bits == cIDRBlock.bits;
    }
}

