/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.identity;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.Collection;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.identity.ZitiJWT;
import org.openziti.util.CertsKt;
import org.openziti.util.Logged;
import org.openziti.util.PrivateKeySigner;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 02\u00020\u0001:\u000201B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0096\u0001J\u001b\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00070\u0017j\u0002`\u0018H\u0096\u0001J\u0011\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0096\u0001J\u0019\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0096\u0001J%\u0010\u0019\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00070\u0017j\u0002`\u0018H\u0096\u0001J\u001b\u0010\u0019\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00070\u0017j\u0002`\u0018H\u0096\u0001J \u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0002J0\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020$2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020)2\b\u0010,\u001a\u0004\u0018\u00010\u001fJ\u0011\u0010-\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0096\u0001J\u001b\u0010-\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00070\u0017j\u0002`\u0018H\u0096\u0001J\u0011\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0096\u0001J\u001b\u0010\u001a\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00070\u0017j\u0002`\u0018H\u0096\u0001J\u0011\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0096\u0001J\u001b\u0010.\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00070\u0017j\u0002`\u0018H\u0096\u0001J\u0011\u0010/\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0096\u0001J\u001b\u0010/\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\u00070\u0017j\u0002`\u0018H\u0096\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00062"}, d2={"Lorg/openziti/identity/Enroller;", "Lorg/openziti/util/Logged;", "enrollmentURL", "Ljava/net/URL;", "method", "Lorg/openziti/identity/Enroller$Method;", "name", "", "caCerts", "", "Ljava/security/cert/X509Certificate;", "(Ljava/net/URL;Lorg/openziti/identity/Enroller$Method;Ljava/lang/String;Ljava/util/Collection;)V", "getCaCerts", "()Ljava/util/Collection;", "getEnrollmentURL", "()Ljava/net/URL;", "getMethod", "()Lorg/openziti/identity/Enroller$Method;", "getName", "()Ljava/lang/String;", "d", "", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "enroll", "cert", "Ljava/security/KeyStore$Entry;", "keyStore", "Ljava/security/KeyStore;", "n", "enrollOtt", "Ljava/security/KeyStore$PrivateKeyEntry;", "alias", "conn", "Ljavax/net/ssl/HttpsURLConnection;", "ssl", "Ljavax/net/ssl/SSLContext;", "enrollOttca", "getSSLContext", "clientCert", "i", "v", "w", "Companion", "Method", "ziti"})
@SourceDebugExtension(value={"SMAP\nEnroller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Enroller.kt\norg/openziti/identity/Enroller\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n37#2,2:218\n37#2,2:220\n1#3:222\n1855#4,2:223\n*S KotlinDebug\n*F\n+ 1 Enroller.kt\norg/openziti/identity/Enroller\n*L\n176#1:218,2\n180#1:220,2\n200#1:223,2\n*E\n"})
public final class Enroller
implements Logged {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL enrollmentURL;
    @NotNull
    private final Method method;
    @NotNull
    private final String name;
    @NotNull
    private final Collection<X509Certificate> caCerts;
    private final /* synthetic */ ZitiLog $$delegate_0;
    @NotNull
    private static final ECGenParameterSpec P256 = new ECGenParameterSpec("secp256r1");

    public Enroller(@NotNull URL enrollmentURL, @NotNull Method method2, @NotNull String name, @NotNull Collection<? extends X509Certificate> caCerts) {
        Intrinsics.checkNotNullParameter((Object)enrollmentURL, (String)"enrollmentURL");
        Intrinsics.checkNotNullParameter((Object)((Object)method2), (String)"method");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(caCerts, (String)"caCerts");
        this.enrollmentURL = enrollmentURL;
        this.method = method2;
        this.name = name;
        this.caCerts = caCerts;
        this.$$delegate_0 = new ZitiLog("ziti-enroler", null, 2, null);
    }

    @NotNull
    public final URL getEnrollmentURL() {
        return this.enrollmentURL;
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Collection<X509Certificate> getCaCerts() {
        return this.caCerts;
    }

    @Override
    public void d(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void d(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.d(msg2);
    }

    @Override
    public void e(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void e(@NotNull String msg2, @NotNull Throwable t2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        this.$$delegate_0.e(msg2, t2);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.e(ex, msg2);
    }

    @Override
    public void e(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.e(msg2);
    }

    @Override
    public void i(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void i(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.i(msg2);
    }

    @Override
    public void t(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void t(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.t(msg2);
    }

    @Override
    public void v(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void v(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.v(msg2);
    }

    @Override
    public void w(@NotNull String msg2) {
        Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
        this.$$delegate_0.w(msg2);
    }

    @Override
    public void w(@NotNull Function0<String> msg2) {
        Intrinsics.checkNotNullParameter(msg2, (String)"msg");
        this.$$delegate_0.w(msg2);
    }

    @NotNull
    public final String enroll(@Nullable KeyStore.Entry cert, @NotNull KeyStore keyStore, @NotNull String n) {
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        URLConnection uRLConnection = this.enrollmentURL.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection conn = (HttpsURLConnection)uRLConnection;
        SSLContext ssl = this.getSSLContext(cert);
        KeyStore.PrivateKeyEntry pke = switch (WhenMappings.$EnumSwitchMapping$0[this.method.ordinal()]) {
            case 1 -> this.enrollOtt(n, conn, keyStore, ssl);
            case 2 -> {
                if (!(cert instanceof KeyStore.PrivateKeyEntry)) {
                    throw new Exception("client certificate is required for ottca enrollment");
                }
                yield this.enrollOttca(n, conn, (KeyStore.PrivateKeyEntry)cert, keyStore, ssl);
            }
            default -> throw new UnsupportedOperationException("method " + this.method + " is not supported");
        };
        String alias = "ziti://" + this.enrollmentURL.getHost() + ":" + this.enrollmentURL.getPort() + "/" + URLEncoder.encode(this.name, Charsets.UTF_8.name());
        KeyStore.PasswordProtection protect = StringsKt.equals((String)keyStore.getType(), (String)"pkcs12", (boolean)true) ? new KeyStore.PasswordProtection(new char[0]) : null;
        keyStore.setEntry(alias, pke, protect);
        for (X509Certificate ca : this.caCerts) {
            String caAlias = "ziti:" + this.name + "/" + ca.getSerialNumber();
            keyStore.setCertificateEntry(caAlias, ca);
        }
        return alias;
    }

    private final KeyStore.PrivateKeyEntry enrollOttca(String alias, HttpsURLConnection conn, KeyStore.PrivateKeyEntry cert, KeyStore keyStore, SSLContext ssl) {
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setRequestProperty("Content-Length", "0");
        conn.setSSLSocketFactory(ssl.getSocketFactory());
        conn.getOutputStream().write(new byte[0]);
        conn.getOutputStream().flush();
        int rc = conn.getResponseCode();
        if (rc >= 400) {
            Gson gson = new Gson();
            InputStream inputStream = conn.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            JsonObject json = (JsonObject)gson.fromJson((Reader)new InputStreamReader(inputStream2, charset), JsonObject.class);
            JsonArray errors = json.getAsJsonArray("errors");
            for (JsonElement e2 : errors) {
                JsonElement jsonElement = e2.getAsJsonObject().get("msg");
                if (jsonElement == null) continue;
                JsonElement it = jsonElement;
                boolean bl = false;
                throw new IllegalArgumentException(it.toString());
            }
            throw new IllegalArgumentException(errors.getAsString());
        }
        return cert;
    }

    private final KeyStore.PrivateKeyEntry enrollOtt(String alias, HttpsURLConnection conn, KeyStore keyStore, SSLContext ssl) {
        X509Certificate[] x509CertificateArray;
        String ct;
        X500Name name = new X500Name("CN=" + this.name);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
        kpg.initialize(P256);
        KeyPair kp = kpg.generateKeyPair();
        JcaPKCS10CertificationRequestBuilder csrBuildr = new JcaPKCS10CertificationRequestBuilder(name, kp.getPublic());
        PrivateKey privateKey = kp.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
        PKCS10CertificationRequest csr = csrBuildr.build((ContentSigner)new PrivateKeySigner(privateKey, "SHA256withECDSA"));
        PemObject csrPem = new PemObject("CERTIFICATE REQUEST", csr.getEncoded());
        ByteArrayOutputStream pem = new ByteArrayOutputStream();
        PemWriter w2 = new PemWriter((Writer)new OutputStreamWriter(pem));
        w2.writeObject((PemObjectGenerator)csrPem);
        w2.flush();
        byte[] pemBytes = pem.toByteArray();
        conn.setSSLSocketFactory(ssl.getSocketFactory());
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("Content-Type", "text/plain");
        conn.setRequestProperty("Content-Length", String.valueOf(pemBytes.length));
        conn.getOutputStream().write(pemBytes);
        conn.getOutputStream().flush();
        if (conn.getResponseCode() >= 400) {
            Gson gson = new Gson();
            InputStream inputStream = conn.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            JsonObject error = ((JsonObject)gson.fromJson((Reader)new InputStreamReader(inputStream2, charset), JsonObject.class)).getAsJsonObject("error");
            Object object = error.get("message");
            if (object == null || (object = object.toString()) == null) {
                object = "unknown error";
            }
            throw new IllegalArgumentException((String)object);
        }
        String string = conn.getHeaderField("Content-Type");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHeaderField(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = ct = string2;
        if (Intrinsics.areEqual((Object)string3, (Object)"application/x-pem-file")) {
            InputStream inputStream = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream3 = inputStream;
            Charset charset = Charsets.UTF_8;
            Collection $this$toTypedArray$iv = CertsKt.readCerts(new InputStreamReader(inputStream3, charset));
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
        } else if (Intrinsics.areEqual((Object)string3, (Object)"application/json")) {
            Gson gson = new Gson();
            InputStream inputStream = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream $i$f$toTypedArray = inputStream;
            Charset thisCollection$iv = Charsets.UTF_8;
            JsonObject data2 = ((JsonObject)gson.fromJson((Reader)new InputStreamReader($i$f$toTypedArray, thisCollection$iv), JsonObject.class)).getAsJsonObject("data");
            String string4 = data2.getAsJsonPrimitive("cert").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAsString(...)");
            Collection $this$toTypedArray$iv = CertsKt.readCerts(string4);
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv;
            x509CertificateArray = thisCollection$iv2.toArray(new X509Certificate[0]);
        } else {
            throw new IllegalStateException(("Invalid content-type: " + ct).toString());
        }
        X509Certificate[] certs = x509CertificateArray;
        return new KeyStore.PrivateKeyEntry(kp.getPrivate(), certs);
    }

    @NotNull
    public final SSLContext getSSLContext(@Nullable KeyStore.Entry clientCert) {
        SSLContext sSLContext;
        Object it;
        KeyStore keyStore;
        KeyStore $this$getSSLContext_u24lambda_u241 = keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        boolean bl = false;
        $this$getSSLContext_u24lambda_u241.load(null);
        KeyStore ks = keyStore;
        KeyStore.Entry entry = clientCert;
        if (entry != null) {
            it = entry;
            boolean bl2 = false;
            ks.setEntry("client-cert", clientCert, null);
        }
        Object $this$getSSLContext_u24lambda_u243 = it = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        boolean bl3 = false;
        ((KeyManagerFactory)$this$getSSLContext_u24lambda_u243).init(ks, new char[0]);
        Object kmf = it;
        TrustManager[] tms = null;
        if (!this.caCerts.isEmpty()) {
            TrustManagerFactory trustManagerFactory;
            Iterable $this$forEach$iv = this.caCerts;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                X509Certificate it2 = (X509Certificate)element$iv;
                boolean bl4 = false;
                ks.setCertificateEntry("ca-" + it2.getSerialNumber(), it2);
            }
            TrustManagerFactory $this$getSSLContext_u24lambda_u245 = trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            boolean bl5 = false;
            $this$getSSLContext_u24lambda_u245.init(ks);
            TrustManagerFactory tmf = trustManagerFactory;
            tms = tmf.getTrustManagers();
        }
        SSLContext $this$getSSLContext_u24lambda_u246 = sSLContext = SSLContext.getInstance("TLSv1.2");
        boolean bl6 = false;
        $this$getSSLContext_u24lambda_u246.init(((KeyManagerFactory)kmf).getKeyManagers(), tms, new SecureRandom());
        SSLContext sc = sSLContext;
        Intrinsics.checkNotNull((Object)sc);
        return sc;
    }

    @JvmStatic
    @NotNull
    public static final Enroller fromJWT(@NotNull String jwt) {
        return Companion.fromJWT(jwt);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u001b\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\n0\u000bj\u0002`\fH\u0096\u0001J\u0011\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u0019\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0001J%\u0010\r\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\n0\u000bj\u0002`\fH\u0096\u0001J\u001b\u0010\r\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\n0\u000bj\u0002`\fH\u0096\u0001J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0007J\u0011\u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u001b\u0010\u0014\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\n0\u000bj\u0002`\fH\u0096\u0001J\u0011\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u001b\u0010\u000e\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\n0\u000bj\u0002`\fH\u0096\u0001J\u0011\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u001b\u0010\u0015\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\n0\u000bj\u0002`\fH\u0096\u0001J\u0011\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0001J\u001b\u0010\u0016\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\n0\u000bj\u0002`\fH\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/openziti/identity/Enroller$Companion;", "Lorg/openziti/util/Logged;", "()V", "P256", "Ljava/security/spec/ECGenParameterSpec;", "getP256", "()Ljava/security/spec/ECGenParameterSpec;", "d", "", "msg", "", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "fromJWT", "Lorg/openziti/identity/Enroller;", "jwt", "i", "v", "w", "ziti"})
    public static final class Companion
    implements Logged {
        private final /* synthetic */ ZitiLog $$delegate_0;

        private Companion() {
            this.$$delegate_0 = new ZitiLog("ziti-enroller", null, 2, null);
        }

        @Override
        public void d(@NotNull String msg2) {
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            this.$$delegate_0.d(msg2);
        }

        @Override
        public void d(@NotNull Function0<String> msg2) {
            Intrinsics.checkNotNullParameter(msg2, (String)"msg");
            this.$$delegate_0.d(msg2);
        }

        @Override
        public void e(@NotNull String msg2) {
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            this.$$delegate_0.e(msg2);
        }

        @Override
        public void e(@NotNull String msg2, @NotNull Throwable t2) {
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
            this.$$delegate_0.e(msg2, t2);
        }

        @Override
        public void e(@Nullable Throwable ex, @NotNull Function0<String> msg2) {
            Intrinsics.checkNotNullParameter(msg2, (String)"msg");
            this.$$delegate_0.e(ex, msg2);
        }

        @Override
        public void e(@NotNull Function0<String> msg2) {
            Intrinsics.checkNotNullParameter(msg2, (String)"msg");
            this.$$delegate_0.e(msg2);
        }

        @Override
        public void i(@NotNull String msg2) {
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            this.$$delegate_0.i(msg2);
        }

        @Override
        public void i(@NotNull Function0<String> msg2) {
            Intrinsics.checkNotNullParameter(msg2, (String)"msg");
            this.$$delegate_0.i(msg2);
        }

        @Override
        public void t(@NotNull String msg2) {
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            this.$$delegate_0.t(msg2);
        }

        @Override
        public void t(@NotNull Function0<String> msg2) {
            Intrinsics.checkNotNullParameter(msg2, (String)"msg");
            this.$$delegate_0.t(msg2);
        }

        @Override
        public void v(@NotNull String msg2) {
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            this.$$delegate_0.v(msg2);
        }

        @Override
        public void v(@NotNull Function0<String> msg2) {
            Intrinsics.checkNotNullParameter(msg2, (String)"msg");
            this.$$delegate_0.v(msg2);
        }

        @Override
        public void w(@NotNull String msg2) {
            Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
            this.$$delegate_0.w(msg2);
        }

        @Override
        public void w(@NotNull Function0<String> msg2) {
            Intrinsics.checkNotNullParameter(msg2, (String)"msg");
            this.$$delegate_0.w(msg2);
        }

        @NotNull
        public final ECGenParameterSpec getP256() {
            return P256;
        }

        @JvmStatic
        @NotNull
        public final Enroller fromJWT(@NotNull String jwt) {
            Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
            return (Enroller)BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Enroller>, Object>(jwt, null){
                int label;
                final /* synthetic */ String $jwt;
                {
                    this.$jwt = $jwt;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ZitiJWT zitiJwt = ZitiJWT.Companion.fromJWT(this.$jwt);
                            Enroller.Companion.d("enrolling ctrl[" + zitiJwt.getController() + "] name[" + zitiJwt.getName() + "] method[" + zitiJwt.getMethod() + "]");
                            Collection<X509Certificate> controllerCA = CertsKt.getCACerts(zitiJwt.getController(), zitiJwt.getServerKey());
                            Enroller.Companion.d("received " + controllerCA.size() + " certificates");
                            String method2 = zitiJwt.getMethod();
                            String name = zitiJwt.getName();
                            return new Enroller(zitiJwt.getEnrollmentURL(), Method.valueOf(method2), name, controllerCA);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Enroller> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/openziti/identity/Enroller$Method;", "", "(Ljava/lang/String;I)V", "ott", "ottca", "ca", "ziti"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method ott = new Method();
        public static final /* enum */ Method ottca = new Method();
        public static final /* enum */ Method ca = new Method();
        private static final /* synthetic */ Method[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        @NotNull
        public static EnumEntries<Method> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = methodArray = new Method[]{Method.ott, Method.ottca, Method.ca};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.ott.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.ottca.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

