/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.jetbrains.annotations.NotNull;
import org.openziti.util.KeyTrustManager;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\"\u001e\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0016"}, d2={"cf", "Ljava/security/cert/CertificateFactory;", "kotlin.jvm.PlatformType", "getCf", "()Ljava/security/cert/CertificateFactory;", "Ljava/security/cert/CertificateFactory;", "readCerts", "", "Ljava/security/cert/X509Certificate;", "pem", "", "pemInput", "Ljava/io/Reader;", "readKey", "Ljava/security/PrivateKey;", "input", "getCACerts", "", "api", "Ljava/net/URI;", "serverKey", "Ljava/security/Key;", "ziti"})
public final class CertsKt {
    private static final CertificateFactory cf = CertificateFactory.getInstance("X.509");

    public static final CertificateFactory getCf() {
        return cf;
    }

    @NotNull
    public static final List<X509Certificate> readCerts(@NotNull String pem) {
        Intrinsics.checkNotNullParameter((Object)pem, (String)"pem");
        return CertsKt.readCerts(new StringReader(pem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<X509Certificate> readCerts(@NotNull Reader pemInput) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pemInput, (String)"pemInput");
        Closeable closeable = (Closeable)new PemReader(pemInput);
        Throwable throwable = null;
        try {
            PemReader reader = (PemReader)closeable;
            boolean bl = false;
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence(() -> CertsKt.readCerts$lambda$3$lambda$0(reader)), CertsKt::readCerts$lambda$3$lambda$1), CertsKt::readCerts$lambda$3$lambda$2));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public static final PrivateKey readKey(@NotNull Reader input) {
        PrivateKey privateKey;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PEMParser parser = new PEMParser(input);
        Object po = parser.readObject();
        if (po instanceof PEMKeyPair) {
            privateKey = new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)po).getPrivate();
        } else if (po instanceof PrivateKeyInfo) {
            privateKey = new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)po);
        } else {
            throw new IllegalStateException("unsupported key format".toString());
        }
        PrivateKey pk = privateKey;
        Intrinsics.checkNotNull((Object)pk);
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<X509Certificate> getCACerts(@NotNull URI api, @NotNull Key serverKey) {
        void $this$getCACerts_u24lambda_u244;
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)serverKey, (String)"serverKey");
        URLConnection uRLConnection = api.resolve("/.well-known/est/cacerts").toURL().openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection con = (HttpsURLConnection)uRLConnection;
        con.setRequestProperty("Accept", "application/pkcs7-mime");
        Object object = SSLContext.getInstance("TLSv1.2");
        HttpsURLConnection httpsURLConnection = con;
        boolean bl = false;
        KeyTrustManager[] keyTrustManagerArray = new KeyTrustManager[]{new KeyTrustManager(serverKey)};
        $this$getCACerts_u24lambda_u244.init(null, keyTrustManagerArray, new SecureRandom());
        httpsURLConnection.setSSLSocketFactory($this$getCACerts_u24lambda_u244.getSocketFactory());
        con.setDoInput(true);
        if (con.getResponseCode() == 200) {
            Closeable closeable = con.getInputStream();
            object = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
                Charset charset2 = charset;
                String b = new String(byArray, charset2);
                byte[] bytes = Base64.getMimeDecoder().decode(b);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Intrinsics.checkNotNull((Object)bytes);
                Collection<? extends Certificate> collection = cf.generateCertificates(new ByteArrayInputStream(bytes));
                Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.Collection<java.security.cert.X509Certificate>");
                Collection<? extends Certificate> collection2 = collection;
                return collection2;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        return CollectionsKt.emptyList();
    }

    private static final PemObject readCerts$lambda$3$lambda$0(PemReader $reader) {
        return $reader.readPemObject();
    }

    private static final boolean readCerts$lambda$3$lambda$1(PemObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)"CERTIFICATE");
    }

    private static final X509Certificate readCerts$lambda$3$lambda$2(PemObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        byte[] byArray = it.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContent(...)");
        byte[] byArray2 = byArray;
        Certificate certificate = cf.generateCertificate(new ByteArrayInputStream(byArray2));
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        return (X509Certificate)certificate;
    }
}

