/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.internal;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.util.Logged;
import org.openziti.util.ZitiLog;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\b\u0018\u0000 U2\u00020\u00012\u00020\u0002:\u0003UVWB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0007\u0010\u000eB!\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0007\u0010\u0011J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\rH\u0016J\u0010\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\rH\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u000201H\u0016J\u001f\u00102\u001a\u00020(2\u0010\u00103\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u000104H\u0016\u00a2\u0006\u0002\u00105J\u001f\u00106\u001a\u00020(2\u0010\u00107\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0010\u0018\u000104H\u0016\u00a2\u0006\u0002\u00105J\b\u00108\u001a\u000201H\u0016J\b\u00109\u001a\u000201H\u0016J\u0013\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001004H\u0016\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u000201H\u0016J\b\u0010=\u001a\u000201H\u0016J\u0013\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001004H\u0016\u00a2\u0006\u0002\u0010;J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u000201H\u0016J\u0013\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001004H\u0016\u00a2\u0006\u0002\u0010;J\u0010\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u000201H\u0016J\u0013\u0010D\u001a\b\u0012\u0004\u0012\u00020\u001004H\u0016\u00a2\u0006\u0002\u0010;J\u0012\u0010E\u001a\u00020(2\b\u0010F\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010G\u001a\u00020(2\b\u0010F\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010H\u001a\u00020(2\u0006\u0010I\u001a\u000201H\u0016J\u0011\u0010J\u001a\u00020(2\u0006\u0010K\u001a\u00020\u0010H\u0096\u0001J\u001b\u0010J\u001a\u00020(2\u0010\u0010K\u001a\f\u0012\u0004\u0012\u00020\u00100Lj\u0002`MH\u0096\u0001J\u0011\u0010N\u001a\u00020(2\u0006\u0010K\u001a\u00020\u0010H\u0096\u0001J\u0019\u0010N\u001a\u00020(2\u0006\u0010K\u001a\u00020\u00102\u0006\u0010O\u001a\u00020PH\u0096\u0001J\u001b\u0010N\u001a\u00020(2\u0010\u0010K\u001a\f\u0012\u0004\u0012\u00020\u00100Lj\u0002`MH\u0096\u0001J%\u0010N\u001a\u00020(2\b\u0010Q\u001a\u0004\u0018\u00010P2\u0010\u0010K\u001a\f\u0012\u0004\u0012\u00020\u00100Lj\u0002`MH\u0096\u0001J\u0011\u0010R\u001a\u00020(2\u0006\u0010K\u001a\u00020\u0010H\u0096\u0001J\u001b\u0010R\u001a\u00020(2\u0010\u0010K\u001a\f\u0012\u0004\u0012\u00020\u00100Lj\u0002`MH\u0096\u0001J\u0011\u0010O\u001a\u00020(2\u0006\u0010K\u001a\u00020\u0010H\u0096\u0001J\u001b\u0010O\u001a\u00020(2\u0010\u0010K\u001a\f\u0012\u0004\u0012\u00020\u00100Lj\u0002`MH\u0096\u0001J\u0011\u0010S\u001a\u00020(2\u0006\u0010K\u001a\u00020\u0010H\u0096\u0001J\u001b\u0010S\u001a\u00020(2\u0010\u0010K\u001a\f\u0012\u0004\u0012\u00020\u00100Lj\u0002`MH\u0096\u0001J\u0011\u0010T\u001a\u00020(2\u0006\u0010K\u001a\u00020\u0010H\u0096\u0001J\u001b\u0010T\u001a\u00020(2\u0010\u0010K\u001a\f\u0012\u0004\u0012\u00020\u00100Lj\u0002`MH\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u001b\u001a\u00060\u001cR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010!\u001a\u00060\"R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006X"}, d2={"Lorg/openziti/net/internal/ZitiSSLSocket;", "Ljavax/net/ssl/SSLSocket;", "Lorg/openziti/util/Logged;", "transport", "Ljava/net/Socket;", "engine", "Ljavax/net/ssl/SSLEngine;", "<init>", "(Ljava/net/Socket;Ljavax/net/ssl/SSLEngine;)V", "s", "addr", "Ljava/net/InetAddress;", "port", "", "(Ljava/net/Socket;Ljava/net/InetAddress;I)V", "host", "", "(Ljava/net/Socket;Ljava/lang/String;I)V", "getTransport", "()Ljava/net/Socket;", "getEngine", "()Ljavax/net/ssl/SSLEngine;", "sslBuffer", "Ljava/nio/ByteBuffer;", "hsListeners", "", "Ljavax/net/ssl/HandshakeCompletedListener;", "output", "Lorg/openziti/net/internal/ZitiSSLSocket$Output;", "getOutput", "()Lorg/openziti/net/internal/ZitiSSLSocket$Output;", "getOutputStream", "Ljava/io/OutputStream;", "input", "Lorg/openziti/net/internal/ZitiSSLSocket$Input;", "getInput", "()Lorg/openziti/net/internal/ZitiSSLSocket$Input;", "getInputStream", "Ljava/io/InputStream;", "startHandshake", "", "doHandshake", "getSession", "Ljavax/net/ssl/SSLSession;", "getSoTimeout", "setSoTimeout", "timeout", "setUseClientMode", "mode", "", "setEnabledProtocols", "protocols", "", "([Ljava/lang/String;)V", "setEnabledCipherSuites", "suites", "getUseClientMode", "getEnableSessionCreation", "getEnabledProtocols", "()[Ljava/lang/String;", "getWantClientAuth", "getNeedClientAuth", "getEnabledCipherSuites", "setNeedClientAuth", "need", "getSupportedCipherSuites", "setWantClientAuth", "want", "getSupportedProtocols", "addHandshakeCompletedListener", "listener", "removeHandshakeCompletedListener", "setEnableSessionCreation", "flag", "d", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "i", "v", "w", "Companion", "Output", "Input", "ziti"})
@SourceDebugExtension(value={"SMAP\nZitiSSLSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZitiSSLSocket.kt\norg/openziti/net/internal/ZitiSSLSocket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n1863#2,2:273\n*S KotlinDebug\n*F\n+ 1 ZitiSSLSocket.kt\norg/openziti/net/internal/ZitiSSLSocket\n*L\n199#1:273,2\n*E\n"})
public final class ZitiSSLSocket
extends SSLSocket
implements Logged {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final /* synthetic */ ZitiLog $$delegate_0;
    @NotNull
    private final Socket transport;
    @NotNull
    private final SSLEngine engine;
    @NotNull
    private final ByteBuffer sslBuffer;
    @NotNull
    private final List<HandshakeCompletedListener> hsListeners;
    @NotNull
    private final Output output;
    @NotNull
    private final Input input;
    private static final TrustManagerFactory tmf;
    private static final SSLContext tls;

    public ZitiSSLSocket(@NotNull Socket transport, @NotNull SSLEngine engine) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        this.$$delegate_0 = new ZitiLog("ziti-ssl-socket", null, 2, null);
        this.transport = transport;
        this.engine = engine;
        ByteBuffer byteBuffer = ByteBuffer.allocate(32768);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(...)");
        this.sslBuffer = byteBuffer;
        this.hsListeners = new ArrayList();
        this.engine.setUseClientMode(true);
        this.engine.beginHandshake();
        this.output = new Output();
        this.input = new Input();
    }

    @NotNull
    public final Socket getTransport() {
        return this.transport;
    }

    @NotNull
    public final SSLEngine getEngine() {
        return this.engine;
    }

    public ZitiSSLSocket(@NotNull Socket s, @NotNull InetAddress addr, int port) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        String string = addr.getHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
        this(s, string, port);
    }

    public ZitiSSLSocket(@NotNull Socket s, @NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        SSLEngine sSLEngine = tls.createSSLEngine(host, port);
        Intrinsics.checkNotNullExpressionValue((Object)sSLEngine, (String)"createSSLEngine(...)");
        this(s, sSLEngine);
    }

    @NotNull
    public final Output getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        this.doHandshake();
        return this.output;
    }

    @NotNull
    public final Input getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        this.doHandshake();
        return this.input;
    }

    @Override
    public void startHandshake() {
        this.engine.beginHandshake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doHandshake() {
        ZitiSSLSocket zitiSSLSocket = this;
        synchronized (zitiSSLSocket) {
            boolean bl = false;
            if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                return;
            }
            ByteBuffer empty = ByteBuffer.wrap(new byte[0]);
            ByteBuffer unwrapped = ByteBuffer.allocate(32768);
            byte[] ssl_in = new byte[32768];
            while (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                this.v("continuing handshake status=" + this.engine.getHandshakeStatus());
                SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
                switch (handshakeStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[handshakeStatus.ordinal()]) {
                    case 1: {
                        OutputStream outputStream;
                        ByteBuffer wrapped = ByteBuffer.allocate(32768);
                        SSLEngineResult res = this.engine.wrap(empty, wrapped);
                        this.v("res = " + res);
                        OutputStream $this$doHandshake_u24lambda_u244_u24lambda_u240 = outputStream = this.transport.getOutputStream();
                        boolean bl2 = false;
                        $this$doHandshake_u24lambda_u244_u24lambda_u240.write(wrapped.array(), 0, res.bytesProduced());
                        $this$doHandshake_u24lambda_u244_u24lambda_u240.flush();
                        break;
                    }
                    case 2: {
                        Runnable runnable = this.engine.getDelegatedTask();
                        if (runnable != null) {
                            runnable.run();
                        }
                        break;
                    }
                    case 3: {
                        this.sslBuffer.flip();
                        this.v("unwrapping bytes " + this.sslBuffer);
                        SSLEngineResult $this$doHandshake_u24lambda_u244_u24lambda_u241 = this.engine.unwrap(this.sslBuffer, unwrapped);
                        boolean bl3 = false;
                        this.v("res = " + $this$doHandshake_u24lambda_u244_u24lambda_u241);
                        this.sslBuffer.compact();
                        if ($this$doHandshake_u24lambda_u244_u24lambda_u241.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                        int r = this.transport.getInputStream().read(ssl_in, 0, this.sslBuffer.remaining());
                        if (r < 0) {
                            throw new SSLHandshakeException("connection closed during SSL handshake");
                        }
                        this.sslBuffer.put(ssl_in, 0, r);
                    }
                }
            }
            HandshakeCompletedEvent ev = new HandshakeCompletedEvent(this, this.engine.getSession());
            List<HandshakeCompletedListener> list = this.hsListeners;
            synchronized (list) {
                boolean bl4 = false;
                Iterable $this$forEach$iv = this.hsListeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HandshakeCompletedListener it = (HandshakeCompletedListener)element$iv;
                    boolean bl5 = false;
                    it.handshakeCompleted(ev);
                }
                Unit unit = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public SSLSession getSession() {
        this.doHandshake();
        SSLSession sSLSession = this.engine.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSession, (String)"getSession(...)");
        return sSLSession;
    }

    @Override
    public int getSoTimeout() {
        return this.transport.getSoTimeout();
    }

    @Override
    public void setSoTimeout(int timeout) {
        this.transport.setSoTimeout(timeout);
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.engine.setUseClientMode(mode);
    }

    @Override
    public void setEnabledProtocols(@Nullable String[] protocols) {
        this.engine.setEnabledProtocols(protocols);
    }

    @Override
    public void setEnabledCipherSuites(@Nullable String[] suites) {
        this.engine.setEnabledCipherSuites(suites);
    }

    @Override
    public boolean getUseClientMode() {
        return this.engine.getUseClientMode();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.engine.getEnableSessionCreation();
    }

    @Override
    @NotNull
    public String[] getEnabledProtocols() {
        String[] stringArray = this.engine.getEnabledProtocols();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getEnabledProtocols(...)");
        return stringArray;
    }

    @Override
    public boolean getWantClientAuth() {
        return this.engine.getWantClientAuth();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.engine.getNeedClientAuth();
    }

    @Override
    @NotNull
    public String[] getEnabledCipherSuites() {
        String[] stringArray = this.engine.getEnabledCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getEnabledCipherSuites(...)");
        return stringArray;
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.engine.setNeedClientAuth(need);
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.engine.getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSupportedCipherSuites(...)");
        return stringArray;
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.engine.setWantClientAuth(want);
    }

    @Override
    @NotNull
    public String[] getSupportedProtocols() {
        String[] stringArray = this.engine.getSupportedProtocols();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSupportedProtocols(...)");
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandshakeCompletedListener(@Nullable HandshakeCompletedListener listener) {
        block4: {
            HandshakeCompletedListener handshakeCompletedListener = listener;
            if (handshakeCompletedListener == null) break block4;
            HandshakeCompletedListener it = handshakeCompletedListener;
            boolean bl = false;
            List<HandshakeCompletedListener> list = this.hsListeners;
            synchronized (list) {
                boolean bl2 = false;
                boolean bl3 = this.hsListeners.add(it);
            }
            if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                listener.handshakeCompleted(new HandshakeCompletedEvent(this, this.engine.getSession()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandshakeCompletedListener(@Nullable HandshakeCompletedListener listener) {
        HandshakeCompletedListener handshakeCompletedListener = listener;
        if (handshakeCompletedListener != null) {
            HandshakeCompletedListener it = handshakeCompletedListener;
            boolean bl = false;
            List<HandshakeCompletedListener> list = this.hsListeners;
            synchronized (list) {
                boolean bl2 = false;
                boolean bl3 = this.hsListeners.remove(it);
            }
        }
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.engine.setEnableSessionCreation(flag);
    }

    @Override
    public void e(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.$$delegate_0.e(msg, t);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(ex, msg);
    }

    @Override
    public void w(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void w(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void i(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void i(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void d(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void d(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void v(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void v(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void t(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    @Override
    public void t(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    static {
        Object object = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory $this$tmf_u24lambda_u249 = object;
        boolean bl = false;
        $this$tmf_u24lambda_u249.init((KeyStore)null);
        tmf = object;
        Object $this$tls_u24lambda_u2410 = object = SSLContext.getInstance("TLSv1.3");
        boolean bl2 = false;
        ((SSLContext)$this$tls_u24lambda_u2410).init(null, tmf.getTrustManagers(), new SecureRandom());
        tls = object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\u000b0\u000b\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/openziti/net/internal/ZitiSSLSocket$Companion;", "", "<init>", "()V", "tmf", "Ljavax/net/ssl/TrustManagerFactory;", "kotlin.jvm.PlatformType", "getTmf", "()Ljavax/net/ssl/TrustManagerFactory;", "Ljavax/net/ssl/TrustManagerFactory;", "tls", "Ljavax/net/ssl/SSLContext;", "getTls", "()Ljavax/net/ssl/SSLContext;", "Ljavax/net/ssl/SSLContext;", "ziti"})
    public static final class Companion {
        private Companion() {
        }

        public final TrustManagerFactory getTmf() {
            return tmf;
        }

        public final SSLContext getTls() {
            return tls;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/openziti/net/internal/ZitiSSLSocket$Input;", "Ljava/io/InputStream;", "<init>", "(Lorg/openziti/net/internal/ZitiSSLSocket;)V", "plainBuffer", "Ljava/nio/ByteBuffer;", "input", "read", "", "copyPlainText", "out", "", "off", "len", "ziti"})
    public final class Input
    extends InputStream {
        @NotNull
        private final ByteBuffer plainBuffer;
        @NotNull
        private final InputStream input;

        /*
         * WARNING - void declaration
         */
        public Input() {
            void $this$plainBuffer_u24lambda_u240;
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocate(32768);
            Input input = this;
            boolean bl = false;
            $this$plainBuffer_u24lambda_u240.flip();
            ByteBuffer byteBuffer3 = byteBuffer;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"apply(...)");
            input.plainBuffer = byteBuffer3;
            InputStream inputStream = ZitiSSLSocket.this.getTransport().getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            this.input = inputStream;
        }

        @Override
        public int read() {
            byte[] buf = new byte[1];
            int read2 = this.read(buf, 0, 1);
            return read2 == 1 ? buf[0] & 0xFF : -1;
        }

        private final int copyPlainText(byte[] out, int off, int len) {
            this.plainBuffer.flip();
            int count = len > this.plainBuffer.remaining() ? this.plainBuffer.remaining() : len;
            this.plainBuffer.get(out, off, count);
            this.plainBuffer.compact();
            return count;
        }

        @Override
        public int read(@NotNull byte[] out, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int count = this.copyPlainText(out, off, len);
            if (count > 0) {
                return count;
            }
            ZitiSSLSocket.this.sslBuffer.flip();
            SSLEngineResult sSLEngineResult = ZitiSSLSocket.this.getEngine().unwrap(ZitiSSLSocket.this.sslBuffer, this.plainBuffer);
            ZitiSSLSocket zitiSSLSocket = ZitiSSLSocket.this;
            SSLEngineResult $this$read_u24lambda_u241 = sSLEngineResult;
            boolean bl = false;
            zitiSSLSocket.sslBuffer.compact();
            if ($this$read_u24lambda_u241.bytesProduced() > 0) {
                return this.copyPlainText(out, off, len);
            }
            while (this.plainBuffer.position() == 0) {
                byte[] b = new byte[ZitiSSLSocket.this.sslBuffer.remaining()];
                int read2 = this.input.read(b);
                if (read2 < 0) {
                    return -1;
                }
                ZitiSSLSocket.this.sslBuffer.put(b, 0, read2);
                ZitiSSLSocket.this.sslBuffer.flip();
                ZitiSSLSocket.this.getEngine().unwrap(ZitiSSLSocket.this.sslBuffer, this.plainBuffer);
                ZitiSSLSocket.this.sslBuffer.compact();
            }
            return this.copyPlainText(out, off, len);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u001b\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/openziti/net/internal/ZitiSSLSocket$Output;", "Ljava/io/OutputStream;", "<init>", "(Lorg/openziti/net/internal/ZitiSSLSocket;)V", "buffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "getBuffer", "()Ljava/nio/ByteBuffer;", "Ljava/nio/ByteBuffer;", "write", "", "b", "", "", "off", "len", "flush", "ziti"})
    public final class Output
    extends OutputStream {
        private final ByteBuffer buffer = ByteBuffer.allocate(32768);

        public final ByteBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void write(int b) {
            this.buffer.put((byte)b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            ZitiSSLSocket.this.v((Function0<String>)((Function0)() -> Output.write$lambda$0(len)));
            if (len + this.buffer.position() > this.buffer.capacity()) {
                this.flush();
            }
            this.buffer.put(b, off, len);
            this.flush();
        }

        @Override
        public void flush() {
            ByteBuffer wrapped = ByteBuffer.allocate(32768);
            this.buffer.flip();
            if (this.buffer.hasRemaining()) {
                SSLEngineResult res = ZitiSSLSocket.this.getEngine().wrap(this.buffer, wrapped);
                ZitiSSLSocket.this.v((Function0<String>)((Function0)() -> Output.flush$lambda$1(res)));
                OutputStream outputStream = ZitiSSLSocket.this.getTransport().getOutputStream();
                if (outputStream != null) {
                    OutputStream outputStream2;
                    OutputStream $this$flush_u24lambda_u242 = outputStream2 = outputStream;
                    boolean bl = false;
                    $this$flush_u24lambda_u242.write(wrapped.array(), 0, wrapped.position());
                    $this$flush_u24lambda_u242.flush();
                }
            }
            this.buffer.clear();
        }

        private static final String write$lambda$0(int $len) {
            return "writing " + $len + " bytes";
        }

        private static final String flush$lambda$1(SSLEngineResult $res) {
            return "flushing " + $res.bytesProduced() + " bytes";
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SSLEngineResult.HandshakeStatus.values().length];
            try {
                nArray[SSLEngineResult.HandshakeStatus.NEED_WRAP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSLEngineResult.HandshakeStatus.NEED_TASK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SSLEngineResult.HandshakeStatus.NEED_UNWRAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

