/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.nio;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.internal.ZitiSSLSocket;
import org.openziti.net.nio.AsyncTLSChannelSocket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J,\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lorg/openziti/net/nio/AsyncTLSSocketFactory;", "Ljavax/net/ssl/SSLSocketFactory;", "ssl", "Ljavax/net/ssl/SSLContext;", "<init>", "(Ljavax/net/ssl/SSLContext;)V", "()V", "getSsl", "()Ljavax/net/ssl/SSLContext;", "getDefaultCipherSuites", "", "", "()[Ljava/lang/String;", "getSupportedCipherSuites", "createSocket", "Ljava/net/Socket;", "transport", "host", "port", "", "autoClose", "", "localHost", "Ljava/net/InetAddress;", "localPort", "address", "localAddress", "ziti"})
public final class AsyncTLSSocketFactory
extends SSLSocketFactory {
    @NotNull
    private final SSLContext ssl;

    public AsyncTLSSocketFactory(@NotNull SSLContext ssl) {
        Intrinsics.checkNotNullParameter((Object)ssl, (String)"ssl");
        this.ssl = ssl;
    }

    @NotNull
    public final SSLContext getSsl() {
        return this.ssl;
    }

    public AsyncTLSSocketFactory() {
        SSLContext sSLContext = SSLContext.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"getDefault(...)");
        this(sSLContext);
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.ssl.createSSLEngine().getEnabledCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getEnabledCipherSuites(...)");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.ssl.createSSLEngine().getSupportedCipherSuites();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getSupportedCipherSuites(...)");
        return stringArray;
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull Socket transport, @NotNull String host, int port, boolean autoClose) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        SSLEngine sSLEngine = this.ssl.createSSLEngine(host, port);
        Intrinsics.checkNotNullExpressionValue((Object)sSLEngine, (String)"createSSLEngine(...)");
        return new ZitiSSLSocket(transport, sSLEngine);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable String host, int port) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), null, this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@NotNull String host, int port, @Nullable InetAddress localHost, int localPort) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), new InetSocketAddress(localHost, localPort), this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress host, int port) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(host, port), null, this.ssl);
    }

    @Override
    @NotNull
    public Socket createSocket(@Nullable InetAddress address, int port, @Nullable InetAddress localAddress, int localPort) {
        return new AsyncTLSChannelSocket(new InetSocketAddress(address, port), new InetSocketAddress(localAddress, localPort), this.ssl);
    }
}

