/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.dns;

import java.io.Writer;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.dns.DNSResolver;
import org.openziti.util.IPUtil;
import org.openziti.util.Logged;
import org.openziti.util.ZitiLog;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002=>B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b%J\u0012\u0010&\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u0011H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010)\u001a\u00020\u0016H\u0016J\u001c\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00112\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0019H\u0002J\r\u0010-\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u000201H\u0016J\u0011\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0011H\u0096\u0001J\u001b\u00102\u001a\u00020\u001f2\u0010\u00103\u001a\f\u0012\u0004\u0012\u00020\u001104j\u0002`5H\u0096\u0001J\u0011\u00106\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0011H\u0096\u0001J\u0019\u00106\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u00112\u0006\u00107\u001a\u000208H\u0096\u0001J\u001b\u00106\u001a\u00020\u001f2\u0010\u00103\u001a\f\u0012\u0004\u0012\u00020\u001104j\u0002`5H\u0096\u0001J%\u00106\u001a\u00020\u001f2\b\u00109\u001a\u0004\u0018\u0001082\u0010\u00103\u001a\f\u0012\u0004\u0012\u00020\u001104j\u0002`5H\u0096\u0001J\u0011\u0010:\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0011H\u0096\u0001J\u001b\u0010:\u001a\u00020\u001f2\u0010\u00103\u001a\f\u0012\u0004\u0012\u00020\u001104j\u0002`5H\u0096\u0001J\u0011\u00107\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0011H\u0096\u0001J\u001b\u00107\u001a\u00020\u001f2\u0010\u00103\u001a\f\u0012\u0004\u0012\u00020\u001104j\u0002`5H\u0096\u0001J\u0011\u0010;\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0011H\u0096\u0001J\u001b\u0010;\u001a\u00020\u001f2\u0010\u00103\u001a\f\u0012\u0004\u0012\u00020\u001104j\u0002`5H\u0096\u0001J\u0011\u0010<\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\u0011H\u0096\u0001J\u001b\u0010<\u001a\u00020\u001f2\u0010\u00103\u001a\f\u0012\u0004\u0012\u00020\u001104j\u0002`5H\u0096\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00120\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00190\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006?"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager;", "Lorg/openziti/net/dns/DNSResolver;", "Lorg/openziti/util/Logged;", "<init>", "()V", "PREFIX", "", "getPREFIX$ziti", "()[B", "startPostfix", "", "postfix", "Ljava/util/concurrent/atomic/AtomicInteger;", "getPostfix$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "host2Ip", "", "", "Lorg/openziti/net/dns/ZitiDNSManager$Entry;", "getHost2Ip$ziti", "()Ljava/util/Map;", "ip2host", "Ljava/net/InetAddress;", "getIp2host$ziti", "domains", "Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "getDomains$ziti", "registerHostname", "hostname", "registerHostname$ziti", "unregisterHostname", "", "unregisterHostname$ziti", "registerDomain", "domainName", "registerDomain$ziti", "unregisterDomain", "unregisterDomain$ziti", "resolve", "resolveOrAssign", "lookup", "addr", "nextAddr", "dnsname", "domain", "reset", "reset$ziti", "dump", "writer", "Ljava/io/Writer;", "d", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "i", "v", "w", "Domain", "Entry", "ziti"})
@SourceDebugExtension(value={"SMAP\nZitiDNSManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZitiDNSManager.kt\norg/openziti/net/dns/ZitiDNSManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n381#2,7:161\n774#3:168\n865#3,2:169\n1863#3,2:171\n1#4:173\n*S KotlinDebug\n*F\n+ 1 ZitiDNSManager.kt\norg/openziti/net/dns/ZitiDNSManager\n*L\n55#1:161,7\n98#1:168\n98#1:169,2\n99#1:171,2\n*E\n"})
public final class ZitiDNSManager
implements DNSResolver,
Logged {
    @NotNull
    public static final ZitiDNSManager INSTANCE = new ZitiDNSManager();
    private final /* synthetic */ ZitiLog $$delegate_0;
    @NotNull
    private static final byte[] PREFIX;
    public static final int startPostfix = 257;
    @NotNull
    private static final AtomicInteger postfix;
    @NotNull
    private static final Map<String, Entry> host2Ip;
    @NotNull
    private static final Map<InetAddress, Entry> ip2host;
    @NotNull
    private static final Map<String, Domain> domains;

    private ZitiDNSManager() {
        this.$$delegate_0 = new ZitiLog();
    }

    @NotNull
    public final byte[] getPREFIX$ziti() {
        return PREFIX;
    }

    @NotNull
    public final AtomicInteger getPostfix$ziti() {
        return postfix;
    }

    @NotNull
    public final Map<String, Entry> getHost2Ip$ziti() {
        return host2Ip;
    }

    @NotNull
    public final Map<InetAddress, Entry> getIp2host$ziti() {
        return ip2host;
    }

    @NotNull
    public final Map<String, Domain> getDomains$ziti() {
        return domains;
    }

    @NotNull
    public final InetAddress registerHostname$ziti(@NotNull String hostname) {
        InetAddress inetAddress;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (IPUtil.isValidIPv4(hostname)) {
            inetAddress = Inet4Address.getByName(hostname);
        } else if (IPUtil.isValidIPv6(hostname)) {
            inetAddress = Inet6Address.getByName(hostname);
        } else {
            Entry entry;
            String string = hostname.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String dnsName = string;
            Map<String, Entry> $this$getOrPut$iv = host2Ip;
            boolean $i$f$getOrPut = false;
            Entry value$iv = $this$getOrPut$iv.get(dnsName);
            if (value$iv == null) {
                boolean bl = false;
                Entry e = ZitiDNSManager.nextAddr$default(INSTANCE, dnsName, null, 2, null);
                ip2host.put(e.getAddr(), e);
                Entry answer$iv = e;
                $this$getOrPut$iv.put(dnsName, answer$iv);
                entry = answer$iv;
            } else {
                entry = value$iv;
            }
            Entry entry2 = entry;
            this.i((Function0<String>)((Function0)() -> ZitiDNSManager.registerHostname$lambda$1(hostname, entry2)));
            inetAddress = entry2.getAddr();
        }
        InetAddress ip = inetAddress;
        Intrinsics.checkNotNull((Object)ip);
        return ip;
    }

    public final void unregisterHostname$ziti(@NotNull String hostname) {
        block0: {
            Entry e;
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            String string = hostname.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Entry entry = e = host2Ip.remove(string);
            if (entry == null) break block0;
            Entry it = entry;
            boolean bl = false;
            INSTANCE.i((Function0<String>)((Function0)() -> ZitiDNSManager.unregisterHostname$lambda$3$lambda$2(it)));
            ip2host.remove(e.getAddr());
        }
    }

    public final void registerDomain$ziti(@NotNull String domainName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        if (StringsKt.startsWith$default((String)domainName, (String)"*.", (boolean)false, (int)2, null)) {
            String string2 = domainName.substring(2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (StringsKt.startsWith$default((String)domainName, (String)".", (boolean)false, (int)2, null)) {
            String string3 = domainName.substring(1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = domainName;
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String key = string4;
        Domain domain = new Domain("*." + key);
        if (domains.putIfAbsent(key, domain) == null) {
            this.i((Function0<String>)((Function0)() -> ZitiDNSManager.registerDomain$lambda$4(domain)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unregisterDomain$ziti(@NotNull String domainName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        if (StringsKt.startsWith$default((String)domainName, (String)"*.", (boolean)false, (int)2, null)) {
            String string2 = domainName.substring(2);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else if (StringsKt.startsWith$default((String)domainName, (String)".", (boolean)false, (int)2, null)) {
            String string3 = domainName.substring(1);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = domainName;
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String key = string4;
        Domain domain = domains.remove(key);
        if (domain != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = host2Ip.values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Entry it = (Entry)element$iv$iv;
                boolean bl = false;
                if (!(it.getDomain() == domain)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List entries = (List)destination$iv$iv;
            Iterable $this$forEach$iv = entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry it = (Entry)element$iv;
                boolean bl = false;
                INSTANCE.unregisterHostname$ziti(it.getName());
            }
            this.i((Function0<String>)((Function0)() -> ZitiDNSManager.unregisterDomain$lambda$7(domain)));
        }
    }

    @Override
    @Nullable
    public InetAddress resolve(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String string = hostname.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return this.resolveOrAssign(string);
    }

    private final InetAddress resolveOrAssign(String hostname) {
        String string = hostname.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String name = string;
        Object object = host2Ip.get(name);
        if (object != null) {
            Entry it = object;
            boolean bl = false;
            return it.getAddr();
        }
        do {
            if ((object = domains.get(name)) == null) continue;
            Object it = object;
            boolean bl = false;
            Entry entry = INSTANCE.nextAddr(hostname, (Domain)it);
            ip2host.put(entry.getAddr(), entry);
            host2Ip.put(hostname, entry);
            return entry.getAddr();
        } while (((CharSequence)(name = StringsKt.substringAfter((String)name, (char)'.', (String)""))).length() > 0);
        return null;
    }

    @Override
    @Nullable
    public String lookup(@NotNull InetAddress addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        Entry entry = ip2host.get(addr);
        return entry != null ? entry.getName() : null;
    }

    private final Entry nextAddr(String dnsname, Domain domain) {
        int nextPostfix = postfix.incrementAndGet();
        if ((nextPostfix & 0xFF) == 0) {
            nextPostfix = postfix.incrementAndGet();
        }
        byte[] byArray = new byte[]{(byte)(nextPostfix >> 8 & 0xFF), (byte)(nextPostfix & 0xFF)};
        byte[] ip = ArraysKt.plus((byte[])PREFIX, (byte[])byArray);
        InetAddress addr = InetAddress.getByAddress(dnsname, ip);
        this.i((Function0<String>)((Function0)() -> ZitiDNSManager.nextAddr$lambda$10(dnsname, addr, domain)));
        Intrinsics.checkNotNull((Object)addr);
        return new Entry(dnsname, addr, domain);
    }

    static /* synthetic */ Entry nextAddr$default(ZitiDNSManager zitiDNSManager, String string, Domain domain, int n, Object object) {
        if ((n & 2) != 0) {
            domain = null;
        }
        return zitiDNSManager.nextAddr(string, domain);
    }

    public final void reset$ziti() {
        host2Ip.clear();
        ip2host.clear();
        postfix.set(257);
    }

    @Override
    public void dump(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        for (Map.Entry<String, Entry> entry : host2Ip.entrySet()) {
            String h = entry.getKey();
            Entry ip = entry.getValue();
            Appendable appendable = ((Appendable)writer).append(h + " -> " + ip);
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)writer).append('\n'), (String)"append(...)");
        Appendable appendable = ((Appendable)writer).append("== Wildcard Domains ==");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        domains.forEach((arg_0, arg_1) -> ZitiDNSManager.dump$lambda$12((arg_0, arg_1) -> ZitiDNSManager.dump$lambda$11(writer, arg_0, arg_1), arg_0, arg_1));
    }

    @Override
    public void e(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.$$delegate_0.e(msg, t);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(ex, msg);
    }

    @Override
    public void w(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void w(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void i(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void i(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void d(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void d(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void v(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void v(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void t(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    @Override
    public void t(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    private static final String registerHostname$lambda$1(String $hostname, Entry $entry) {
        return "registered: " + $hostname + " => " + $entry;
    }

    private static final String unregisterHostname$lambda$3$lambda$2(Entry $it) {
        return "removed entry=" + $it;
    }

    private static final String registerDomain$lambda$4(Domain $domain) {
        return "registered " + $domain;
    }

    private static final String unregisterDomain$lambda$7(Domain $domain) {
        return "domain[" + $domain.getName() + "] removed";
    }

    private static final String nextAddr$lambda$10(String $dnsname, InetAddress $addr, Domain $domain) {
        Object object = $domain;
        if (object == null || (object = ((Domain)object).getName()) == null) {
            object = "";
        }
        return "assigned " + $dnsname + " => " + $addr + " [" + (String)object + "]";
    }

    private static final Unit dump$lambda$11(Writer $writer, String string, Domain domain) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Appendable appendable = ((Appendable)$writer).append(domain.getName());
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        return Unit.INSTANCE;
    }

    private static final void dump$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    static {
        byte[] byArray = new byte[]{100, 64};
        PREFIX = byArray;
        postfix = new AtomicInteger(257);
        host2Ip = new LinkedHashMap();
        ip2host = new LinkedHashMap();
        domains = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "ziti"})
    public static final class Domain {
        @NotNull
        private final String name;

        public Domain(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Domain copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Domain(name);
        }

        public static /* synthetic */ Domain copy$default(Domain domain, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = domain.name;
            }
            return domain.copy(string);
        }

        @NotNull
        public String toString() {
            return "Domain(name=" + this.name + ")";
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Domain)) {
                return false;
            }
            Domain domain = (Domain)other;
            return Intrinsics.areEqual((Object)this.name, (Object)domain.name);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0003H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager$Entry;", "", "name", "", "addr", "Ljava/net/InetAddress;", "domain", "Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "<init>", "(Ljava/lang/String;Ljava/net/InetAddress;Lorg/openziti/net/dns/ZitiDNSManager$Domain;)V", "getName", "()Ljava/lang/String;", "getAddr", "()Ljava/net/InetAddress;", "getDomain", "()Lorg/openziti/net/dns/ZitiDNSManager$Domain;", "repr", "getRepr", "repr$delegate", "Lkotlin/Lazy;", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "ziti"})
    @SourceDebugExtension(value={"SMAP\nZitiDNSManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZitiDNSManager.kt\norg/openziti/net/dns/ZitiDNSManager$Entry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
    public static final class Entry {
        @NotNull
        private final String name;
        @NotNull
        private final InetAddress addr;
        @Nullable
        private final Domain domain;
        @NotNull
        private final Lazy repr$delegate;

        public Entry(@NotNull String name, @NotNull InetAddress addr, @Nullable Domain domain) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            this.name = name;
            this.addr = addr;
            this.domain = domain;
            this.repr$delegate = LazyKt.lazy(() -> Entry.repr_delegate$lambda$1(this));
        }

        public /* synthetic */ Entry(String string, InetAddress inetAddress, Domain domain, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                domain = null;
            }
            this(string, inetAddress, domain);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final InetAddress getAddr() {
            return this.addr;
        }

        @Nullable
        public final Domain getDomain() {
            return this.domain;
        }

        private final String getRepr() {
            Lazy lazy = this.repr$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public String toString() {
            return this.getRepr();
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final InetAddress component2() {
            return this.addr;
        }

        @Nullable
        public final Domain component3() {
            return this.domain;
        }

        @NotNull
        public final Entry copy(@NotNull String name, @NotNull InetAddress addr, @Nullable Domain domain) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
            return new Entry(name, addr, domain);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, String string, InetAddress inetAddress, Domain domain, int n, Object object) {
            if ((n & 1) != 0) {
                string = entry.name;
            }
            if ((n & 2) != 0) {
                inetAddress = entry.addr;
            }
            if ((n & 4) != 0) {
                domain = entry.domain;
            }
            return entry.copy(string, inetAddress, domain);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.addr.hashCode();
            result = result * 31 + (this.domain == null ? 0 : this.domain.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)entry.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.addr, (Object)entry.addr)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.domain, (Object)entry.domain);
        }

        private static final String repr_delegate$lambda$1(Entry this$0) {
            Object object;
            block3: {
                block2: {
                    object = this$0.domain;
                    if (object == null) break block2;
                    Domain it = object;
                    boolean bl = false;
                    String string = this$0.addr + " [" + it.getName() + "]";
                    object = string;
                    if (string != null) break block3;
                }
                String string = this$0.addr.toString();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            }
            return object;
        }
    }
}

