/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.internal;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.ZitiSSLSocketFactory;
import org.openziti.net.dns.ZitiDNSManager;
import org.openziti.util.Logged;
import org.openziti.util.ZitiLog;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0006\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0001HB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u001aH\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020\u001aH\u0016J\b\u0010&\u001a\u00020'H\u0016J\u001a\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0*0)H\u0016J\b\u0010+\u001a\u00020\"H\u0016J\u0013\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020\u001aH\u0016J\u0013\u00101\u001a\b\u0012\u0004\u0012\u00020.0-H\u0016\u00a2\u0006\u0002\u0010/J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u000207J\u0011\u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001aH\u0096\u0001J\u001b\u0010=\u001a\u00020\u00182\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020\u001a0?j\u0002`@H\u0096\u0001J\u0011\u0010A\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001aH\u0096\u0001J\u0019\u0010A\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020CH\u0096\u0001J\u001b\u0010A\u001a\u00020\u00182\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020\u001a0?j\u0002`@H\u0096\u0001J%\u0010A\u001a\u00020\u00182\b\u0010D\u001a\u0004\u0018\u00010C2\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020\u001a0?j\u0002`@H\u0096\u0001J\u0011\u0010E\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001aH\u0096\u0001J\u001b\u0010E\u001a\u00020\u00182\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020\u001a0?j\u0002`@H\u0096\u0001J\u0011\u0010B\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001aH\u0096\u0001J\u001b\u0010B\u001a\u00020\u00182\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020\u001a0?j\u0002`@H\u0096\u0001J\u0011\u0010F\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001aH\u0096\u0001J\u001b\u0010F\u001a\u00020\u00182\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020\u001a0?j\u0002`@H\u0096\u0001J\u0011\u0010G\u001a\u00020\u00182\u0006\u0010>\u001a\u00020\u001aH\u0096\u0001J\u001b\u0010G\u001a\u00020\u00182\u0010\u0010>\u001a\f\u0012\u0004\u0012\u00020\u001a0?j\u0002`@H\u0096\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u00108\u001a\u0004\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<\u00a8\u0006I"}, d2={"Lorg/openziti/net/internal/ZitiHTTPSConnection;", "Ljavax/net/ssl/HttpsURLConnection;", "Lorg/openziti/util/Logged;", "url", "Ljava/net/URL;", "<init>", "(Ljava/net/URL;)V", "usingProxy", "", "body", "Ljava/io/ByteArrayOutputStream;", "getBody", "()Ljava/io/ByteArrayOutputStream;", "req", "Lokhttp3/Request$Builder;", "getReq", "()Lokhttp3/Request$Builder;", "call", "Lokhttp3/Call;", "getCall", "()Lokhttp3/Call;", "setCall", "(Lokhttp3/Call;)V", "setRequestMethod", "", "method", "", "setRequestProperty", "key", "value", "addRequestProperty", "connect", "disconnect", "getResponseCode", "", "getResponseMessage", "getHeaderField", "name", "getContentLengthLong", "", "getHeaderFields", "", "", "getContentLength", "getServerCertificates", "", "Ljava/security/cert/Certificate;", "()[Ljava/security/cert/Certificate;", "getCipherSuite", "getLocalCertificates", "getOutputStream", "Ljava/io/OutputStream;", "getInputStream", "Ljava/io/InputStream;", "execute", "Lokhttp3/Response;", "response", "getResponse", "()Lokhttp3/Response;", "setResponse", "(Lokhttp3/Response;)V", "d", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "i", "v", "w", "Companion", "ziti"})
public final class ZitiHTTPSConnection
extends HttpsURLConnection
implements Logged {
    @NotNull
    public static final Companion Companion;
    private final /* synthetic */ ZitiLog $$delegate_0;
    @NotNull
    private final ByteArrayOutputStream body;
    @NotNull
    private final Request.Builder req;
    public Call call;
    @Nullable
    private Response response;
    @NotNull
    private static final ZitiSSLSocketFactory sslFactory;
    private static final TrustManagerFactory tm;
    @NotNull
    private static final OkHttpClient clt;

    /*
     * WARNING - void declaration
     */
    public ZitiHTTPSConnection(@NotNull URL url) {
        void $this$req_u24lambda_u240;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super(url);
        this.$$delegate_0 = new ZitiLog("ziti-https", null, 2, null);
        this.body = new ByteArrayOutputStream(1024);
        Request.Builder builder2 = builder = new Request.Builder();
        ZitiHTTPSConnection zitiHTTPSConnection = this;
        boolean bl = false;
        URL uRL = this.url;
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"url");
        $this$req_u24lambda_u240.url(uRL);
        zitiHTTPSConnection.req = builder;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    @NotNull
    public final ByteArrayOutputStream getBody() {
        return this.body;
    }

    @NotNull
    public final Request.Builder getReq() {
        return this.req;
    }

    @NotNull
    public final Call getCall() {
        Call call = this.call;
        if (call != null) {
            return call;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"call");
        return null;
    }

    public final void setCall(@NotNull Call call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"<set-?>");
        this.call = call;
    }

    @Override
    public void setRequestMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        super.setRequestMethod(method);
        Request.Builder builder = HttpMethod.permitsRequestBody((String)method) ? this.req.method(method, new RequestBody(this){
            final /* synthetic */ ZitiHTTPSConnection this$0;
            {
                this.this$0 = $receiver;
            }

            public MediaType contentType() {
                String string = this.this$0.getReq().build().header("Content-Type");
                return string != null ? MediaType.Companion.parse(string) : null;
            }

            public long contentLength() {
                return this.this$0.getBody().size();
            }

            public void writeTo(BufferedSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                byte[] byArray = this.this$0.getBody().toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                sink.write(byArray);
            }
        }) : this.req.method(method, null);
    }

    @Override
    public void setRequestProperty(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.setRequestProperty(key, value);
        this.req.header(key, value);
    }

    @Override
    public void addRequestProperty(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super.addRequestProperty(key, value);
        this.req.addHeader(key, value);
    }

    @Override
    public void connect() {
        this.execute();
    }

    @Override
    public void disconnect() {
        this.d("disconnect()");
    }

    @Override
    public int getResponseCode() {
        return this.execute().code();
    }

    @Override
    @NotNull
    public String getResponseMessage() {
        return this.execute().message();
    }

    @Override
    @Nullable
    public String getHeaderField(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Response.header$default((Response)this.execute(), (String)name, null, (int)2, null);
    }

    @Override
    public long getContentLengthLong() {
        ResponseBody responseBody = this.execute().body();
        return responseBody != null ? responseBody.contentLength() : 0L;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getHeaderFields() {
        return this.execute().headers().toMultimap();
    }

    @Override
    public int getContentLength() {
        ResponseBody responseBody = this.execute().body();
        return responseBody != null ? (int)responseBody.contentLength() : 0;
    }

    @Override
    @NotNull
    public Certificate[] getServerCertificates() {
        throw new IllegalStateException("not implemented".toString());
    }

    @Override
    @NotNull
    public String getCipherSuite() {
        throw new IllegalStateException("not implemented".toString());
    }

    @Override
    @NotNull
    public Certificate[] getLocalCertificates() {
        throw new IllegalStateException("not implemented".toString());
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return this.body;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        this.execute();
        Response response = this.response;
        InputStream inputStream = response != null && (response = response.body()) != null ? response.byteStream() : null;
        Intrinsics.checkNotNull((Object)inputStream);
        return inputStream;
    }

    @NotNull
    public final Response execute() {
        if (this.response == null) {
            Request request = this.req.build();
            this.d("executing " + request);
            Call newCall = clt.newCall(request);
            this.response = newCall.execute();
            this.d("finished executing " + this.response);
        }
        Response response = this.response;
        Intrinsics.checkNotNull((Object)response);
        return response;
    }

    @Nullable
    public final Response getResponse() {
        return this.response;
    }

    public final void setResponse(@Nullable Response response) {
        this.response = response;
    }

    @Override
    public void e(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.$$delegate_0.e(msg, t);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(ex, msg);
    }

    @Override
    public void w(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void w(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void i(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void i(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void d(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void d(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void v(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void v(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void t(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    @Override
    public void t(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    static {
        TrustManagerFactory trustManagerFactory;
        Companion = new Companion(null);
        sslFactory = new ZitiSSLSocketFactory();
        TrustManagerFactory $this$tm_u24lambda_u241 = trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        boolean bl = false;
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        $this$tm_u24lambda_u241.init(ks);
        tm = trustManagerFactory;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().retryOnConnectionFailure(false);
        SSLSocketFactory sSLSocketFactory = sslFactory;
        TrustManager trustManager = tm.getTrustManagers()[0];
        Intrinsics.checkNotNull((Object)trustManager, (String)"null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        clt = builder.sslSocketFactory(sSLSocketFactory, (X509TrustManager)trustManager).dns(new Dns(){

            public List<InetAddress> lookup(String hostname) {
                Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
                Object[] objectArray = new InetAddress[1];
                InetAddress inetAddress = ZitiDNSManager.INSTANCE.resolve(hostname);
                if (inetAddress == null) {
                    inetAddress = InetAddress.getByName(hostname);
                }
                objectArray[0] = inetAddress;
                return CollectionsKt.mutableListOf((Object[])objectArray);
            }
        }).build();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/openziti/net/internal/ZitiHTTPSConnection$Companion;", "", "<init>", "()V", "sslFactory", "Lorg/openziti/net/ZitiSSLSocketFactory;", "tm", "Ljavax/net/ssl/TrustManagerFactory;", "kotlin.jvm.PlatformType", "getTm", "()Ljavax/net/ssl/TrustManagerFactory;", "Ljavax/net/ssl/TrustManagerFactory;", "clt", "Lokhttp3/OkHttpClient;", "getClt", "()Lokhttp3/OkHttpClient;", "ziti"})
    public static final class Companion {
        private Companion() {
        }

        public final TrustManagerFactory getTm() {
            return tm;
        }

        @NotNull
        public final OkHttpClient getClt() {
            return clt;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

