/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000eH\u0007\u00a8\u0006\u0014"}, d2={"Lorg/openziti/util/IPUtil;", "", "<init>", "()V", "isValidIPv4", "", "host", "", "toIPv4", "", "isValidIPv6", "toIPv6", "maskForPrefix", "size", "", "prefix", "toCanonicalCIDR", "Ljava/net/InetAddress;", "ip", "bits", "ziti"})
@SourceDebugExtension(value={"SMAP\nIPUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IPUtil.kt\norg/openziti/util/IPUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1734#2,2:72\n1736#2:75\n1557#2:76\n1628#2,3:77\n1#3:74\n*S KotlinDebug\n*F\n+ 1 IPUtil.kt\norg/openziti/util/IPUtil\n*L\n27#1:72,2\n27#1:75\n38#1:76\n38#1:77,3\n*E\n"})
public final class IPUtil {
    @NotNull
    public static final IPUtil INSTANCE = new IPUtil();

    private IPUtil() {
    }

    @JvmStatic
    public static final boolean isValidIPv4(@NotNull String host) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            char[] cArray = new char[]{'.'};
            List octets = StringsKt.split$default((CharSequence)host, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (octets.size() != 4) {
                return false;
            }
            Iterable $this$all$iv = octets;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    Integer v;
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    Integer n = v = StringsKt.toIntOrNull((String)it);
                    if (n != null) {
                        int it2 = ((Number)n).intValue();
                        boolean bl4 = false;
                        bl2 = 0 <= v & v <= 255;
                    } else {
                        bl2 = false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] toIPv4(@NotNull String host) {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        char[] cArray = new char[]{'.'};
        List octets = StringsKt.split$default((CharSequence)host, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (!(octets.size() == 4)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Iterable $this$map$iv = octets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.parseInt((String)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void v;
            int it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            if (!(false <= v & v <= 255)) {
                throw new IllegalStateException("Check failed.");
            }
            collection.add((byte)(v & 0xFF));
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }

    @JvmStatic
    public static final boolean isValidIPv6(@NotNull String host) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (((CharSequence)host).length() == 0 || host.charAt(0) != '[') {
            return false;
        }
        IPUtil iPUtil = INSTANCE;
        try {
            IPUtil $this$isValidIPv6_u24lambda_u244 = iPUtil;
            boolean bl = false;
            object = Result.constructor-impl((Object)Inet6Address.getByName(host));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    @JvmStatic
    @NotNull
    public static final byte[] toIPv6(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (!(((CharSequence)host).length() == 0 || host.charAt(0) != '[')) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] byArray = Inet6Address.getByName(host).getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getAddress(...)");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] maskForPrefix(int size, int prefix) {
        byte[] byArray = new byte[size];
        for (int i = 0; i < size; ++i) {
            int n = i;
            byArray[n] = n < prefix / 8 ? -1 : (n == prefix / 8 ? (int)(255 << (n + 1) * 8 - prefix) : 0);
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final InetAddress toCanonicalCIDR(@NotNull InetAddress ip, int bits) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        byte[] bytes = new byte[ip.getAddress().length];
        byte[] mask = IPUtil.maskForPrefix(bytes.length, bits);
        int n = bytes.length;
        for (int i = 0; i < n; ++i) {
            bytes[i] = (byte)(mask[i] & ip.getAddress()[i]);
        }
        InetAddress inetAddress = InetAddress.getByAddress(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getByAddress(...)");
        return inetAddress;
    }
}

