/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.nio;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.AsynchronousSocketChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.nio.AsyncSocketImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB\u001b\b\u0016\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\rB\u001b\b\u0016\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0004\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/openziti/net/nio/AsychChannelSocket;", "Ljava/net/Socket;", "impl", "Lorg/openziti/net/nio/AsyncSocketImpl;", "<init>", "(Lorg/openziti/net/nio/AsyncSocketImpl;)V", "ch", "Ljava/nio/channels/AsynchronousSocketChannel;", "(Ljava/nio/channels/AsynchronousSocketChannel;)V", "host", "", "port", "", "(Ljava/lang/String;I)V", "address", "Ljava/net/InetAddress;", "(Ljava/net/InetAddress;I)V", "getImpl$ziti", "()Lorg/openziti/net/nio/AsyncSocketImpl;", "isConnected", "", "isClosed", "close", "", "getInputStream", "Ljava/io/InputStream;", "getOutputStream", "Ljava/io/OutputStream;", "ziti"})
public final class AsychChannelSocket
extends Socket {
    @NotNull
    private final AsyncSocketImpl impl;

    public AsychChannelSocket(@NotNull AsyncSocketImpl impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        super(impl);
        this.impl = impl;
    }

    public /* synthetic */ AsychChannelSocket(AsyncSocketImpl asyncSocketImpl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            asyncSocketImpl = new AsyncSocketImpl(null, 1, null);
        }
        this(asyncSocketImpl);
    }

    @NotNull
    public final AsyncSocketImpl getImpl$ziti() {
        return this.impl;
    }

    public AsychChannelSocket(@NotNull AsynchronousSocketChannel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        this(new AsyncSocketImpl(ch));
    }

    public AsychChannelSocket(@Nullable String host, int port) {
        this(InetAddress.getByName(host), port);
    }

    public AsychChannelSocket(@Nullable InetAddress address, int port) {
        this(null, 1, null);
        this.connect(new InetSocketAddress(address, port));
    }

    @Override
    public boolean isConnected() {
        return this.impl.getChannel$ziti().getRemoteAddress() != null;
    }

    @Override
    public boolean isClosed() {
        return !this.impl.getChannel$ziti().isOpen();
    }

    @Override
    public void close() {
        this.impl.getChannel$ziti().close();
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        InputStream inputStream = this.impl.getInputStream();
        return new FilterInputStream(this, inputStream){
            final /* synthetic */ AsychChannelSocket this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void close() {
                this.this$0.close();
            }
        };
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        OutputStream outputStream = this.impl.getOutputStream();
        return new FilterOutputStream(this, outputStream){
            final /* synthetic */ AsychChannelSocket this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void close() {
                this.this$0.close();
            }
        };
    }

    public AsychChannelSocket() {
        this(null, 1, null);
    }
}

