/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\t*\u00020\u0011H\u0000\u001a\f\u0010\u0013\u001a\u00020\t*\u00020\u0007H\u0000\u001a\u0014\u0010\u0014\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\tH\u0000\u001a\f\u0010\u0014\u001a\u00020\t*\u00020\rH\u0000\u001a\f\u0010\u0014\u001a\u00020\t*\u00020\u0007H\u0000\u001a\f\u0010\u0014\u001a\u00020\t*\u00020\u0016H\u0000\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0017"}, d2={"cf", "Ljava/security/cert/CertificateFactory;", "kotlin.jvm.PlatformType", "getCf", "()Ljava/security/cert/CertificateFactory;", "readCerts", "", "Ljava/security/cert/X509Certificate;", "pem", "", "pemInput", "Ljava/io/Reader;", "readKey", "Ljava/security/PrivateKey;", "input", "parsePKCS7", "bundle", "", "toHEXString", "fingerprint", "toPEM", "name", "Lorg/bouncycastle/pkcs/PKCS10CertificationRequest;", "ziti"})
@SourceDebugExtension(value={"SMAP\nCerts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Certs.kt\norg/openziti/util/CertsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n808#2,11:151\n*S KotlinDebug\n*F\n+ 1 Certs.kt\norg/openziti/util/CertsKt\n*L\n128#1:151,11\n*E\n"})
public final class CertsKt {
    private static final CertificateFactory cf = CertificateFactory.getInstance("X.509");

    public static final CertificateFactory getCf() {
        return cf;
    }

    @NotNull
    public static final List<X509Certificate> readCerts(@NotNull String pem) {
        Intrinsics.checkNotNullParameter((Object)pem, (String)"pem");
        return CertsKt.readCerts(new StringReader(StringsKt.removePrefix((String)pem, (CharSequence)"pem:")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<X509Certificate> readCerts(@NotNull Reader pemInput) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pemInput, (String)"pemInput");
        Closeable closeable = (Closeable)new PemReader(pemInput);
        Throwable throwable = null;
        try {
            PemReader reader = (PemReader)closeable;
            boolean bl = false;
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence(() -> CertsKt.readCerts$lambda$3$lambda$0(reader)), CertsKt::readCerts$lambda$3$lambda$1), CertsKt::readCerts$lambda$3$lambda$2));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public static final PrivateKey readKey(@NotNull String pem) {
        Intrinsics.checkNotNullParameter((Object)pem, (String)"pem");
        return CertsKt.readKey(new StringReader(StringsKt.removePrefix((String)pem, (CharSequence)"pem:")));
    }

    @NotNull
    public static final PrivateKey readKey(@NotNull Reader input) {
        PrivateKey privateKey;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PEMParser parser = new PEMParser(input);
        Object po = parser.readObject();
        if (po instanceof PEMKeyPair) {
            privateKey = new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)po).getPrivate();
        } else if (po instanceof PrivateKeyInfo) {
            privateKey = new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)po);
        } else {
            throw new IllegalStateException("unsupported key format".toString());
        }
        PrivateKey pk = privateKey;
        Intrinsics.checkNotNull((Object)pk);
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final List<X509Certificate> parsePKCS7(@NotNull byte[] bundle) {
        void $this$filterIsInstanceTo$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        byte[] byArray = Base64.getMimeDecoder().decode(bundle);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        Object object2 = byArray;
        object2 = new ByteArrayInputStream((byte[])object2);
        Object object3 = null;
        try {
            Object input = (ByteArrayInputStream)object2;
            boolean bl = false;
            input = cf.generateCertificates((InputStream)input);
            object = input;
        }
        catch (Throwable bl) {
            object3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"use(...)");
        Iterable $this$filterIsInstance$iv = (Iterable)object;
        boolean $i$f$filterIsInstance = false;
        object3 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof X509Certificate)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String toHEXString(@NotNull byte[] $this$toHEXString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHEXString, (String)"<this>");
        return ArraysKt.joinToString$default((byte[])$this$toHEXString, (CharSequence)"", null, null, (int)0, null, CertsKt::toHEXString$lambda$5, (int)30, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String fingerprint(@NotNull X509Certificate $this$fingerprint) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$fingerprint, (String)"<this>");
        byte[] byArray = $this$fingerprint.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        Object object = byArray;
        object = new ByteArrayInputStream((byte[])object);
        Throwable throwable = null;
        try {
            String string2;
            ByteArrayInputStream stream = (ByteArrayInputStream)object;
            boolean bl = false;
            Closeable closeable = new DigestInputStream(stream, MessageDigest.getInstance("SHA-1"));
            Throwable throwable2 = null;
            try {
                DigestInputStream it = (DigestInputStream)closeable;
                boolean bl2 = false;
                byte[] byArray2 = it.readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
                string2 = CertsKt.toHEXString(byArray2);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            string = string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String toPEM(@NotNull byte[] $this$toPEM, @NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toPEM, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            StringWriter out = (StringWriter)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)new PemWriter((Writer)out);
            Throwable throwable2 = null;
            try {
                PemWriter it = (PemWriter)closeable2;
                boolean bl2 = false;
                it.writeObject((PemObjectGenerator)new PemObject(name, $this$toPEM));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            String string2 = out.toString();
            string = string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
        return string;
    }

    @NotNull
    public static final String toPEM(@NotNull PrivateKey $this$toPEM) {
        Intrinsics.checkNotNullParameter((Object)$this$toPEM, (String)"<this>");
        byte[] byArray = new PKCS8EncodedKeySpec($this$toPEM.getEncoded()).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return CertsKt.toPEM(byArray, "PRIVATE KEY");
    }

    @NotNull
    public static final String toPEM(@NotNull X509Certificate $this$toPEM) {
        Intrinsics.checkNotNullParameter((Object)$this$toPEM, (String)"<this>");
        byte[] byArray = $this$toPEM.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return CertsKt.toPEM(byArray, "CERTIFICATE");
    }

    @NotNull
    public static final String toPEM(@NotNull PKCS10CertificationRequest $this$toPEM) {
        Intrinsics.checkNotNullParameter((Object)$this$toPEM, (String)"<this>");
        byte[] byArray = $this$toPEM.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return CertsKt.toPEM(byArray, "CERTIFICATE REQUEST");
    }

    private static final PemObject readCerts$lambda$3$lambda$0(PemReader $reader) {
        return $reader.readPemObject();
    }

    private static final boolean readCerts$lambda$3$lambda$1(PemObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getType(), (Object)"CERTIFICATE");
    }

    private static final X509Certificate readCerts$lambda$3$lambda$2(PemObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        byte[] byArray = it.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getContent(...)");
        byte[] byArray2 = byArray;
        Certificate certificate = cf.generateCertificate(new ByteArrayInputStream(byArray2));
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        return (X509Certificate)certificate;
    }

    private static final CharSequence toHEXString$lambda$5(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

